/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.item.storage;

import com.github.klikli_dev.occultism.api.common.blockentity.IStorageController;
import com.github.klikli_dev.occultism.api.common.data.GlobalBlockPos;
import com.github.klikli_dev.occultism.common.container.storage.StorageRemoteContainer;
import com.github.klikli_dev.occultism.util.BlockEntityUtil;
import com.github.klikli_dev.occultism.util.CuriosUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkHooks;

public class StorageRemoteItem
extends Item
implements MenuProvider {
    public StorageRemoteItem(Item.Properties properties) {
        super(properties);
    }

    public static IStorageController getStorageController(ItemStack stack, Level level) {
        if (stack.m_41619_()) {
            return null;
        }
        if (!stack.m_41784_().m_128441_("linkedStorageController")) {
            return null;
        }
        GlobalBlockPos globalPos = GlobalBlockPos.from(stack.m_41783_().m_128469_("linkedStorageController"));
        BlockEntity blockEntity = BlockEntityUtil.get(level, globalPos);
        return blockEntity instanceof IStorageController ? (IStorageController)blockEntity : null;
    }

    public Component m_5446_() {
        return new TranslatableComponent(this.m_5524_());
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (!context.m_43725_().f_46443_) {
            ItemStack stack = context.m_43722_();
            BlockEntity blockEntity = context.m_43725_().m_7702_(context.m_8083_());
            if (blockEntity instanceof IStorageController) {
                stack.m_41700_("linkedStorageController", (Tag)GlobalBlockPos.from(blockEntity).serializeNBT());
                context.m_43723_().m_6352_((Component)new TranslatableComponent(this.m_5524_() + ".message.linked"), Util.f_137441_);
            }
        }
        return super.m_6225_(context);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (level.f_46443_ || !stack.m_41784_().m_128441_("linkedStorageController")) {
            return super.m_7203_(level, player, hand);
        }
        GlobalBlockPos storageControllerPos = GlobalBlockPos.from(stack.m_41783_().m_128469_("linkedStorageController"));
        ServerLevel storageControllerWorld = level.m_142572_().m_129880_(storageControllerPos.getDimensionKey());
        if (!storageControllerWorld.m_46805_(storageControllerPos.getPos())) {
            player.m_6352_((Component)new TranslatableComponent(this.m_5524_() + ".message.not_loaded"), Util.f_137441_);
            return super.m_7203_(level, player, hand);
        }
        if (storageControllerWorld.m_7702_(storageControllerPos.getPos()) instanceof IStorageController) {
            NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)this, buffer -> buffer.m_130130_(player.m_150109_().f_35977_));
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        return super.m_7203_(level, player, hand);
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        tooltip.add((Component)new TranslatableComponent(this.m_5524_() + ".tooltip"));
        if (stack.m_41784_().m_128441_("linkedStorageController")) {
            GlobalBlockPos pos = GlobalBlockPos.from(stack.m_41783_().m_128469_("linkedStorageController"));
            tooltip.add((Component)new TranslatableComponent(this.m_5524_() + ".tooltip.linked", new Object[]{pos.toString()}));
        }
    }

    public Rarity m_41460_(ItemStack stack) {
        return stack.m_41784_().m_128441_("linkedStorageController") ? Rarity.RARE : Rarity.COMMON;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player player) {
        CuriosUtil.SelectedCurio selectedCurio = CuriosUtil.getStorageRemote(player);
        if (selectedCurio != null) {
            return new StorageRemoteContainer(id, playerInventory, selectedCurio.selectedSlot);
        }
        return null;
    }
}

