/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.entity;

import com.github.klikli_dev.occultism.common.entity.CthulhuFamiliarEntity;
import com.github.klikli_dev.occultism.common.entity.FamiliarEntity;
import com.github.klikli_dev.occultism.common.entity.GoatFamiliarEntity;
import com.github.klikli_dev.occultism.common.entity.GreedyFamiliarEntity;
import com.github.klikli_dev.occultism.common.entity.ShubNiggurathSpawnEntity;
import com.github.klikli_dev.occultism.registry.OccultismEntities;
import com.google.common.collect.ImmutableList;
import com.mojang.math.Vector3d;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ShubNiggurathFamiliarEntity
extends FamiliarEntity {
    private static final int MAX_SPAWN_TIMER = 200;
    private int spawnTimer = 200;

    public ShubNiggurathFamiliarEntity(EntityType<? extends ShubNiggurathFamiliarEntity> type, Level level) {
        super(type, level);
    }

    public ShubNiggurathFamiliarEntity(Level level, GoatFamiliarEntity goat) {
        this((EntityType<? extends ShubNiggurathFamiliarEntity>)((EntityType)OccultismEntities.SHUB_NIGGURATH_FAMILIAR.get()), level);
        this.setRing(goat.hasRing());
        this.setBeard(goat.hasBeard());
        this.setFamiliarOwner(goat.getFamiliarOwner());
        this.m_6034_(goat.m_20185_(), goat.m_20186_(), goat.m_20189_());
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new FamiliarEntity.SitGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(2, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 8.0f));
        this.f_21345_.m_25352_(3, new GreedyFamiliarEntity.RideFamiliarGoal(this, (EntityType)OccultismEntities.CTHULHU_FAMILIAR.get()));
        this.f_21345_.m_25352_(6, (Goal)new FamiliarEntity.FollowOwnerGoal(this, 1.0, 3.0f, 1.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(9, (Goal)new FollowMobGoal((Mob)this, 1.0, 3.0f, 7.0f));
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            this.rotateTowardsFriend();
            this.createSpawn((LivingEntity)this, new Vector3d(this.m_20208_(2.0), this.m_20187_(), this.m_20262_(2.0)));
        }
    }

    protected float m_5632_(float p_110146_1_, float distance) {
        if ((double)distance > 0.1) {
            this.f_20883_ = this.f_19859_;
            this.f_20885_ = Mth.m_14094_((float)this.f_20885_, (float)this.f_20883_, (float)this.m_8085_());
        }
        return distance;
    }

    public CthulhuFamiliarEntity getCthulhuFriend() {
        if (this.m_20202_() instanceof CthulhuFamiliarEntity) {
            return (CthulhuFamiliarEntity)this.m_20202_();
        }
        return null;
    }

    private void createSpawn(LivingEntity creator, Vector3d pos) {
        if (this.spawnTimer-- < 0) {
            this.spawnTimer = 200;
            ShubNiggurathSpawnEntity spawn = new ShubNiggurathSpawnEntity(creator.f_19853_, creator);
            spawn.m_6034_(pos.f_86214_, pos.f_86215_, pos.f_86216_);
            creator.f_19853_.m_7967_((Entity)spawn);
        }
    }

    private void rotateTowardsFriend() {
        CthulhuFamiliarEntity friend = this.getCthulhuFriend();
        if (friend != null) {
            Vec3 direction = this.m_20182_().m_82505_(friend.m_20182_());
            float rot = (float)Math.toDegrees(Mth.m_14136_((double)direction.f_82481_, (double)direction.f_82479_)) - 50.0f;
            this.f_19859_ = this.f_19859_;
            this.f_20883_ = this.f_19859_ = rot;
            this.f_20884_ = this.f_19859_;
        }
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (this.m_20202_() != null && this.immuneWhileHoldingHand(pSource)) {
            return false;
        }
        if (super.m_6469_(pSource, pAmount)) {
            if (pSource.m_7639_() != null) {
                GoatFamiliarEntity.ringBell(this);
            }
            return true;
        }
        return false;
    }

    private boolean immuneWhileHoldingHand(DamageSource s) {
        return s == DamageSource.f_19311_ || s == DamageSource.f_19312_ || s == DamageSource.f_19315_ || s == DamageSource.f_19322_ || s == DamageSource.f_19316_ || s == DamageSource.f_19310_;
    }

    @Override
    public Iterable<MobEffectInstance> getFamiliarEffects() {
        return ImmutableList.of();
    }

    @Override
    public boolean canBlacksmithUpgrade() {
        return !this.hasBlacksmithUpgrade();
    }

    public boolean hasRing() {
        return this.hasVariant(0);
    }

    private void setRing(boolean b) {
        this.setVariant(0, b);
    }

    public boolean hasBeard() {
        return this.hasVariant(1);
    }

    private void setBeard(boolean b) {
        this.setVariant(1, b);
    }
}

