/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.entity;

import com.github.klikli_dev.occultism.Occultism;
import com.github.klikli_dev.occultism.common.entity.IFamiliar;
import com.github.klikli_dev.occultism.registry.OccultismEffects;
import com.github.klikli_dev.occultism.registry.OccultismItems;
import com.google.common.collect.ImmutableList;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class OtherworldBirdEntity
extends Parrot
implements IFamiliar {
    public static final float MAX_BOOST_DISTANCE = 8.0f;
    public SitWhenOrderedToGoal sitGoal;

    public OtherworldBirdEntity(EntityType<? extends Parrot> type, Level worldIn) {
        super(type, worldIn);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Parrot.m_29438_();
    }

    protected void m_8099_() {
        this.sitGoal = new SitWhenOrderedToGoal((TamableAnimal)this);
        this.f_21345_.m_25352_(0, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(2, (Goal)this.sitGoal);
        this.f_21345_.m_25352_(2, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 5.0f, 1.0f, true));
        this.f_21345_.m_25352_(2, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new FollowMobGoal((Mob)this, 1.0, 3.0f, 7.0f));
    }

    public void m_8107_() {
        LivingEntity owner;
        if (!this.f_19853_.f_46443_ && this.f_19853_.m_46467_() % 10L == 0L && this.m_21824_() && (owner = this.m_142480_()) != null && this.m_20270_((Entity)owner) < 8.0f) {
            for (MobEffectInstance effect : this.getFamiliarEffects()) {
                owner.m_7292_(effect);
            }
        }
        super.m_8107_();
    }

    public void m_21816_(@Nullable UUID ownerId) {
        super.m_21816_(ownerId);
    }

    @Override
    public LivingEntity getFamiliarOwner() {
        return this.m_142480_();
    }

    @Override
    public void setFamiliarOwner(LivingEntity owner) {
        this.m_21816_(owner.m_142081_());
    }

    @Override
    public Entity getFamiliarEntity() {
        return this;
    }

    @Override
    public Iterable<MobEffectInstance> getFamiliarEffects() {
        return ImmutableList.of((Object)new MobEffectInstance(MobEffects.f_19603_, 60, 5, false, false), (Object)new MobEffectInstance(MobEffects.f_19591_, 20 * (Integer)Occultism.SERVER_CONFIG.spiritJobs.drikwingFamiliarSlowFallingSeconds.get(), 0, false, false), (Object)new MobEffectInstance((MobEffect)OccultismEffects.DOUBLE_JUMP.get(), 120, 4, false, false));
    }

    public InteractionResult m_6071_(Player playerIn, InteractionHand hand) {
        ItemStack stack = playerIn.m_21120_(hand);
        if (stack.m_41720_() == OccultismItems.FAMILIAR_RING.get()) {
            return stack.m_41647_(playerIn, (LivingEntity)this, hand);
        }
        return super.m_6071_(playerIn, hand);
    }
}

