/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.entity;

import com.github.klikli_dev.occultism.common.advancement.FamiliarTrigger;
import com.github.klikli_dev.occultism.common.entity.FamiliarEntity;
import com.github.klikli_dev.occultism.registry.OccultismAdvancements;
import com.github.klikli_dev.occultism.registry.OccultismEntities;
import com.google.common.collect.ImmutableList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;

public class GreedyFamiliarEntity
extends FamiliarEntity {
    private static final EntityDataAccessor<Optional<BlockPos>> TARGET_BLOCK = SynchedEntityData.m_135353_(GreedyFamiliarEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135039_);
    private float earRotZ;
    private float earRotZ0;
    private float earRotX;
    private float earRotX0;
    private float peekRot;
    private float peekRot0;
    private float monsterRot;
    private float monsterRot0;
    private int monsterAnimTimer = this.m_21187_().nextInt(100);

    public GreedyFamiliarEntity(EntityType<? extends GreedyFamiliarEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new FamiliarEntity.SitGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new FindBlockGoal(this));
        this.f_21345_.m_25352_(3, new RideFamiliarGoal(this, (EntityType)OccultismEntities.DRAGON_FAMILIAR.get()));
        this.f_21345_.m_25352_(4, (Goal)new FindItemGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(5, (Goal)new FamiliarEntity.FollowOwnerGoal(this, 1.0, 3.0f, 1.0f));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new FollowMobGoal((Mob)this, 1.0, 3.0f, 7.0f));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TARGET_BLOCK, Optional.empty());
    }

    public Optional<BlockPos> getTargetBlock() {
        return (Optional)this.f_19804_.m_135370_(TARGET_BLOCK);
    }

    private void setTargetBlock(Optional<BlockPos> pos) {
        this.f_19804_.m_135381_(TARGET_BLOCK, pos);
    }

    @Override
    public Iterable<MobEffectInstance> getFamiliarEffects() {
        return ImmutableList.of();
    }

    @Override
    public void curioTick(LivingEntity wearer) {
        if (!(wearer instanceof Player)) {
            return;
        }
        if (this.isEffectEnabled(wearer)) {
            for (ItemEntity e : wearer.f_19853_.m_6443_(ItemEntity.class, wearer.m_142469_().m_82400_(5.0), Entity::m_6084_)) {
                ItemStack stack = e.m_32055_();
                boolean isStackDemagnetized = stack.m_41782_() && stack.m_41783_().m_128471_("PreventRemoteMovement");
                boolean isEntityDemagnetized = e.getPersistentData().m_128471_("PreventRemoteMovement");
                if (isStackDemagnetized || isEntityDemagnetized) continue;
                e.m_6123_((Player)wearer);
            }
        }
    }

    public void m_8119_() {
        super.m_8119_();
        this.earRotX0 = this.earRotX;
        this.earRotZ0 = this.earRotZ;
        if (this.f_19853_.f_46443_) {
            Optional<BlockPos> targetBlock = this.getTargetBlock();
            if (targetBlock.isPresent()) {
                Vec3 p = Vec3.m_82512_((Vec3i)((Vec3i)targetBlock.get()));
                float endZRot = -0.5f;
                if (Math.abs(p.f_82480_ - this.m_20188_()) > 1.0) {
                    endZRot = p.f_82480_ > this.m_20188_() ? 0.0f : -2.0f;
                }
                this.earRotZ = Mth.m_14179_((float)0.1f, (float)this.earRotZ, (float)endZRot);
                Vec3 look = this.m_20252_(1.0f);
                Vec3 toTarget = p.m_82505_(this.m_20182_()).m_82541_();
                toTarget = new Vec3(toTarget.f_82479_, 0.0, toTarget.f_82481_);
                float endXRot = toTarget.m_82526_(look) < 0.0 ? 1.0f : -1.0f;
                this.earRotX = Mth.m_14179_((float)0.1f, (float)this.earRotX, (float)endXRot);
            } else {
                this.earRotX = Mth.m_14179_((float)0.1f, (float)this.earRotX, (float)0.0f);
                this.earRotZ = Mth.m_14179_((float)0.1f, (float)this.earRotZ, (float)-0.5f);
            }
            ++this.monsterAnimTimer;
            this.peekRot0 = this.peekRot;
            this.monsterRot0 = this.monsterRot;
            if (this.monsterAnimTimer % 300 < 200) {
                float peekTimer = this.monsterAnimTimer % 300 % 200;
                if (peekTimer > 30.0f && peekTimer < 50.0f) {
                    this.monsterRot = Mth.m_14179_((float)0.3f, (float)this.monsterRot, (float)this.toRad(37.0f));
                } else if (peekTimer > 50.0f && peekTimer < 70.0f) {
                    this.monsterRot = Mth.m_14179_((float)0.3f, (float)this.monsterRot, (float)this.toRad(-37.0f));
                } else if (peekTimer > 70.0f) {
                    this.monsterRot = Mth.m_14179_((float)0.3f, (float)this.monsterRot, (float)0.0f);
                }
                this.peekRot = peekTimer < 100.0f ? Mth.m_14179_((float)0.1f, (float)this.peekRot, (float)this.toRad(46.0f)) : Mth.m_14179_((float)0.1f, (float)this.peekRot, (float)0.0f);
            } else {
                this.peekRot = 0.0f;
                this.monsterRot = 0.0f;
            }
        }
    }

    private float toRad(float deg) {
        return (float)Math.toRadians(deg);
    }

    public float getLidRot(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.peekRot0, (float)this.peekRot);
    }

    public float getMonsterRot(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.monsterRot0, (float)this.monsterRot);
    }

    public float getEarRotZ(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.earRotZ0, (float)this.earRotZ);
    }

    public float getEarRotX(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.earRotX0, (float)this.earRotX);
    }

    @Override
    public boolean canBlacksmithUpgrade() {
        return !this.hasBlacksmithUpgrade();
    }

    @Override
    protected InteractionResult m_6071_(Player playerIn, InteractionHand hand) {
        ItemStack stack = playerIn.m_21120_(hand);
        if (this.hasBlacksmithUpgrade() && !this.m_21206_().m_41619_()) {
            ItemHandlerHelper.giveItemToPlayer((Player)playerIn, (ItemStack)this.m_21206_());
            this.m_21008_(InteractionHand.OFF_HAND, ItemStack.f_41583_);
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        if (this.hasBlacksmithUpgrade() && stack.m_41720_() instanceof BlockItem) {
            this.m_21008_(InteractionHand.OFF_HAND, new ItemStack((ItemLike)stack.m_41720_()));
            stack.m_41774_(1);
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return super.m_6071_(playerIn, hand);
    }

    private static class FindBlockGoal
    extends MoveToBlockGoal {
        GreedyFamiliarEntity greedy;

        public FindBlockGoal(GreedyFamiliarEntity greedy) {
            super((PathfinderMob)greedy, 1.0, 10, 5);
            this.greedy = greedy;
        }

        public boolean m_8036_() {
            return super.m_8036_() && !this.f_25598_.m_21206_().m_41619_();
        }

        public boolean m_8045_() {
            return super.m_8045_() && !this.f_25598_.m_21206_().m_41619_();
        }

        protected boolean m_6465_(LevelReader pLevel, BlockPos pPos) {
            ItemStack offhand = this.f_25598_.m_21206_();
            return pLevel.m_8055_(pPos).m_60734_() == Block.m_49814_((Item)offhand.m_41720_());
        }

        public void m_8056_() {
            super.m_8056_();
            this.greedy.setTargetBlock(Optional.of(this.f_25602_));
        }

        public void m_8041_() {
            super.m_8041_();
            this.greedy.setTargetBlock(Optional.empty());
        }

        protected BlockPos m_6669_() {
            return this.f_25602_;
        }
    }

    public static class RideFamiliarGoal<T extends FamiliarEntity>
    extends Goal {
        private final FamiliarEntity rider;
        private EntityType<T> type;
        private FamiliarEntity mount;

        public RideFamiliarGoal(FamiliarEntity rider, EntityType<T> type) {
            this.rider = rider;
            this.type = type;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
        }

        public boolean m_8036_() {
            if (this.rider.m_20202_() != null && this.rider.m_20202_().m_6095_() == this.type) {
                return true;
            }
            FamiliarEntity mount = this.findMount();
            if (mount != null) {
                this.mount = mount;
                this.rider.m_21573_().m_5624_((Entity)mount, 1.0);
                return true;
            }
            return false;
        }

        public boolean m_8045_() {
            return this.rider.m_20202_() != null && this.rider.m_20202_().m_6095_() == this.type || this.rider.m_21691_() && this.mount != null;
        }

        public void m_8041_() {
            this.rider.m_8127_();
            this.mount = null;
        }

        public void m_8037_() {
            if (this.mount != null && this.rider.m_20280_((Entity)this.mount) < 5.0 && !this.mount.m_20363_((Entity)this.rider)) {
                this.rider.m_20329_((Entity)this.mount);
                this.mount.m_21573_().m_26573_();
                if (this.rider.m_6095_() == OccultismEntities.SHUB_NIGGURATH_FAMILIAR.get() && this.type == OccultismEntities.CTHULHU_FAMILIAR.get()) {
                    OccultismAdvancements.FAMILIAR.trigger(this.rider.getFamiliarOwner(), FamiliarTrigger.Type.SHUB_CTHULHU_FRIENDS);
                }
            }
        }

        private FamiliarEntity findMount() {
            LivingEntity owner = this.rider.getOwner();
            if (owner == null) {
                return null;
            }
            List mounts = this.rider.f_19853_.m_142425_(this.type, this.rider.m_142469_().m_82400_(5.0), e -> e.getFamiliarOwner() == owner && !e.m_20160_() && !e.isSitting());
            if (mounts.isEmpty()) {
                return null;
            }
            return (FamiliarEntity)mounts.get(0);
        }
    }

    public static class FindItemGoal
    extends Goal {
        private static final double RANGE = 12.0;
        private final FamiliarEntity entity;

        public FindItemGoal(FamiliarEntity entity) {
            this.entity = entity;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return this.getNearbyItem() != null && this.entity.getFamiliarOwner() instanceof Player;
        }

        public void m_8056_() {
            ItemEntity item = this.getNearbyItem();
            if (item != null) {
                this.entity.m_21573_().m_5624_((Entity)item, 1.2);
            }
        }

        public void m_8037_() {
            ItemEntity item = this.getNearbyItem();
            if (item != null) {
                this.entity.m_21573_().m_5624_((Entity)item, 1.2);
                LivingEntity owner = this.entity.getFamiliarOwner();
                if (item.m_20280_((Entity)this.entity) < 4.0 && owner instanceof Player) {
                    Player player = (Player)owner;
                    item.m_6123_(player);
                    OccultismAdvancements.FAMILIAR.trigger(owner, FamiliarTrigger.Type.GREEDY_ITEM);
                }
            }
        }

        private ItemEntity getNearbyItem() {
            LivingEntity owner = this.entity.getFamiliarOwner();
            if (!(owner instanceof Player)) {
                return null;
            }
            Player player = (Player)owner;
            PlayerMainInvWrapper inv = new PlayerMainInvWrapper(player.m_150109_());
            for (ItemEntity item : this.entity.f_19853_.m_6443_(ItemEntity.class, this.entity.m_142469_().m_82400_(12.0), e -> e.m_6084_())) {
                ItemStack stack = item.m_32055_();
                boolean isStackDemagnetized = stack.m_41782_() && stack.m_41783_().m_128471_("PreventRemoteMovement");
                boolean isEntityDemagnetized = item.getPersistentData().m_128471_("PreventRemoteMovement");
                if (isStackDemagnetized || isEntityDemagnetized || ItemHandlerHelper.insertItemStacked((IItemHandler)inv, (ItemStack)stack, (boolean)true).m_41613_() == stack.m_41613_()) continue;
                return item;
            }
            return null;
        }
    }
}

