/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.entity;

import com.github.klikli_dev.occultism.common.advancement.FamiliarTrigger;
import com.github.klikli_dev.occultism.common.entity.DevilFamiliarEntity;
import com.github.klikli_dev.occultism.common.entity.FamiliarEntity;
import com.github.klikli_dev.occultism.registry.OccultismAdvancements;
import com.github.klikli_dev.occultism.registry.OccultismBlocks;
import com.google.common.collect.ImmutableList;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;

public class CthulhuFamiliarEntity
extends FamiliarEntity {
    private final WaterBoundPathNavigation waterNavigator;
    private final GroundPathNavigation groundNavigator;
    public float riderRot;
    public float riderRot0;
    public float riderLimbSwingAmount;
    public float riderLimbSwing;
    private BlockPos lightPos;
    private BlockPos lightPos0;
    private int lightTimer;

    public CthulhuFamiliarEntity(EntityType<? extends CthulhuFamiliarEntity> type, Level level) {
        super(type, level);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.waterNavigator = new WaterBoundPathNavigation((Mob)this, level);
        this.groundNavigator = new GroundPathNavigation((Mob)this, level);
        this.f_21342_ = new MoveController(this);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return FamiliarEntity.m_21552_().m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 1.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FamiliarEntity.SitGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(3, (Goal)new FollowOwnerWaterGoal(this, 1.0, 3.0f, 1.0f));
        this.f_21345_.m_25352_(4, (Goal)new GiveFlowerGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
    }

    @Override
    public void setFamiliarOwner(LivingEntity owner) {
        if (this.hasHat()) {
            OccultismAdvancements.FAMILIAR.trigger(owner, FamiliarTrigger.Type.RARE_VARIANT);
        }
        super.setFamiliarOwner(owner);
    }

    @Override
    public boolean canBlacksmithUpgrade() {
        return !this.hasBlacksmithUpgrade();
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.isAngry() && this.m_21187_().nextDouble() < 7.0E-4) {
            this.setAngry(false);
        }
        this.riderRot0 = this.riderRot;
        this.riderRot = Mth.m_14148_((float)this.riderRot, (float)this.f_19859_, (float)10.0f);
        if (!this.f_19853_.f_46443_) {
            --this.lightTimer;
            if (this.lightTimer < 0) {
                this.lightTimer = 10;
                if (this.lightPos == null) {
                    this.lightPos = this.m_142538_();
                }
                this.updateLight();
            }
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        this.setHat(this.m_21187_().nextDouble() < 0.1);
        this.setTrunk(this.m_21187_().nextDouble() < 0.5);
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    protected void m_6089_() {
        this.removeLight(this.lightPos);
        this.removeLight(this.lightPos0);
        this.lightPos = null;
        this.lightPos0 = null;
        super.m_6089_();
    }

    private Vec3 riderLocation() {
        return Vec3.m_82498_((float)0.0f, (float)this.riderRot).m_82524_(230.0f).m_82490_(0.68).m_82549_(this.m_20182_());
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public float getAnimationHeight(float partialTicks) {
        return Mth.m_14089_((float)(((float)this.f_19797_ + partialTicks) / 5.0f));
    }

    public float riderRot(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.riderRot0, (float)this.riderRot);
    }

    private void updateLight() {
        this.removeLight(this.lightPos0);
        this.lightPos0 = null;
        if (this.lightPos != this.m_142538_()) {
            this.lightPos0 = this.lightPos;
            this.lightPos = this.m_142538_();
        }
        if (this.f_19853_.m_46859_(this.lightPos) && this.m_6084_() && this.hasBlacksmithUpgrade()) {
            this.f_19853_.m_46597_(this.lightPos, ((Block)OccultismBlocks.LIGHTED_AIR.get()).m_49966_());
        }
    }

    private void removeLight(BlockPos pos) {
        if (!this.f_19853_.f_46443_ && pos != null && this.f_19853_.m_8055_(pos).m_60734_() == OccultismBlocks.LIGHTED_AIR.get()) {
            this.f_19853_.m_46597_(pos, Blocks.f_50016_.m_49966_());
        }
    }

    public void m_142687_(Entity.RemovalReason reason) {
        this.removeLight(this.lightPos);
        this.removeLight(this.lightPos0);
        this.lightPos = null;
        this.lightPos0 = null;
        super.m_142687_(reason);
    }

    protected void m_7355_(BlockPos pPos, BlockState pBlock) {
    }

    public void m_5844_() {
        if (!this.f_19853_.f_46443_) {
            if (this.m_20069_()) {
                this.f_21344_ = this.waterNavigator;
                this.m_20282_(true);
            } else {
                this.f_21344_ = this.groundNavigator;
                this.m_20282_(false);
            }
        }
    }

    public void m_7332_(Entity pPassenger) {
        if (this.m_20363_(pPassenger)) {
            Vec3 direction = this.riderLocation();
            pPassenger.m_6034_(direction.f_82479_, direction.f_82480_, direction.f_82481_);
        }
    }

    public Vec3 m_7688_(LivingEntity pLivingEntity) {
        return this.riderLocation();
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (super.m_6469_(source, amount)) {
            if (source.m_7639_() == this.getFamiliarOwner()) {
                this.setAngry(true);
                this.setSitting(true);
                OccultismAdvancements.FAMILIAR.trigger(this.getFamiliarOwner(), FamiliarTrigger.Type.CTHULHU_SAD);
            } else if (source.m_7639_() != null) {
                Vec3 tp = DefaultRandomPos.m_148403_((PathfinderMob)this, (int)8, (int)4);
                if (tp != null) {
                    this.m_19890_(tp.m_7096_() + 0.5, tp.m_7098_(), tp.m_7094_() + 0.5, this.f_19859_, this.f_19860_);
                }
                this.f_21344_.m_26573_();
            }
            return true;
        }
        return false;
    }

    public void m_6667_(DamageSource pCause) {
        this.removeLight(this.lightPos);
        this.removeLight(this.lightPos0);
        this.lightPos = null;
        this.lightPos0 = null;
        super.m_6667_(pCause);
    }

    public boolean m_142535_(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    @Override
    public Iterable<MobEffectInstance> getFamiliarEffects() {
        return ImmutableList.of((Object)new MobEffectInstance(MobEffects.f_19608_, 300, 0, false, false));
    }

    public boolean hasHat() {
        return this.hasVariant(0);
    }

    private void setHat(boolean b) {
        this.setVariant(0, b);
    }

    public boolean hasTrunk() {
        return this.hasVariant(1);
    }

    private void setTrunk(boolean b) {
        this.setVariant(1, b);
    }

    public boolean isAngry() {
        return this.hasVariant(2);
    }

    private void setAngry(boolean b) {
        this.setVariant(2, b);
    }

    public boolean isGiving() {
        return this.hasVariant(3);
    }

    private void setGiving(boolean b) {
        this.setVariant(3, b);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (!compound.m_128441_("variants")) {
            this.setHat(compound.m_128471_("hasHat"));
            this.setTrunk(compound.m_128471_("hasTrunk"));
            this.setAngry(compound.m_128471_("isAngry"));
        }
        if (compound.m_128441_("lightPos")) {
            this.lightPos = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("lightPos"));
        }
        if (compound.m_128441_("lightPos0")) {
            this.lightPos0 = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("lightPos0"));
        }
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.lightPos != null) {
            compound.m_128365_("lightPos", (Tag)NbtUtils.m_129224_((BlockPos)this.lightPos));
        }
        if (this.lightPos0 != null) {
            compound.m_128365_("lightPos0", (Tag)NbtUtils.m_129224_((BlockPos)this.lightPos0));
        }
    }

    public static class MoveController
    extends MoveControl {
        private final FamiliarEntity familiar;

        MoveController(FamiliarEntity familiar) {
            super((Mob)familiar);
            this.familiar = familiar;
        }

        public void m_8126_() {
            if (this.familiar.m_20069_()) {
                this.familiar.m_20256_(this.familiar.m_20184_().m_82520_(0.0, 0.005, 0.0));
                if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                    float maxSpeed = (float)(this.f_24978_ * this.familiar.m_21133_(Attributes.f_22279_)) * 3.0f;
                    this.familiar.m_7910_(Mth.m_14179_((float)0.125f, (float)this.familiar.m_6113_(), (float)maxSpeed));
                    double dx = this.f_24975_ - this.familiar.m_20185_();
                    double dy = this.f_24976_ - this.familiar.m_20186_();
                    double dz = this.f_24977_ - this.familiar.m_20189_();
                    double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
                    if (distance < 0.1) {
                        this.familiar.m_21564_(0.0f);
                        return;
                    }
                    if (Math.abs(dy) > 1.0E-4) {
                        this.familiar.m_20256_(this.familiar.m_20184_().m_82520_(0.0, (double)this.familiar.m_6113_() * (dy / distance) * 0.1, 0.0));
                    }
                    if (Math.abs(dx) > 1.0E-4 || Math.abs(dz) > 1.0E-4) {
                        float rotate = (float)(Mth.m_14136_((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
                        this.familiar.f_20883_ = this.familiar.f_19859_ = this.m_24991_(this.familiar.f_19859_, rotate, 8.0f);
                    }
                } else {
                    this.familiar.m_7910_(0.0f);
                }
            } else {
                super.m_8126_();
            }
        }
    }

    public static class FollowOwnerWaterGoal
    extends FamiliarEntity.FollowOwnerGoal {
        public FollowOwnerWaterGoal(FamiliarEntity entity, double speed, float minDist, float maxDist) {
            super(entity, speed, minDist, maxDist);
        }

        @Override
        protected boolean shouldTeleport(LivingEntity owner) {
            return !this.entity.f_19853_.m_46801_(owner.m_142538_()) && this.entity.m_20069_();
        }
    }

    private static class GiveFlowerGoal
    extends Goal {
        private static final int MAX_COOLDOWN = 6000;
        private final CthulhuFamiliarEntity cthulhu;
        private DevilFamiliarEntity devil;
        private int cooldown = 6000;

        public GiveFlowerGoal(CthulhuFamiliarEntity cthulhu) {
            this.cthulhu = cthulhu;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            this.devil = this.findDevil();
            return this.devil != null && this.cooldown-- < 0 && this.cthulhu.m_20280_((Entity)this.devil) > 3.0 && !this.cthulhu.m_20160_();
        }

        public boolean m_8045_() {
            return this.devil != null && this.cthulhu.m_21691_() && !this.cthulhu.m_20160_();
        }

        public void m_8037_() {
            if (this.cthulhu.m_20280_((Entity)this.devil) < 2.0) {
                ((ServerLevel)this.cthulhu.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123750_, (double)this.devil.m_146903_(), (double)(this.devil.m_146904_() + 1), (double)this.devil.m_146907_(), 1, 0.0, 0.0, 0.0, 1.0);
                this.devil = null;
            }
        }

        public void startExecuting() {
            this.cthulhu.m_21573_().m_5624_((Entity)this.devil, 0.3);
            this.cthulhu.setGiving(true);
        }

        public void resetTask() {
            this.cthulhu.setGiving(false);
            this.cthulhu.m_21573_().m_26573_();
            this.cooldown = 6000;
            this.devil = null;
        }

        private DevilFamiliarEntity findDevil() {
            List devils = this.cthulhu.f_19853_.m_45976_(DevilFamiliarEntity.class, this.cthulhu.m_142469_().m_82400_(4.0));
            return devils.isEmpty() ? null : (DevilFamiliarEntity)devils.get(0);
        }
    }
}

