/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.capability;

import com.github.klikli_dev.occultism.common.entity.IFamiliar;
import com.github.klikli_dev.occultism.registry.OccultismCapabilities;
import com.github.klikli_dev.occultism.registry.OccultismEntities;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;

public class FamiliarSettingsCapability
implements INBTSerializable<CompoundTag> {
    private static ImmutableList<EntityType<? extends IFamiliar>> familiars = null;
    private final Map<EntityType<?>, Boolean> familiarEnabled = new HashMap();

    public FamiliarSettingsCapability() {
        for (EntityType<? extends IFamiliar> familiar : FamiliarSettingsCapability.getFamiliars()) {
            this.familiarEnabled.put(familiar, true);
        }
    }

    public static List<EntityType<? extends IFamiliar>> getFamiliars() {
        if (familiars == null) {
            familiars = ImmutableList.of((Object)((EntityType)OccultismEntities.GREEDY_FAMILIAR_TYPE.get()), (Object)((EntityType)OccultismEntities.OTHERWORLD_BIRD_TYPE.get()), (Object)((EntityType)OccultismEntities.BAT_FAMILIAR_TYPE.get()), (Object)((EntityType)OccultismEntities.DEER_FAMILIAR_TYPE.get()), (Object)((EntityType)OccultismEntities.CTHULHU_FAMILIAR_TYPE.get()), (Object)((EntityType)OccultismEntities.DEVIL_FAMILIAR_TYPE.get()), (Object)((EntityType)OccultismEntities.DRAGON_FAMILIAR_TYPE.get()), (Object)((EntityType)OccultismEntities.BLACKSMITH_FAMILIAR_TYPE.get()), (Object)((EntityType)OccultismEntities.GUARDIAN_FAMILIAR_TYPE.get()), (Object)((EntityType)OccultismEntities.HEADLESS_FAMILIAR_TYPE.get()), (Object)((EntityType)OccultismEntities.CHIMERA_FAMILIAR_TYPE.get()), (Object)((EntityType)OccultismEntities.GOAT_FAMILIAR_TYPE.get()), (Object[])new EntityType[]{(EntityType)OccultismEntities.SHUB_NIGGURATH_FAMILIAR_TYPE.get(), (EntityType)OccultismEntities.BEHOLDER_FAMILIAR_TYPE.get(), (EntityType)OccultismEntities.FAIRY_FAMILIAR_TYPE.get(), (EntityType)OccultismEntities.MUMMY_FAMILIAR_TYPE.get(), (EntityType)OccultismEntities.BEAVER_FAMILIAR_TYPE.get()});
        }
        return familiars;
    }

    public void clone(FamiliarSettingsCapability settings) {
        for (Map.Entry<EntityType<?>, Boolean> entry : settings.familiarEnabled.entrySet()) {
            this.familiarEnabled.put(entry.getKey(), entry.getValue());
        }
    }

    public void setFamiliarEnabled(EntityType<?> familiar, boolean b) {
        this.familiarEnabled.put(familiar, b);
    }

    public boolean isFamiliarEnabled(EntityType<?> familiar) {
        return this.familiarEnabled.get(familiar);
    }

    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        for (Map.Entry<EntityType<?>, Boolean> entry : this.familiarEnabled.entrySet()) {
            compound.m_128379_(entry.getKey().getRegistryName().m_135815_(), entry.getValue().booleanValue());
        }
        return compound;
    }

    public void deserializeNBT(CompoundTag nbt) {
        for (EntityType<? extends IFamiliar> familiar : FamiliarSettingsCapability.getFamiliars()) {
            if (!nbt.m_128441_(familiar.getRegistryName().m_135815_())) continue;
            this.familiarEnabled.put(familiar, nbt.m_128471_(familiar.getRegistryName().m_135815_()));
        }
    }

    public static class Dispatcher
    implements ICapabilitySerializable<CompoundTag> {
        private final LazyOptional<FamiliarSettingsCapability> familiarSettingsCapability = LazyOptional.of(FamiliarSettingsCapability::new);

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            if (cap == OccultismCapabilities.FAMILIAR_SETTINGS) {
                return this.familiarSettingsCapability.cast();
            }
            return LazyOptional.empty();
        }

        public CompoundTag serializeNBT() {
            return this.familiarSettingsCapability.map(FamiliarSettingsCapability::serializeNBT).orElse(new CompoundTag());
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.familiarSettingsCapability.ifPresent(capability -> capability.deserializeNBT(nbt));
        }
    }
}

