/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.client.model.entity;

import com.github.klikli_dev.occultism.common.entity.GreedyFamiliarEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class GreedyFamiliarModel
extends EntityModel<GreedyFamiliarEntity> {
    private static final float PI = (float)Math.PI;
    public ModelPart body;
    public ModelPart rightArm;
    public ModelPart chest1;
    public ModelPart leftArm;
    public ModelPart rightLeg;
    public ModelPart leftLeg;
    public ModelPart head;
    public ModelPart chest2;
    public ModelPart monster;
    public ModelPart monsterLeftEye;
    public ModelPart monsterRightEye;
    public ModelPart monsterLeftEar;
    public ModelPart monsterRightEar;
    public ModelPart leftEar;
    public ModelPart rightEar;
    public ModelPart nose;

    public GreedyFamiliarModel(ModelPart part) {
        this.body = part.m_171324_("body");
        this.rightArm = this.body.m_171324_("rightArm");
        this.chest1 = this.body.m_171324_("chest1");
        this.leftArm = this.body.m_171324_("leftArm");
        this.rightLeg = this.body.m_171324_("rightLeg");
        this.leftLeg = this.body.m_171324_("leftLeg");
        this.head = this.body.m_171324_("head");
        this.chest2 = this.chest1.m_171324_("chest2");
        this.monster = this.chest1.m_171324_("monster");
        this.monsterLeftEye = this.monster.m_171324_("monsterLeftEye");
        this.monsterRightEye = this.monster.m_171324_("monsterRightEye");
        this.monsterLeftEar = this.monster.m_171324_("monsterLeftEar");
        this.monsterRightEar = this.monster.m_171324_("monsterRightEar");
        this.leftEar = this.head.m_171324_("leftEar");
        this.rightEar = this.head.m_171324_("rightEar");
        this.nose = this.head.m_171324_("nose");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition parts = mesh.m_171576_();
        PartDefinition body = parts.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 10).m_171506_(-2.5f, -5.0f, -1.5f, 5.0f, 5.0f, 3.0f, false), PartPose.m_171423_((float)0.0f, (float)19.0f, (float)0.6f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightArm = body.m_171599_("rightArm", CubeListBuilder.m_171558_().m_171514_(16, 21).m_171506_(-2.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, true), PartPose.m_171423_((float)-2.5f, (float)-5.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition chest1 = body.m_171599_("chest1", CubeListBuilder.m_171558_().m_171514_(12, 14).m_171506_(-2.0f, -3.0f, 0.0f, 4.0f, 3.0f, 4.0f, false), PartPose.m_171423_((float)0.0f, (float)0.5f, (float)1.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftArm = body.m_171599_("leftArm", CubeListBuilder.m_171558_().m_171514_(16, 21).m_171506_(0.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, false), PartPose.m_171423_((float)2.5f, (float)-5.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightLeg = body.m_171599_("rightLeg", CubeListBuilder.m_171558_().m_171514_(8, 24).m_171506_(-1.0f, 0.0f, -1.0f, 2.0f, 5.0f, 2.0f, true), PartPose.m_171423_((float)-1.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftLeg = body.m_171599_("leftLeg", CubeListBuilder.m_171558_().m_171514_(8, 24).m_171506_(-1.0f, 0.0f, -1.0f, 2.0f, 5.0f, 2.0f, false), PartPose.m_171423_((float)1.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171506_(-2.5f, -5.0f, -2.5f, 5.0f, 5.0f, 5.0f, false), PartPose.m_171423_((float)0.0f, (float)-5.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition chest2 = chest1.m_171599_("chest2", CubeListBuilder.m_171558_().m_171514_(0, 18).m_171506_(-2.0f, -2.0f, 0.0f, 4.0f, 2.0f, 4.0f, false), PartPose.m_171423_((float)0.0f, (float)-3.0f, (float)0.0f, (float)1.0555751f, (float)0.0f, (float)0.0f));
        PartDefinition monster = chest1.m_171599_("monster", CubeListBuilder.m_171558_().m_171514_(15, 0).m_171506_(-1.0f, -2.0f, 0.0f, 2.0f, 2.0f, 2.0f, false), PartPose.m_171423_((float)0.0f, (float)-2.0f, (float)1.5f, (float)0.1563815f, (float)-0.11728612f, (float)0.0f));
        PartDefinition monsterLeftEye = monster.m_171599_("monsterLeftEye", CubeListBuilder.m_171558_().m_171514_(21, 0).m_171506_(-0.5f, -0.5f, -0.5f, 1.0f, 1.0f, 1.0f, false), PartPose.m_171423_((float)-0.8f, (float)-1.8f, (float)1.8f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition monsterRightEye = monster.m_171599_("monsterRightEye", CubeListBuilder.m_171558_().m_171514_(21, 0).m_171506_(-0.5f, -0.5f, -0.5f, 1.0f, 1.0f, 1.0f, true), PartPose.m_171423_((float)0.8f, (float)-1.8f, (float)1.8f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition monsterLeftEar = monster.m_171599_("monsterLeftEar", CubeListBuilder.m_171558_().m_171514_(24, 0).m_171506_(-1.0f, -1.0f, 0.0f, 1.0f, 1.0f, 0.0f, false), PartPose.m_171423_((float)-0.6f, (float)-1.6f, (float)0.3f, (float)-0.312763f, (float)0.07819075f, (float)-0.35185838f));
        PartDefinition monsterRightEar = monster.m_171599_("monsterRightEar", CubeListBuilder.m_171558_().m_171514_(24, 0).m_171506_(0.0f, -1.0f, 0.0f, 1.0f, 1.0f, 0.0f, false), PartPose.m_171423_((float)0.6f, (float)-1.6f, (float)0.3f, (float)-0.312763f, (float)0.07819075f, (float)0.35185838f));
        PartDefinition leftEar = head.m_171599_("leftEar", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171506_(-1.0f, -3.0f, 0.0f, 2.0f, 3.0f, 0.0f, false), PartPose.m_171423_((float)2.0f, (float)-4.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.5235988f));
        PartDefinition rightEar = head.m_171599_("rightEar", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171506_(-1.0f, -3.0f, 0.0f, 2.0f, 3.0f, 0.0f, true), PartPose.m_171423_((float)-2.0f, (float)-4.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.5235988f));
        PartDefinition nose = head.m_171599_("nose", CubeListBuilder.m_171558_().m_171514_(18, 8).m_171506_(-1.0f, 0.0f, -2.0f, 2.0f, 2.0f, 2.0f, false), PartPose.m_171423_((float)0.0f, (float)-3.0f, (float)-2.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)32, (int)32);
    }

    public void m_7695_(PoseStack pPoseStack, VertexConsumer pBuffer, int pPackedLight, int pPackedOverlay, float red, float green, float blue, float alpha) {
        this.body.m_104306_(pPoseStack, pBuffer, pPackedLight, pPackedOverlay, red, green, blue, alpha);
    }

    private float toRad(float deg) {
        return (float)Math.toRadians(deg);
    }

    public void prepareMobModel(GreedyFamiliarEntity pEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTick) {
        this.leftEar.f_104205_ = -pEntity.getEarRotZ(pPartialTick);
        this.rightEar.f_104205_ = pEntity.getEarRotZ(pPartialTick);
        this.leftEar.f_104203_ = pEntity.getEarRotX(pPartialTick);
        this.rightEar.f_104203_ = pEntity.getEarRotX(pPartialTick);
        float ageInTicks = (float)pEntity.f_19797_ + pPartialTick;
        if (!pEntity.isPartying()) {
            this.chest2.f_104203_ = pEntity.getLidRot(pPartialTick);
            this.monster.f_104201_ = -0.2f - pEntity.getLidRot(pPartialTick) * 3.0f;
            this.monster.f_104204_ = pEntity.getMonsterRot(pPartialTick);
            this.monster.f_104203_ = 0.0f;
        } else {
            this.chest2.f_104203_ = this.toRad(40.0f);
            this.monster.f_104201_ = -2.5f;
            this.monster.f_104204_ = 0.0f;
            this.monster.f_104203_ = Mth.m_14089_((float)ageInTicks) * this.toRad(15.0f);
        }
    }

    public void setupAnim(GreedyFamiliarEntity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.head.f_104205_ = 0.0f;
        this.rightArm.f_104205_ = 0.0f;
        this.leftArm.f_104205_ = 0.0f;
        if (entityIn.isPartying()) {
            this.rightArm.f_104203_ = Mth.m_14089_((float)(ageInTicks + (float)Math.PI)) * this.toRad(20.0f) + this.toRad(180.0f);
            this.leftArm.f_104203_ = Mth.m_14089_((float)ageInTicks) * this.toRad(20.0f) + this.toRad(180.0f);
            this.rightArm.f_104205_ = -this.toRad(20.0f);
            this.leftArm.f_104205_ = this.toRad(20.0f);
            this.head.f_104205_ = Mth.m_14031_((float)ageInTicks) * this.toRad(20.0f);
            if (entityIn.m_20202_() == null) {
                this.rightLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.5f)) * 1.4f * limbSwingAmount;
                this.leftLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.5f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            } else {
                this.rightLeg.f_104203_ = -1.5707964f;
                this.leftLeg.f_104203_ = -1.5707964f;
            }
        } else if (entityIn.isSitting() || entityIn.m_20202_() != null) {
            this.rightArm.f_104203_ = 0.0f;
            this.leftArm.f_104203_ = 0.0f;
            this.rightLeg.f_104203_ = -1.5707964f;
            this.leftLeg.f_104203_ = -1.5707964f;
        } else {
            this.rightArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.5f + (float)Math.PI)) * limbSwingAmount;
            this.leftArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.5f)) * limbSwingAmount;
            this.rightLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.5f)) * 1.4f * limbSwingAmount;
            this.leftLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.5f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        }
        this.chest1.f_104205_ = Mth.m_14089_((float)(limbSwing * 0.5f + (float)Math.PI)) * limbSwingAmount * 0.2f;
        if (entityIn.getTargetBlock().isPresent()) {
            this.rightArm.f_104203_ = -this.toRad(100.0f) + Mth.m_14089_((float)(limbSwing * 0.5f + (float)Math.PI)) * limbSwingAmount;
        }
    }
}

