/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.client.model.entity;

import com.github.klikli_dev.occultism.common.entity.DragonFamiliarEntity;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Collections;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class DragonFamiliarModel
extends EntityModel<DragonFamiliarEntity> {
    private static final float PI = (float)Math.PI;
    public ModelPart body;
    public ModelPart neck1;
    public ModelPart leftLeg1;
    public ModelPart tail1;
    public ModelPart leftWing1;
    public ModelPart rightWing1;
    public ModelPart rightLeg1;
    public ModelPart leftArm1;
    public ModelPart rightArm1;
    public ModelPart neck2;
    public ModelPart head;
    public ModelPart jaw;
    public ColorModelPartProxy leftEye;
    public ColorModelPartProxy rightEye;
    public ModelPart fez1;
    public ModelPart leftHorn1;
    public ModelPart leftEar;
    public ModelPart rightEar;
    public ModelPart rightHorn1;
    public ModelPart tooth1;
    public ModelPart tooth2;
    public ModelPart tooth4;
    public ModelPart leftNose;
    public ModelPart rightNose;
    public ModelPart fez2;
    public ModelPart leftHorn2;
    public ModelPart rightHorn2;
    public ModelPart leftLeg2;
    public ModelPart leftLeg3;
    public ModelPart tail2;
    public ModelPart spike1;
    public ModelPart tail3;
    public ModelPart spike2;
    public ModelPart spike3;
    public ModelPart leftWing2;
    public ModelPart rightWing2;
    public ModelPart rightLeg2;
    public ModelPart rightLeg3;
    public ModelPart leftArm2;
    public ModelPart leftArm3;
    public ModelPart rightArm2;
    public ModelPart rightArm3;

    public DragonFamiliarModel(ModelPart part) {
        this.body = part.m_171324_("body");
        this.neck1 = this.body.m_171324_("neck1");
        this.leftLeg1 = this.body.m_171324_("leftLeg1");
        this.tail1 = this.body.m_171324_("tail1");
        this.leftWing1 = this.body.m_171324_("leftWing1");
        this.rightWing1 = this.body.m_171324_("rightWing1");
        this.rightLeg1 = this.body.m_171324_("rightLeg1");
        this.leftArm1 = this.body.m_171324_("leftArm1");
        this.rightArm1 = this.body.m_171324_("rightArm1");
        this.neck2 = this.neck1.m_171324_("neck2");
        this.head = this.neck2.m_171324_("head");
        this.jaw = this.head.m_171324_("jaw");
        this.leftEye = new ColorModelPartProxy(this.head.m_171324_("leftEye"));
        this.rightEye = new ColorModelPartProxy(this.head.m_171324_("rightEye"));
        this.fez1 = this.head.m_171324_("fez1");
        this.leftHorn1 = this.head.m_171324_("leftHorn1");
        this.leftEar = this.head.m_171324_("leftEar");
        this.rightEar = this.head.m_171324_("rightEar");
        this.rightHorn1 = this.head.m_171324_("rightHorn1");
        this.tooth1 = this.jaw.m_171324_("tooth1");
        this.tooth2 = this.jaw.m_171324_("tooth2");
        this.tooth4 = this.jaw.m_171324_("tooth4");
        this.leftNose = this.jaw.m_171324_("leftNose");
        this.rightNose = this.jaw.m_171324_("rightNose");
        this.fez2 = this.fez1.m_171324_("fez2");
        this.leftHorn2 = this.leftHorn1.m_171324_("leftHorn2");
        this.rightHorn2 = this.rightHorn1.m_171324_("rightHorn2");
        this.leftLeg2 = this.leftLeg1.m_171324_("leftLeg2");
        this.leftLeg3 = this.leftLeg2.m_171324_("leftLeg3");
        this.tail2 = this.tail1.m_171324_("tail2");
        this.spike1 = this.tail1.m_171324_("spike1");
        this.tail3 = this.tail2.m_171324_("tail3");
        this.spike2 = this.tail2.m_171324_("spike2");
        this.spike3 = this.tail3.m_171324_("spike3");
        this.leftWing2 = this.leftWing1.m_171324_("leftWing2");
        this.rightWing2 = this.rightWing1.m_171324_("rightWing2");
        this.rightLeg2 = this.rightLeg1.m_171324_("rightLeg2");
        this.rightLeg3 = this.rightLeg2.m_171324_("rightLeg3");
        this.leftArm2 = this.leftArm1.m_171324_("leftArm2");
        this.leftArm3 = this.leftArm1.m_171324_("leftArm3");
        this.rightArm2 = this.rightArm1.m_171324_("rightArm2");
        this.rightArm3 = this.rightArm1.m_171324_("rightArm3");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition parts = mesh.m_171576_();
        PartDefinition body = parts.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171506_(-2.0f, -2.0f, -5.0f, 4.0f, 4.0f, 10.0f, false), PartPose.m_171423_((float)0.0f, (float)18.0f, (float)0.0f, (float)-0.06981317f, (float)0.0f, (float)0.0f));
        PartDefinition neck1 = body.m_171599_("neck1", CubeListBuilder.m_171558_().m_171514_(18, 0).m_171506_(-1.5f, -1.5f, -3.0f, 3.0f, 3.0f, 3.0f, false), PartPose.m_171423_((float)0.0f, (float)0.2f, (float)-4.1f, (float)-0.54733527f, (float)0.0f, (float)0.0f));
        PartDefinition leftLeg1 = body.m_171599_("leftLeg1", CubeListBuilder.m_171558_().m_171514_(44, 5).m_171506_(-0.5f, 0.0f, -1.0f, 1.0f, 3.0f, 2.0f, false), PartPose.m_171423_((float)1.8f, (float)0.5f, (float)2.0f, (float)0.43004912f, (float)0.0f, (float)0.0f));
        PartDefinition tail1 = body.m_171599_("tail1", CubeListBuilder.m_171558_().m_171514_(36, 10).m_171506_(-1.5f, -1.5f, 0.0f, 3.0f, 3.0f, 4.0f, false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)4.3f, (float)-0.23457225f, (float)0.0f, (float)0.0f));
        PartDefinition leftWing1 = body.m_171599_("leftWing1", CubeListBuilder.m_171558_().m_171514_(0, 9).m_171506_(0.0f, -5.0f, -5.0f, 0.0f, 5.0f, 10.0f, false), PartPose.m_171423_((float)2.0f, (float)0.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)1.1414454f));
        PartDefinition rightWing1 = body.m_171599_("rightWing1", CubeListBuilder.m_171558_().m_171514_(0, 9).m_171506_(0.0f, -5.0f, -5.0f, 0.0f, 5.0f, 10.0f, true), PartPose.m_171423_((float)-2.0f, (float)0.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)-0.86009824f));
        PartDefinition rightLeg1 = body.m_171599_("rightLeg1", CubeListBuilder.m_171558_().m_171514_(44, 5).m_171506_(-0.5f, 0.0f, -1.0f, 1.0f, 3.0f, 2.0f, true), PartPose.m_171423_((float)-1.8f, (float)0.5f, (float)2.0f, (float)0.43004912f, (float)0.0f, (float)0.0f));
        PartDefinition leftArm1 = body.m_171599_("leftArm1", CubeListBuilder.m_171558_().m_171514_(0, 5).m_171506_(-0.5f, 0.0f, -0.5f, 1.0f, 2.0f, 1.0f, false), PartPose.m_171423_((float)1.6f, (float)1.1f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightArm1 = body.m_171599_("rightArm1", CubeListBuilder.m_171558_().m_171514_(0, 5).m_171506_(-0.5f, 0.0f, -0.5f, 1.0f, 2.0f, 1.0f, false), PartPose.m_171423_((float)-1.6f, (float)1.1f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition neck2 = neck1.m_171599_("neck2", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171506_(-1.0f, -1.0f, -3.0f, 2.0f, 2.0f, 3.0f, false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)-2.4f, (float)-0.1563815f, (float)0.0f, (float)0.0f));
        PartDefinition head = neck2.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(30, 0).m_171506_(-2.0f, -1.5f, -4.0f, 4.0f, 3.0f, 4.0f, false), PartPose.m_171423_((float)0.0f, (float)-0.4f, (float)-2.4f, (float)0.82135195f, (float)0.0f, (float)0.0f));
        PartDefinition jaw = head.m_171599_("jaw", CubeListBuilder.m_171558_().m_171514_(46, 0).m_171506_(-1.5f, -1.0f, -3.0f, 3.0f, 2.0f, 3.0f, false), PartPose.m_171423_((float)0.0f, (float)0.2f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftEye = head.m_171599_("leftEye", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171506_(0.0f, -1.0f, -1.0f, 1.0f, 2.0f, 2.0f, false), PartPose.m_171423_((float)1.5f, (float)-0.1f, (float)-2.4f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightEye = head.m_171599_("rightEye", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171506_(0.0f, -1.0f, -1.0f, 1.0f, 2.0f, 2.0f, true), PartPose.m_171423_((float)-2.5f, (float)-0.1f, (float)-2.4f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition fez1 = head.m_171599_("fez1", CubeListBuilder.m_171558_().m_171514_(18, 14).m_171506_(-1.0f, -2.0f, -1.0f, 2.0f, 2.0f, 2.0f, false), PartPose.m_171423_((float)0.0f, (float)-1.5f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftHorn1 = head.m_171599_("leftHorn1", CubeListBuilder.m_171558_().m_171514_(0, 14).m_171506_(-0.5f, -1.0f, 0.0f, 1.0f, 2.0f, 2.0f, false), PartPose.m_171423_((float)1.7f, (float)-0.5f, (float)-0.5f, (float)0.2268928f, (float)0.0f, (float)0.0f));
        PartDefinition leftEar = head.m_171599_("leftEar", CubeListBuilder.m_171558_().m_171514_(12, 14).m_171506_(-0.5f, -1.0f, 0.0f, 1.0f, 2.0f, 2.0f, false), PartPose.m_171423_((float)1.7f, (float)-0.6f, (float)-0.6f, (float)-0.13613568f, (float)1.1798426f, (float)-0.5899213f));
        PartDefinition rightEar = head.m_171599_("rightEar", CubeListBuilder.m_171558_().m_171514_(12, 14).m_171506_(-0.5f, -1.0f, 0.0f, 1.0f, 2.0f, 2.0f, true), PartPose.m_171423_((float)-1.7f, (float)-0.6f, (float)-0.6f, (float)-0.13613568f, (float)-1.1798426f, (float)0.5899213f));
        PartDefinition rightHorn1 = head.m_171599_("rightHorn1", CubeListBuilder.m_171558_().m_171514_(0, 14).m_171506_(-0.5f, -1.0f, 0.0f, 1.0f, 2.0f, 2.0f, true), PartPose.m_171423_((float)-1.7f, (float)-0.5f, (float)-0.5f, (float)0.2268928f, (float)0.0f, (float)0.0f));
        PartDefinition tooth1 = jaw.m_171599_("tooth1", CubeListBuilder.m_171558_().m_171514_(59, 0).m_171506_(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, false), PartPose.m_171423_((float)0.7f, (float)-0.4f, (float)-1.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition tooth2 = jaw.m_171599_("tooth2", CubeListBuilder.m_171558_().m_171514_(59, 0).m_171506_(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, false), PartPose.m_171423_((float)0.0f, (float)-0.3f, (float)-3.2f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition tooth4 = jaw.m_171599_("tooth4", CubeListBuilder.m_171558_().m_171514_(59, 0).m_171506_(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, false), PartPose.m_171423_((float)-1.7f, (float)-0.4f, (float)-1.6f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftNose = jaw.m_171599_("leftNose", CubeListBuilder.m_171558_().m_171514_(45, 1).m_171506_(-0.5f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, false), PartPose.m_171423_((float)-0.8f, (float)-1.4f, (float)-2.6f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightNose = jaw.m_171599_("rightNose", CubeListBuilder.m_171558_().m_171514_(45, 1).m_171506_(-0.5f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, false), PartPose.m_171423_((float)0.8f, (float)-1.4f, (float)-2.6f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition fez2 = fez1.m_171599_("fez2", CubeListBuilder.m_171558_().m_171514_(24, 13).m_171506_(0.0f, 0.0f, -0.5f, 0.0f, 1.0f, 1.0f, false), PartPose.m_171423_((float)0.0f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftHorn2 = leftHorn1.m_171599_("leftHorn2", CubeListBuilder.m_171558_().m_171514_(6, 14).m_171506_(-0.5f, -0.5f, 0.0f, 1.0f, 1.0f, 2.0f, false), PartPose.m_171423_((float)0.01f, (float)0.0f, (float)1.4f, (float)0.34906584f, (float)0.0f, (float)0.0f));
        PartDefinition rightHorn2 = rightHorn1.m_171599_("rightHorn2", CubeListBuilder.m_171558_().m_171514_(6, 14).m_171506_(-0.5f, -0.5f, 0.0f, 1.0f, 1.0f, 2.0f, true), PartPose.m_171423_((float)-0.01f, (float)0.0f, (float)1.4f, (float)0.34906584f, (float)0.0f, (float)0.0f));
        PartDefinition leftLeg2 = leftLeg1.m_171599_("leftLeg2", CubeListBuilder.m_171558_().m_171514_(50, 5).m_171506_(-0.5f, 0.0f, -1.0f, 1.0f, 3.0f, 2.0f, false), PartPose.m_171423_((float)0.01f, (float)2.4f, (float)0.5f, (float)-0.74281216f, (float)0.0f, (float)0.0f));
        PartDefinition leftLeg3 = leftLeg2.m_171599_("leftLeg3", CubeListBuilder.m_171558_().m_171514_(28, 7).m_171506_(-1.0f, 0.0f, -4.0f, 2.0f, 1.0f, 4.0f, false), PartPose.m_171423_((float)0.0f, (float)2.2f, (float)0.8f, (float)0.39095375f, (float)0.0f, (float)0.0f));
        PartDefinition tail2 = tail1.m_171599_("tail2", CubeListBuilder.m_171558_().m_171514_(50, 10).m_171506_(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 4.0f, false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)3.3f, (float)-0.23457225f, (float)0.0f, (float)0.0f));
        PartDefinition spike1 = tail1.m_171599_("spike1", CubeListBuilder.m_171558_().m_171514_(0, 25).m_171506_(0.0f, 0.0f, 0.0f, 0.0f, 3.0f, 4.0f, false), PartPose.m_171423_((float)0.0f, (float)-4.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition tail3 = tail2.m_171599_("tail3", CubeListBuilder.m_171558_().m_171514_(18, 6).m_171506_(-0.5f, -0.5f, 0.0f, 1.0f, 1.0f, 3.0f, false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)3.4f, (float)0.19547687f, (float)0.0f, (float)0.0f));
        PartDefinition spike2 = tail2.m_171599_("spike2", CubeListBuilder.m_171558_().m_171514_(0, 25).m_171506_(0.0f, 0.0f, 0.0f, 0.0f, 3.0f, 4.0f, false), PartPose.m_171423_((float)0.01f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition spike3 = tail3.m_171599_("spike3", CubeListBuilder.m_171558_().m_171514_(8, 26).m_171506_(0.0f, 0.0f, 0.0f, 0.0f, 3.0f, 3.0f, false), PartPose.m_171423_((float)0.0f, (float)-3.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftWing2 = leftWing1.m_171599_("leftWing2", CubeListBuilder.m_171558_().m_171514_(0, 14).m_171506_(0.0f, -5.0f, -5.0f, 0.0f, 5.0f, 10.0f, false), PartPose.m_171423_((float)0.0f, (float)-5.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.86009824f));
        PartDefinition rightWing2 = rightWing1.m_171599_("rightWing2", CubeListBuilder.m_171558_().m_171514_(0, 14).m_171506_(0.0f, -5.0f, -5.0f, 0.0f, 5.0f, 10.0f, true), PartPose.m_171423_((float)0.0f, (float)-5.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.86009824f));
        PartDefinition rightLeg2 = rightLeg1.m_171599_("rightLeg2", CubeListBuilder.m_171558_().m_171514_(50, 5).m_171506_(-0.5f, 0.0f, -1.0f, 1.0f, 3.0f, 2.0f, true), PartPose.m_171423_((float)-0.01f, (float)2.4f, (float)0.5f, (float)-0.74281216f, (float)0.0f, (float)0.0f));
        PartDefinition rightLeg3 = rightLeg2.m_171599_("rightLeg3", CubeListBuilder.m_171558_().m_171514_(28, 7).m_171506_(-1.0f, 0.0f, -4.0f, 2.0f, 1.0f, 4.0f, true), PartPose.m_171423_((float)0.0f, (float)2.2f, (float)0.8f, (float)0.39095375f, (float)0.0f, (float)0.0f));
        PartDefinition leftArm2 = leftArm1.m_171599_("leftArm2", CubeListBuilder.m_171558_().m_171514_(0, 8).m_171506_(-0.5f, 0.0f, -0.5f, 1.0f, 1.0f, 1.0f, false), PartPose.m_171423_((float)-0.1f, (float)2.1f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7853982f));
        PartDefinition leftArm3 = leftArm1.m_171599_("leftArm3", CubeListBuilder.m_171558_().m_171514_(0, 8).m_171506_(-0.5f, 0.0f, -0.5f, 1.0f, 1.0f, 1.0f, false), PartPose.m_171423_((float)0.1f, (float)2.1f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7853982f));
        PartDefinition rightArm2 = rightArm1.m_171599_("rightArm2", CubeListBuilder.m_171558_().m_171514_(0, 8).m_171506_(-0.5f, 0.0f, -0.5f, 1.0f, 1.0f, 1.0f, false), PartPose.m_171423_((float)-0.1f, (float)2.1f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7853982f));
        PartDefinition rightArm3 = rightArm1.m_171599_("rightArm3", CubeListBuilder.m_171558_().m_171514_(0, 8).m_171506_(-0.5f, 0.0f, -0.5f, 1.0f, 1.0f, 1.0f, false), PartPose.m_171423_((float)0.1f, (float)2.1f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7853982f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)32);
    }

    public void m_7695_(PoseStack pPoseStack, VertexConsumer pBuffer, int pPackedLight, int pPackedOverlay, float red, float green, float blue, float alpha) {
        ImmutableList.of((Object)this.body).forEach(modelRenderer -> modelRenderer.m_104306_(pPoseStack, pBuffer, pPackedLight, pPackedOverlay, red, green, blue, alpha));
        this.rightEye.proxyRender(pPoseStack, pBuffer, pPackedLight, pPackedOverlay, red, green, blue, alpha);
        this.leftEye.proxyRender(pPoseStack, pBuffer, pPackedLight, pPackedOverlay, red, green, blue, alpha);
    }

    public void setupAnim(DragonFamiliarEntity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entityIn.isPartying()) {
            this.head.f_104203_ = this.toRads(50.0f) + Mth.m_14031_((float)ageInTicks) * this.toRads(20.0f);
            this.head.f_104204_ = Mth.m_14031_((float)ageInTicks) * this.toRads(5.0f);
            this.head.f_104205_ = Mth.m_14031_((float)ageInTicks) * this.toRads(5.0f);
        } else {
            this.head.f_104203_ = this.toRads(50.0f) + 0.03f + headPitch * ((float)Math.PI / 180) * 0.7f;
            this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180) * 0.5f;
            this.head.f_104205_ = netHeadYaw * ((float)Math.PI / 180) * 0.5f;
        }
    }

    public void prepareMobModel(DragonFamiliarEntity entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        this.setEyeColor(entityIn.getEyeColorR(partialTick), entityIn.getEyeColorG(partialTick), entityIn.getEyeColorB(partialTick));
        this.showModels(entityIn);
        float ageInTicks = (float)entityIn.f_19797_ + partialTick;
        this.tail1.f_104205_ = 0.0f;
        this.tail2.f_104205_ = 0.0f;
        this.tail3.f_104205_ = 0.0f;
        this.jaw.f_104205_ = 0.0f;
        if (entityIn.isPartying()) {
            this.tail1.f_104205_ = Mth.m_14031_((float)ageInTicks) * this.toRads(30.0f);
            this.tail2.f_104205_ = -Mth.m_14031_((float)ageInTicks) * this.toRads(60.0f);
            this.tail3.f_104205_ = Mth.m_14031_((float)ageInTicks) * this.toRads(90.0f);
            this.leftWing1.f_104204_ = Mth.m_14031_((float)ageInTicks) * this.toRads(20.0f);
            this.rightWing1.f_104204_ = -Mth.m_14031_((float)ageInTicks) * this.toRads(20.0f);
        } else {
            this.leftWing1.f_104204_ = 0.0f;
            this.rightWing1.f_104204_ = 0.0f;
        }
        float petTimer = (float)entityIn.getPetTimer() + partialTick;
        float petDuration = 20.0f;
        if (petTimer < petDuration) {
            this.tail1.f_104205_ = Mth.m_14031_((float)(petTimer / petDuration * (float)Math.PI * 6.0f)) * this.toRads(20.0f);
            this.tail2.f_104205_ = Mth.m_14031_((float)(petTimer / petDuration * (float)Math.PI * 6.0f)) * this.toRads(20.0f);
            this.tail3.f_104205_ = Mth.m_14031_((float)(petTimer / petDuration * (float)Math.PI * 6.0f)) * this.toRads(20.0f);
            this.jaw.f_104205_ = -Mth.m_14031_((float)(petTimer / petDuration * (float)Math.PI * 6.0f)) * this.toRads(10.0f);
        }
        if (entityIn.f_20911_) {
            float attackProgress = entityIn.getAttackProgress(partialTick);
            this.tail1.f_104204_ = Mth.m_14031_((float)(attackProgress * (float)Math.PI * 4.0f)) * this.toRads(30.0f);
            this.tail2.f_104204_ = Mth.m_14031_((float)(attackProgress * (float)Math.PI * 4.0f)) * this.toRads(30.0f);
            this.tail3.f_104204_ = Mth.m_14031_((float)(attackProgress * (float)Math.PI * 4.0f)) * this.toRads(30.0f);
        } else {
            this.tail1.f_104204_ = 0.0f;
            this.tail2.f_104204_ = 0.0f;
            this.tail3.f_104204_ = 0.0f;
        }
        if (!entityIn.isSitting()) {
            this.leftLeg1.f_104203_ = this.toRads(25.0f) + Mth.m_14089_((float)(limbSwing * 0.7f + (float)Math.PI)) * limbSwingAmount * 0.5f;
            this.rightLeg1.f_104203_ = this.toRads(25.0f) + Mth.m_14089_((float)(limbSwing * 0.7f)) * limbSwingAmount * 0.5f;
            this.leftLeg3.f_104203_ = this.toRads(23.0f);
            this.rightLeg3.f_104203_ = this.toRads(23.0f);
            float flyingTimer = entityIn.getFlyingTimer(partialTick);
            float wingspan = entityIn.getWingspan(partialTick);
            float flyingWingRot = flyingTimer * 1.15f;
            this.leftWing1.f_104205_ = this.toRads(65.0f) + Mth.m_14089_((float)(limbSwing * 0.7f + flyingWingRot)) * (limbSwingAmount * 0.2f + this.toRads(wingspan));
            this.leftWing2.f_104205_ = this.toRads(50.0f) + Mth.m_14089_((float)(limbSwing * 0.7f + flyingWingRot)) * (limbSwingAmount * 0.2f + this.toRads(wingspan) * 0.5f);
            this.rightWing1.f_104205_ = -this.toRads(65.0f) - Mth.m_14089_((float)(limbSwing * 0.7f + flyingWingRot)) * (limbSwingAmount * 0.2f + this.toRads(wingspan));
            this.rightWing2.f_104205_ = -this.toRads(50.0f) - Mth.m_14089_((float)(limbSwing * 0.7f + flyingWingRot)) * (limbSwingAmount * 0.2f + this.toRads(wingspan) * 0.5f);
            this.tail1.f_104203_ = Mth.m_14089_((float)(ageInTicks / 20.0f)) * this.toRads(10.0f);
            this.tail2.f_104203_ = Mth.m_14089_((float)(ageInTicks / 20.0f)) * this.toRads(10.0f);
            this.tail3.f_104203_ = Mth.m_14089_((float)(ageInTicks / 20.0f)) * this.toRads(10.0f);
            this.body.f_104203_ = this.toRads(-4.0f);
            this.neck1.f_104203_ = this.toRads(-30.0f);
            this.neck2.f_104203_ = this.toRads(-9.0f);
        } else {
            this.leftLeg1.f_104203_ = this.toRads(15.0f);
            this.rightLeg1.f_104203_ = this.toRads(15.0f);
            this.leftLeg3.f_104203_ = this.toRads(26.0f);
            this.rightLeg3.f_104203_ = this.toRads(26.0f);
            this.leftWing1.f_104205_ = this.toRads(150.0f);
            this.leftWing2.f_104205_ = this.toRads(20.0f);
            this.rightWing1.f_104205_ = -this.toRads(150.0f);
            this.rightWing2.f_104205_ = -this.toRads(20.0f);
            this.tail1.f_104203_ = this.toRads(30.0f);
            this.tail2.f_104203_ = this.toRads(30.0f);
            this.tail3.f_104203_ = this.toRads(30.0f);
            this.body.f_104203_ = this.toRads(-50.0f);
            this.neck1.f_104203_ = this.toRads(10.0f);
            this.neck2.f_104203_ = this.toRads(5.0f);
        }
    }

    private float toRads(float deg) {
        return (float)Math.PI / 180 * deg;
    }

    private void showModels(DragonFamiliarEntity entityIn) {
        boolean hasEars = entityIn.hasEars();
        boolean hasArms = entityIn.hasArms();
        this.fez1.f_104207_ = entityIn.hasFez();
        this.leftEar.f_104207_ = hasEars;
        this.rightEar.f_104207_ = hasEars;
        this.leftHorn1.f_104207_ = !hasEars;
        this.rightHorn1.f_104207_ = !hasEars;
        this.leftArm1.f_104207_ = hasArms;
        this.rightArm1.f_104207_ = hasArms;
    }

    private void setEyeColor(float r, float g, float b) {
        this.leftEye.setColor(r, g, b);
        this.rightEye.setColor(r, g, b);
    }

    public static class ColorModelPartProxy
    extends ModelPart {
        float r;
        float g;
        float b;
        float a;
        ModelPart proxied;

        public ColorModelPartProxy(ModelPart modelPart) {
            super(Collections.emptyList(), Collections.emptyMap());
            this.proxied = modelPart;
        }

        public void setColor(float r, float g, float b) {
            this.setColor(r, g, b, 1.0f);
        }

        public void setColor(float r, float g, float b, float a) {
            this.r = r;
            this.g = g;
            this.b = b;
            this.a = a;
        }

        public void m_104306_(PoseStack pPoseStack, VertexConsumer pVertexConsumer, int pPackedLight, int pPackedOverlay, float pRed, float pGreen, float pBlue, float pAlpha) {
        }

        public void proxyRender(PoseStack pPoseStack, VertexConsumer pVertexConsumer, int pPackedLight, int pPackedOverlay, float pRed, float pGreen, float pBlue, float pAlpha) {
            this.proxied.m_104306_(pPoseStack, pVertexConsumer, pPackedLight, pPackedOverlay, this.r, this.g, this.b, this.a);
        }
    }
}

