/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.client.model.entity;

import com.github.klikli_dev.occultism.common.entity.DeerFamiliarEntity;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class DeerFamiliarModel
extends EntityModel<DeerFamiliarEntity> {
    private static final float PI = (float)Math.PI;
    public ModelPart body;
    public ModelPart leftFrontLeg1;
    public ModelPart tail;
    public ModelPart neck;
    public ModelPart rightFrontLeg1;
    public ModelPart leftBackLeg1;
    public ModelPart rightBackLeg1;
    public ModelPart leftFrontLeg2;
    public ModelPart head;
    public ModelPart nose;
    public ModelPart leftEar;
    public ModelPart rightEar;
    public ModelPart leftHorn1;
    public ModelPart rightHorn1;
    public ModelPart hammerHandle;
    public ModelPart hammerHead;
    public ModelPart hammerSpikes1;
    public ModelPart hammerSpikes2;
    public ModelPart hammerSpikes3;
    public ModelPart hammerSpikes4;
    public ModelPart hammerSpikes5;
    public ModelPart hammerSpikes6;
    public ModelPart hammerSpikes7;
    public ModelPart hammerSpikes8;
    public ModelPart leftHorn2;
    public ModelPart leftHorn3;
    public ModelPart rightHorn2;
    public ModelPart rightHorn3;
    public ModelPart rightFrontLeg2;
    public ModelPart leftBackLeg2;
    public ModelPart rightBackLeg2;

    public DeerFamiliarModel(ModelPart part) {
        this.body = part.m_171324_("body");
        this.leftFrontLeg1 = this.body.m_171324_("leftFrontLeg1");
        this.tail = this.body.m_171324_("tail");
        this.neck = this.body.m_171324_("neck");
        this.rightFrontLeg1 = this.body.m_171324_("rightFrontLeg1");
        this.leftBackLeg1 = this.body.m_171324_("leftBackLeg1");
        this.rightBackLeg1 = this.body.m_171324_("rightBackLeg1");
        this.leftFrontLeg2 = this.leftFrontLeg1.m_171324_("leftFrontLeg2");
        this.head = this.neck.m_171324_("head");
        this.nose = this.head.m_171324_("nose");
        this.leftEar = this.head.m_171324_("leftEar");
        this.rightEar = this.head.m_171324_("rightEar");
        this.leftHorn1 = this.head.m_171324_("leftHorn1");
        this.rightHorn1 = this.head.m_171324_("rightHorn1");
        this.hammerHandle = this.nose.m_171324_("hammerHandle");
        this.hammerHead = this.hammerHandle.m_171324_("hammerHead");
        this.hammerSpikes1 = this.hammerHead.m_171324_("hammerSpikes1");
        this.hammerSpikes2 = this.hammerHead.m_171324_("hammerSpikes2");
        this.hammerSpikes3 = this.hammerHead.m_171324_("hammerSpikes3");
        this.hammerSpikes4 = this.hammerHead.m_171324_("hammerSpikes4");
        this.hammerSpikes5 = this.hammerHead.m_171324_("hammerSpikes5");
        this.hammerSpikes6 = this.hammerHead.m_171324_("hammerSpikes6");
        this.hammerSpikes7 = this.hammerHead.m_171324_("hammerSpikes7");
        this.hammerSpikes8 = this.hammerHead.m_171324_("hammerSpikes8");
        this.leftHorn2 = this.leftHorn1.m_171324_("leftHorn2");
        this.leftHorn3 = this.leftHorn1.m_171324_("leftHorn3");
        this.rightHorn2 = this.rightHorn1.m_171324_("rightHorn2");
        this.rightHorn3 = this.rightHorn1.m_171324_("rightHorn3");
        this.rightFrontLeg2 = this.rightFrontLeg1.m_171324_("rightFrontLeg2");
        this.leftBackLeg2 = this.leftBackLeg1.m_171324_("leftBackLeg2");
        this.rightBackLeg2 = this.rightBackLeg1.m_171324_("rightBackLeg2");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition parts = mesh.m_171576_();
        PartDefinition body = parts.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171506_(-2.0f, -5.0f, -5.0f, 4.0f, 5.0f, 10.0f, false), PartPose.m_171423_((float)0.0f, (float)16.4f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftFrontLeg1 = body.m_171599_("leftFrontLeg1", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171506_(-0.5f, 0.0f, -1.0f, 1.0f, 4.0f, 2.0f, false), PartPose.m_171423_((float)1.4f, (float)-0.2f, (float)-3.9f, (float)(-DeerFamiliarModel.toRad(80.0f)), (float)(-DeerFamiliarModel.toRad(10.0f)), (float)(-DeerFamiliarModel.toRad(40.0f))));
        PartDefinition tail = body.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(22, 0).m_171506_(-1.0f, -0.5f, 0.0f, 2.0f, 1.0f, 2.0f, false), PartPose.m_171423_((float)0.0f, (float)-4.0f, (float)4.5f, (float)-0.43633232f, (float)0.0f, (float)0.0f));
        PartDefinition neck = body.m_171599_("neck", CubeListBuilder.m_171558_().m_171514_(30, 0).m_171506_(-1.0f, -3.0f, -1.0f, 2.0f, 3.0f, 2.0f, false), PartPose.m_171423_((float)0.0f, (float)-4.0f, (float)-4.0f, (float)0.39095375f, (float)0.0f, (float)0.0f));
        PartDefinition rightFrontLeg1 = body.m_171599_("rightFrontLeg1", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171506_(-0.5f, 0.0f, -1.0f, 1.0f, 4.0f, 2.0f, true), PartPose.m_171423_((float)-1.4f, (float)-0.2f, (float)-3.9f, (float)(-DeerFamiliarModel.toRad(80.0f)), (float)(-DeerFamiliarModel.toRad(10.0f)), (float)(-DeerFamiliarModel.toRad(40.0f))));
        PartDefinition leftBackLeg1 = body.m_171599_("leftBackLeg1", CubeListBuilder.m_171558_().m_171514_(28, 9).m_171506_(-0.5f, 0.0f, -1.0f, 1.0f, 4.0f, 2.0f, false), PartPose.m_171423_((float)1.4f, (float)-0.2f, (float)3.9f, (float)DeerFamiliarModel.toRad(80.0f), (float)DeerFamiliarModel.toRad(10.0f), (float)(-DeerFamiliarModel.toRad(40.0f))));
        PartDefinition rightBackLeg1 = body.m_171599_("rightBackLeg1", CubeListBuilder.m_171558_().m_171514_(28, 9).m_171506_(-0.5f, 0.0f, -1.0f, 1.0f, 4.0f, 2.0f, true), PartPose.m_171423_((float)-1.4f, (float)-0.2f, (float)3.9f, (float)DeerFamiliarModel.toRad(80.0f), (float)DeerFamiliarModel.toRad(10.0f), (float)(-DeerFamiliarModel.toRad(40.0f))));
        PartDefinition leftFrontLeg2 = leftFrontLeg1.m_171599_("leftFrontLeg2", CubeListBuilder.m_171558_().m_171514_(18, 0).m_171506_(-0.5f, 0.0f, -0.5f, 1.0f, 4.0f, 1.0f, false), PartPose.m_171423_((float)-0.01f, (float)3.8f, (float)0.0f, (float)0.11728612f, (float)0.0f, (float)0.0f));
        PartDefinition head = neck.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(38, 0).m_171506_(-1.5f, -3.0f, -1.5f, 3.0f, 3.0f, 3.0f, false), PartPose.m_171423_((float)0.0f, (float)-2.5f, (float)-0.3f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition nose = head.m_171599_("nose", CubeListBuilder.m_171558_().m_171514_(51, 5).m_171506_(-1.0f, -1.0f, -2.0f, 2.0f, 2.0f, 3.0f, false), PartPose.m_171423_((float)0.0f, (float)-1.01f, (float)-1.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftEar = head.m_171599_("leftEar", CubeListBuilder.m_171558_().m_171514_(22, 3).m_171506_(-1.0f, -2.0f, 0.0f, 2.0f, 2.0f, 1.0f, false), PartPose.m_171423_((float)1.0f, (float)-2.5f, (float)0.5f, (float)-0.39095375f, (float)0.0f, (float)0.7819075f));
        PartDefinition rightEar = head.m_171599_("rightEar", CubeListBuilder.m_171558_().m_171514_(22, 3).m_171506_(-1.0f, -2.0f, 0.0f, 2.0f, 2.0f, 1.0f, true), PartPose.m_171423_((float)-1.0f, (float)-2.5f, (float)0.5f, (float)-0.39095375f, (float)0.0f, (float)-0.7819075f));
        PartDefinition leftHorn1 = head.m_171599_("leftHorn1", CubeListBuilder.m_171558_().m_171514_(50, 4).m_171506_(-0.5f, -3.0f, -0.5f, 1.0f, 3.0f, 1.0f, false), PartPose.m_171423_((float)0.7f, (float)-2.5f, (float)0.3f, (float)0.0f, (float)0.0f, (float)0.312763f));
        PartDefinition rightHorn1 = head.m_171599_("rightHorn1", CubeListBuilder.m_171558_().m_171514_(50, 4).m_171506_(-0.5f, -3.0f, -0.5f, 1.0f, 3.0f, 1.0f, false), PartPose.m_171423_((float)-0.7f, (float)-2.5f, (float)0.3f, (float)0.0f, (float)0.0f, (float)-0.312763f));
        PartDefinition hammerHandle = nose.m_171599_("hammerHandle", CubeListBuilder.m_171558_().m_171514_(38, 14).m_171506_(0.0f, -0.5f, -0.5f, 5.0f, 1.0f, 1.0f, false), PartPose.m_171423_((float)-1.8f, (float)0.3f, (float)-1.3f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition hammerHead = hammerHandle.m_171599_("hammerHead", CubeListBuilder.m_171558_().m_171514_(50, 12).m_171506_(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, false), PartPose.m_171423_((float)6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7853982f, (float)0.0f));
        PartDefinition hammerSpikes1 = hammerHead.m_171599_("hammerSpikes1", CubeListBuilder.m_171558_().m_171514_(58, 10).m_171506_(-0.5f, -0.5f, 0.0f, 1.0f, 1.0f, 0.0f, false), PartPose.m_171423_((float)-0.2f, (float)-1.2f, (float)-0.6f, (float)0.0f, (float)0.0f, (float)0.7853982f));
        PartDefinition hammerSpikes2 = hammerHead.m_171599_("hammerSpikes2", CubeListBuilder.m_171558_().m_171514_(58, 10).m_171506_(-0.5f, -0.5f, 0.0f, 1.0f, 1.0f, 0.0f, false), PartPose.m_171423_((float)0.2f, (float)-1.2f, (float)0.4f, (float)0.0f, (float)0.0f, (float)0.7853982f));
        PartDefinition hammerSpikes3 = hammerHead.m_171599_("hammerSpikes3", CubeListBuilder.m_171558_().m_171514_(58, 10).m_171506_(-0.5f, -0.5f, 0.0f, 1.0f, 1.0f, 0.0f, false), PartPose.m_171423_((float)1.2f, (float)-0.3f, (float)-0.6f, (float)0.0f, (float)0.0f, (float)0.7853982f));
        PartDefinition hammerSpikes4 = hammerHead.m_171599_("hammerSpikes4", CubeListBuilder.m_171558_().m_171514_(58, 10).m_171506_(-0.5f, -0.5f, 0.0f, 1.0f, 1.0f, 0.0f, false), PartPose.m_171423_((float)1.2f, (float)0.3f, (float)0.4f, (float)0.0f, (float)0.0f, (float)0.7853982f));
        PartDefinition hammerSpikes5 = hammerHead.m_171599_("hammerSpikes5", CubeListBuilder.m_171558_().m_171514_(58, 9).m_171506_(0.0f, -0.5f, -0.5f, 0.0f, 1.0f, 1.0f, false), PartPose.m_171423_((float)0.5f, (float)-0.2f, (float)1.2f, (float)0.7853982f, (float)0.0f, (float)0.0f));
        PartDefinition hammerSpikes6 = hammerHead.m_171599_("hammerSpikes6", CubeListBuilder.m_171558_().m_171514_(58, 9).m_171506_(0.0f, -0.5f, -0.5f, 0.0f, 1.0f, 1.0f, false), PartPose.m_171423_((float)-0.4f, (float)0.3f, (float)1.2f, (float)0.7853982f, (float)0.0f, (float)0.0f));
        PartDefinition hammerSpikes7 = hammerHead.m_171599_("hammerSpikes7", CubeListBuilder.m_171558_().m_171514_(58, 9).m_171506_(0.0f, -0.5f, -0.5f, 0.0f, 1.0f, 1.0f, false), PartPose.m_171423_((float)0.6f, (float)1.2f, (float)-0.1f, (float)0.7853982f, (float)0.0f, (float)0.0f));
        PartDefinition hammerSpikes8 = hammerHead.m_171599_("hammerSpikes8", CubeListBuilder.m_171558_().m_171514_(58, 9).m_171506_(0.0f, -0.5f, -0.5f, 0.0f, 1.0f, 1.0f, false), PartPose.m_171423_((float)-0.5f, (float)1.2f, (float)0.3f, (float)0.7853982f, (float)0.0f, (float)0.0f));
        PartDefinition leftHorn2 = leftHorn1.m_171599_("leftHorn2", CubeListBuilder.m_171558_().m_171514_(58, 0).m_171506_(-0.5f, -2.0f, -0.5f, 1.0f, 2.0f, 1.0f, false), PartPose.m_171423_((float)0.3f, (float)-2.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.134464f));
        PartDefinition leftHorn3 = leftHorn1.m_171599_("leftHorn3", CubeListBuilder.m_171558_().m_171514_(18, 5).m_171506_(-0.5f, -2.0f, -0.5f, 1.0f, 2.0f, 1.0f, false), PartPose.m_171423_((float)0.0f, (float)-2.7f, (float)0.0f, (float)0.5864306f, (float)0.0f, (float)0.0f));
        PartDefinition rightHorn2 = rightHorn1.m_171599_("rightHorn2", CubeListBuilder.m_171558_().m_171514_(58, 0).m_171506_(-0.5f, -2.0f, -0.5f, 1.0f, 2.0f, 1.0f, false), PartPose.m_171423_((float)-0.3f, (float)-2.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.134464f));
        PartDefinition rightHorn3 = rightHorn1.m_171599_("rightHorn3", CubeListBuilder.m_171558_().m_171514_(18, 5).m_171506_(-0.5f, -2.0f, -0.5f, 1.0f, 2.0f, 1.0f, false), PartPose.m_171423_((float)0.0f, (float)-2.7f, (float)0.0f, (float)0.5864306f, (float)0.0f, (float)0.0f));
        PartDefinition rightFrontLeg2 = rightFrontLeg1.m_171599_("rightFrontLeg2", CubeListBuilder.m_171558_().m_171514_(18, 0).m_171506_(-0.5f, 0.0f, -0.5f, 1.0f, 4.0f, 1.0f, true), PartPose.m_171423_((float)0.01f, (float)3.8f, (float)0.0f, (float)0.11728612f, (float)0.0f, (float)0.0f));
        PartDefinition leftBackLeg2 = leftBackLeg1.m_171599_("leftBackLeg2", CubeListBuilder.m_171558_().m_171514_(34, 10).m_171506_(-0.5f, 0.0f, -0.5f, 1.0f, 4.0f, 1.0f, false), PartPose.m_171423_((float)-0.01f, (float)3.8f, (float)0.0f, (float)-0.11728612f, (float)0.0f, (float)0.0f));
        PartDefinition rightBackLeg2 = rightBackLeg1.m_171599_("rightBackLeg2", CubeListBuilder.m_171558_().m_171514_(34, 10).m_171506_(-0.5f, 0.0f, -0.5f, 1.0f, 4.0f, 1.0f, true), PartPose.m_171423_((float)0.01f, (float)3.8f, (float)0.0f, (float)-0.11728612f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)16);
    }

    public void m_7695_(PoseStack pPoseStack, VertexConsumer pBuffer, int pPackedLight, int pPackedOverlay, float red, float green, float blue, float alpha) {
        ImmutableList.of((Object)this.body).forEach(ModelPart2 -> ModelPart2.m_104306_(pPoseStack, pBuffer, pPackedLight, pPackedOverlay, red, green, blue, alpha));
    }

    private static float toRad(float deg) {
        return (float)Math.toRadians(deg);
    }

    public void prepareMobModel(DeerFamiliarEntity entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        this.neck.f_104203_ = entityIn.getNeckRot(partialTick);
        this.hammerHandle.f_104207_ = entityIn.hasBlacksmithUpgrade();
    }

    public void setupAnim(DeerFamiliarEntity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entityIn.isEating()) {
            this.head.f_104203_ = Mth.m_14089_((float)(ageInTicks * 0.8f)) * 0.2f;
            this.head.f_104204_ = 0.0f;
        } else {
            this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180) * 0.5f;
            this.head.f_104203_ = headPitch * ((float)Math.PI / 180) * 0.5f;
        }
        if ((double)this.f_102608_ > 0.01) {
            this.head.f_104204_ = Mth.m_14031_((float)(this.f_102608_ * (float)Math.PI)) * DeerFamiliarModel.toRad(50.0f);
            this.head.f_104205_ = Mth.m_14031_((float)(this.f_102608_ * (float)Math.PI)) * DeerFamiliarModel.toRad(-40.0f);
            this.nose.f_104204_ = Mth.m_14031_((float)(this.f_102608_ * (float)Math.PI)) * DeerFamiliarModel.toRad(18.0f);
            this.nose.f_104205_ = Mth.m_14031_((float)(this.f_102608_ * (float)Math.PI)) * DeerFamiliarModel.toRad(-18.0f);
        } else {
            this.head.f_104205_ = 0.0f;
            this.nose.f_104204_ = 0.0f;
            this.nose.f_104205_ = 0.0f;
        }
        this.tail.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.7f)) * 0.4f * limbSwingAmount - 0.3f;
        this.body.f_104203_ = 0.0f;
        if (entityIn.isPartying()) {
            this.body.f_104203_ = DeerFamiliarModel.toRad(-20.0f);
            this.setRotateAngle(this.rightBackLeg1, Mth.m_14089_((float)(ageInTicks / 2.0f + (float)Math.PI)) * DeerFamiliarModel.toRad(5.0f) + DeerFamiliarModel.toRad(20.0f), 0.0f, 0.0f);
            this.setRotateAngle(this.leftBackLeg1, Mth.m_14089_((float)(ageInTicks / 2.0f)) * DeerFamiliarModel.toRad(5.0f) + DeerFamiliarModel.toRad(20.0f), 0.0f, 0.0f);
            this.setRotateAngle(this.rightFrontLeg1, Mth.m_14089_((float)(ageInTicks / 2.0f)) * DeerFamiliarModel.toRad(30.0f) - DeerFamiliarModel.toRad(40.0f), 0.0f, 0.0f);
            this.setRotateAngle(this.leftFrontLeg1, Mth.m_14089_((float)(ageInTicks / 2.0f + (float)Math.PI)) * DeerFamiliarModel.toRad(30.0f) - DeerFamiliarModel.toRad(40.0f), 0.0f, 0.0f);
            this.rightBackLeg2.f_104202_ = 0.0f;
            this.leftBackLeg2.f_104202_ = 0.0f;
            this.rightFrontLeg2.f_104202_ = 0.0f;
            this.leftFrontLeg2.f_104202_ = 0.0f;
            this.rightBackLeg2.f_104203_ = -0.1f;
            this.leftBackLeg2.f_104203_ = -0.1f;
            this.rightFrontLeg2.f_104203_ = 0.1f;
            this.leftFrontLeg2.f_104203_ = 0.1f;
        } else if (entityIn.isSitting()) {
            this.setRotateAngle(this.rightBackLeg1, DeerFamiliarModel.toRad(80.0f), DeerFamiliarModel.toRad(10.0f), -DeerFamiliarModel.toRad(40.0f));
            this.setRotateAngle(this.leftBackLeg1, DeerFamiliarModel.toRad(80.0f), DeerFamiliarModel.toRad(10.0f), -DeerFamiliarModel.toRad(40.0f));
            this.setRotateAngle(this.rightFrontLeg1, -DeerFamiliarModel.toRad(80.0f), -DeerFamiliarModel.toRad(10.0f), -DeerFamiliarModel.toRad(40.0f));
            this.setRotateAngle(this.leftFrontLeg1, -DeerFamiliarModel.toRad(80.0f), -DeerFamiliarModel.toRad(10.0f), -DeerFamiliarModel.toRad(40.0f));
            this.rightBackLeg2.f_104202_ = -0.5f;
            this.leftBackLeg2.f_104202_ = -0.5f;
            this.rightFrontLeg2.f_104202_ = 0.5f;
            this.leftFrontLeg2.f_104202_ = 0.5f;
            this.rightBackLeg2.f_104203_ = -DeerFamiliarModel.toRad(150.0f);
            this.leftBackLeg2.f_104203_ = -DeerFamiliarModel.toRad(150.0f);
            this.rightFrontLeg2.f_104203_ = DeerFamiliarModel.toRad(150.0f);
            this.leftFrontLeg2.f_104203_ = DeerFamiliarModel.toRad(150.0f);
        } else {
            boolean fast = entityIn.m_21133_(Attributes.f_22279_) > 0.4;
            this.setRotateAngle(this.rightBackLeg1, Mth.m_14089_((float)(limbSwing * 0.7f + (fast ? (float)Math.PI : 0.0f))) * 1.4f * limbSwingAmount, 0.0f, 0.0f);
            this.setRotateAngle(this.leftBackLeg1, Mth.m_14089_((float)(limbSwing * 0.7f + (float)Math.PI)) * 1.4f * limbSwingAmount, 0.0f, 0.0f);
            this.setRotateAngle(this.rightFrontLeg1, Mth.m_14089_((float)(limbSwing * 0.7f + (fast ? 0.0f : (float)Math.PI))) * 1.4f * limbSwingAmount, 0.0f, 0.0f);
            this.setRotateAngle(this.leftFrontLeg1, Mth.m_14089_((float)(limbSwing * 0.7f)) * 1.4f * limbSwingAmount, 0.0f, 0.0f);
            this.rightBackLeg2.f_104202_ = 0.0f;
            this.leftBackLeg2.f_104202_ = 0.0f;
            this.rightFrontLeg2.f_104202_ = 0.0f;
            this.leftFrontLeg2.f_104202_ = 0.0f;
            this.rightBackLeg2.f_104203_ = -0.1f;
            this.leftBackLeg2.f_104203_ = -0.1f;
            this.rightFrontLeg2.f_104203_ = 0.1f;
            this.leftFrontLeg2.f_104203_ = 0.1f;
        }
    }

    public void setRotateAngle(ModelPart ModelPart2, float x, float y, float z) {
        ModelPart2.f_104203_ = x;
        ModelPart2.f_104204_ = y;
        ModelPart2.f_104205_ = z;
    }
}

