/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.client.model.entity;

import com.github.klikli_dev.occultism.client.model.entity.DragonFamiliarModel;
import com.github.klikli_dev.occultism.common.entity.CthulhuFamiliarEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class CthulhuFamiliarModel
extends EntityModel<CthulhuFamiliarEntity> {
    private static final float PI = (float)Math.PI;
    public ModelPart body;
    public ModelPart head;
    public ModelPart leftLeg;
    public ModelPart leftArm;
    public ModelPart tail;
    public ModelPart leftWing;
    public ModelPart rightLeg;
    public ModelPart rightArm;
    public ModelPart rightWing;
    public ModelPart hair;
    public ModelPart leftEye;
    public ModelPart rightEye;
    public ModelPart leftEar;
    public ModelPart tentacle1;
    public ModelPart tentacle2;
    public ModelPart tentacle3;
    public ModelPart rightEar;
    public ModelPart hat1;
    public ModelPart trunk1;
    public ModelPart hat2;
    public ModelPart trunk2;
    public ModelPart trunk3;
    public ModelPart lantern1;
    public ModelPart lantern2;
    public ModelPart lantern3;
    public DragonFamiliarModel.ColorModelPartProxy lantern4;

    public CthulhuFamiliarModel(ModelPart part) {
        this.body = part.m_171324_("body");
        this.head = this.body.m_171324_("head");
        this.leftLeg = this.body.m_171324_("leftLeg");
        this.leftArm = this.body.m_171324_("leftArm");
        this.tail = this.body.m_171324_("tail");
        this.leftWing = this.body.m_171324_("leftWing");
        this.rightLeg = this.body.m_171324_("rightLeg");
        this.rightArm = this.body.m_171324_("rightArm");
        this.rightWing = this.body.m_171324_("rightWing");
        this.hair = this.head.m_171324_("hair");
        this.leftEye = this.head.m_171324_("leftEye");
        this.rightEye = this.head.m_171324_("rightEye");
        this.leftEar = this.head.m_171324_("leftEar");
        this.tentacle1 = this.head.m_171324_("tentacle1");
        this.tentacle2 = this.head.m_171324_("tentacle2");
        this.tentacle3 = this.head.m_171324_("tentacle3");
        this.rightEar = this.head.m_171324_("rightEar");
        this.hat1 = this.head.m_171324_("hat1");
        this.trunk1 = this.head.m_171324_("trunk1");
        this.hat2 = this.hat1.m_171324_("hat2");
        this.trunk2 = this.trunk1.m_171324_("trunk2");
        this.trunk3 = this.trunk2.m_171324_("trunk3");
        this.lantern1 = this.leftArm.m_171324_("lantern1");
        this.lantern2 = this.lantern1.m_171324_("lantern2");
        this.lantern3 = this.lantern2.m_171324_("lantern3");
        this.lantern4 = new DragonFamiliarModel.ColorModelPartProxy(this.lantern3.m_171324_("lantern4"));
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition parts = mesh.m_171576_();
        PartDefinition body = parts.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171506_(-3.5f, -6.0f, -1.5f, 7.0f, 7.0f, 3.0f, false), PartPose.m_171423_((float)0.0f, (float)17.0f, (float)0.0f, (float)0.43912482f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(20, 0).m_171506_(-3.0f, -5.0f, -3.2f, 6.0f, 5.0f, 6.0f, false), PartPose.m_171423_((float)0.0f, (float)-5.8f, (float)-0.3f, (float)-0.2628466f, (float)0.0f, (float)0.0f));
        PartDefinition leftLeg = body.m_171599_("leftLeg", CubeListBuilder.m_171558_().m_171514_(44, 0).m_171506_(-1.0f, 0.0f, -1.0f, 2.0f, 5.0f, 2.0f, false), PartPose.m_171423_((float)2.0f, (float)0.5f, (float)0.0f, (float)-0.39426988f, (float)0.0f, (float)0.0f));
        PartDefinition leftArm = body.m_171599_("leftArm", CubeListBuilder.m_171558_().m_171514_(52, 0).m_171506_(0.0f, -1.0f, -1.0f, 2.0f, 5.0f, 2.0f, false), PartPose.m_171423_((float)3.2f, (float)-4.5f, (float)0.0f, (float)-1.6891296f, (float)0.0f, (float)0.0f));
        PartDefinition tail = body.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171506_(0.0f, -1.0f, 0.0f, 0.0f, 5.0f, 5.0f, false), PartPose.m_171423_((float)0.0f, (float)-2.0f, (float)1.0f, (float)0.628493f, (float)0.0f, (float)0.0f));
        PartDefinition leftWing = body.m_171599_("leftWing", CubeListBuilder.m_171558_().m_171514_(20, 21).m_171506_(0.0f, -8.0f, 0.0f, 8.0f, 8.0f, 0.0f, false), PartPose.m_171423_((float)2.4f, (float)-5.0f, (float)1.4f, (float)-0.1314233f, (float)-0.42917648f, (float)0.5256932f));
        PartDefinition rightLeg = body.m_171599_("rightLeg", CubeListBuilder.m_171558_().m_171514_(44, 0).m_171506_(-1.0f, 0.0f, -1.0f, 2.0f, 5.0f, 2.0f, true), PartPose.m_171423_((float)-2.0f, (float)0.5f, (float)0.0f, (float)-0.39426988f, (float)0.0f, (float)0.0f));
        PartDefinition rightArm = body.m_171599_("rightArm", CubeListBuilder.m_171558_().m_171514_(52, 0).m_171506_(-2.0f, -1.0f, -1.0f, 2.0f, 5.0f, 2.0f, true), PartPose.m_171423_((float)-3.2f, (float)-4.5f, (float)0.0f, (float)-0.43807766f, (float)0.0f, (float)0.0f));
        PartDefinition rightWing = body.m_171599_("rightWing", CubeListBuilder.m_171558_().m_171514_(20, 21).m_171506_(-8.0f, -8.0f, 0.0f, 8.0f, 8.0f, 0.0f, true), PartPose.m_171423_((float)-2.4f, (float)-5.0f, (float)1.4f, (float)-0.1314233f, (float)0.42917648f, (float)-0.5256932f));
        PartDefinition hair = head.m_171599_("hair", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171506_(0.0f, -7.0f, -3.2f, 0.0f, 7.0f, 10.0f, false), PartPose.m_171423_((float)0.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftEye = head.m_171599_("leftEye", CubeListBuilder.m_171558_().m_171514_(26, 12).m_171506_(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 2.0f, false), PartPose.m_171423_((float)1.3f, (float)-3.0f, (float)-3.7f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightEye = head.m_171599_("rightEye", CubeListBuilder.m_171558_().m_171514_(26, 12).m_171506_(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 2.0f, false), PartPose.m_171423_((float)-1.3f, (float)-3.0f, (float)-3.7f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftEar = head.m_171599_("leftEar", CubeListBuilder.m_171558_().m_171514_(0, 21).m_171506_(0.0f, 0.0f, 0.0f, 3.0f, 4.0f, 0.0f, false), PartPose.m_171423_((float)3.0f, (float)-4.5f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition tentacle1 = head.m_171599_("tentacle1", CubeListBuilder.m_171558_().m_171514_(0, 17).m_171506_(-0.5f, 0.0f, -1.0f, 1.0f, 3.0f, 1.0f, false), PartPose.m_171423_((float)-0.1f, (float)-1.1f, (float)-2.8f, (float)-0.19338249f, (float)0.0f, (float)0.57595867f));
        PartDefinition tentacle2 = head.m_171599_("tentacle2", CubeListBuilder.m_171558_().m_171514_(0, 17).m_171506_(-0.5f, 0.0f, -1.0f, 1.0f, 3.0f, 1.0f, false), PartPose.m_171423_((float)0.0f, (float)-1.4f, (float)-2.8f, (float)-0.19338249f, (float)0.0f, (float)0.0f));
        PartDefinition tentacle3 = head.m_171599_("tentacle3", CubeListBuilder.m_171558_().m_171514_(0, 17).m_171506_(-0.5f, 0.0f, -1.0f, 1.0f, 3.0f, 1.0f, false), PartPose.m_171423_((float)0.1f, (float)-1.1f, (float)-2.8f, (float)-0.19338249f, (float)0.0f, (float)-0.57595867f));
        PartDefinition rightEar = head.m_171599_("rightEar", CubeListBuilder.m_171558_().m_171514_(0, 21).m_171506_(-3.0f, 0.0f, 0.0f, 3.0f, 4.0f, 0.0f, true), PartPose.m_171423_((float)-3.0f, (float)-4.5f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition hat1 = head.m_171599_("hat1", CubeListBuilder.m_171558_().m_171514_(20, 16).m_171506_(-2.0f, 0.0f, -2.0f, 4.0f, 1.0f, 4.0f, false), PartPose.m_171423_((float)2.5f, (float)-5.5f, (float)-3.0f, (float)0.27366763f, (float)-0.039095376f, (float)0.23457225f));
        PartDefinition trunk1 = head.m_171599_("trunk1", CubeListBuilder.m_171558_().m_171514_(44, 7).m_171506_(-1.5f, 0.0f, -1.0f, 3.0f, 2.0f, 2.0f, false), PartPose.m_171423_((float)0.0f, (float)-1.1f, (float)-2.2f, (float)-0.86009824f, (float)0.0f, (float)0.0f));
        PartDefinition hat2 = hat1.m_171599_("hat2", CubeListBuilder.m_171558_().m_171514_(36, 16).m_171506_(-2.0f, 0.0f, -2.0f, 3.0f, 2.0f, 3.0f, false), PartPose.m_171423_((float)0.5f, (float)-2.0f, (float)0.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition trunk2 = trunk1.m_171599_("trunk2", CubeListBuilder.m_171558_().m_171514_(44, 11).m_171506_(-1.0f, 0.0f, -1.0f, 2.0f, 2.0f, 2.0f, false), PartPose.m_171423_((float)0.0f, (float)1.5f, (float)0.0f, (float)-0.4691445f, (float)0.0f, (float)0.0f));
        PartDefinition trunk3 = trunk2.m_171599_("trunk3", CubeListBuilder.m_171558_().m_171514_(54, 7).m_171506_(-0.5f, 0.0f, -1.0f, 1.0f, 2.0f, 2.0f, false), PartPose.m_171423_((float)0.0f, (float)1.5f, (float)0.0f, (float)0.39095375f, (float)0.0f, (float)0.0f));
        PartDefinition lantern1 = leftArm.m_171599_("lantern1", CubeListBuilder.m_171558_().m_171514_(58, 29).m_171506_(-1.5f, 0.0f, 0.0f, 3.0f, 3.0f, 0.0f, false), PartPose.m_171423_((float)1.0f, (float)3.5f, (float)-0.5f, (float)1.2901473f, (float)0.0f, (float)0.0f));
        PartDefinition lantern2 = lantern1.m_171599_("lantern2", CubeListBuilder.m_171558_().m_171514_(42, 23).m_171506_(-2.0f, 0.0f, -2.0f, 4.0f, 5.0f, 4.0f, false), PartPose.m_171423_((float)0.0f, (float)2.5f, (float)0.0f, (float)0.0f, (float)0.7853982f, (float)0.0f));
        PartDefinition lantern3 = lantern2.m_171599_("lantern3", CubeListBuilder.m_171558_().m_171514_(34, 27).m_171506_(-1.0f, -3.0f, -1.0f, 2.0f, 3.0f, 2.0f, false), PartPose.m_171423_((float)0.0f, (float)4.99f, (float)0.0f, (float)0.0f, (float)-0.7853982f, (float)0.0f));
        PartDefinition lantern4 = lantern3.m_171599_("lantern4", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171506_(-0.5f, -0.5f, 0.0f, 1.0f, 1.0f, 0.0f, false), PartPose.m_171423_((float)0.0f, (float)-3.3f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7853982f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)32);
    }

    public void m_7695_(PoseStack pPoseStack, VertexConsumer pBuffer, int pPackedLight, int pPackedOverlay, float red, float green, float blue, float alpha) {
        this.body.m_104306_(pPoseStack, pBuffer, pPackedLight, pPackedOverlay, red, green, blue, alpha);
        this.lantern4.proxyRender(pPoseStack, pBuffer, pPackedLight, pPackedOverlay, red, green, blue, alpha);
    }

    public void setupAnim(CthulhuFamiliarEntity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float partialTicks = Minecraft.m_91087_().m_91296_();
        entityIn.riderLimbSwing = limbSwing;
        entityIn.riderLimbSwingAmount = limbSwingAmount;
        this.showModels(entityIn);
        this.lantern4.setColor(1.0f, 1.0f, 1.0f, (Mth.m_14089_((float)(ageInTicks * 0.2f)) + 1.0f) * 0.5f);
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180) * 0.7f;
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180) * 0.7f - 0.26f;
        if (entityIn.isPartying()) {
            this.body.f_104203_ = -this.toRads(90.0f);
            this.rightLeg.f_104203_ = this.toRads(15.0f);
            this.leftLeg.f_104203_ = this.toRads(15.0f);
            this.head.f_104204_ = 0.0f;
            this.head.f_104203_ = 0.0f;
        } else if (entityIn.isSitting()) {
            this.rightArm.f_104203_ = 0.0f;
            this.leftArm.f_104203_ = 0.0f;
            this.rightLeg.f_104203_ = -1.5707964f;
            this.leftLeg.f_104203_ = -1.5707964f;
            this.body.f_104203_ = 0.0f;
        } else {
            this.rightArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.5f + (float)Math.PI)) * limbSwingAmount * 0.2f - 0.44f;
            this.leftArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.5f + (float)Math.PI)) * limbSwingAmount * 0.2f - 0.44f;
            this.rightLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.5f)) * 1.4f * limbSwingAmount * 0.2f - 0.39f;
            this.leftLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.5f)) * 1.4f * limbSwingAmount * 0.2f - 0.39f;
            float f = this.body.f_104203_ = entityIn.m_20069_() ? 1.0f : 0.44f;
        }
        if (entityIn.isAngry()) {
            this.leftEye.f_104205_ = -this.toRads(45.0f);
            this.rightEye.f_104205_ = -this.toRads(45.0f);
            this.leftEar.f_104205_ = this.toRads(20.0f);
            this.rightEar.f_104205_ = -this.toRads(20.0f);
        } else {
            this.leftEye.f_104205_ = 0.0f;
            this.rightEye.f_104205_ = 0.0f;
            this.leftEar.f_104205_ = 0.0f;
            this.rightEar.f_104205_ = 0.0f;
        }
        if (entityIn.isGiving()) {
            this.leftArm.f_104204_ = this.toRads(40.0f);
            this.rightArm.f_104204_ = -this.toRads(40.0f);
            this.leftArm.f_104203_ -= this.toRads(40.0f);
            this.rightArm.f_104203_ -= this.toRads(40.0f);
        } else {
            this.leftArm.f_104204_ = 0.0f;
            this.rightArm.f_104204_ = 0.0f;
        }
        this.trunk1.f_104203_ = -0.86f + Mth.m_14089_((float)(ageInTicks / 10.0f)) * 0.15f;
        this.trunk2.f_104203_ = -0.47f + Mth.m_14089_((float)(ageInTicks / 10.0f)) * 0.15f;
        this.trunk3.f_104203_ = 0.39f + Mth.m_14089_((float)(ageInTicks / 10.0f)) * 0.15f;
        this.tentacle1.f_104205_ = 0.58f + Mth.m_14089_((float)(ageInTicks / 10.0f)) * 0.07f;
        this.tentacle3.f_104205_ = -0.58f - Mth.m_14089_((float)(ageInTicks / 10.0f)) * 0.07f;
        if (entityIn.hasBlacksmithUpgrade()) {
            if (entityIn.isSitting()) {
                this.lantern1.f_104203_ = this.toRads(0.0f);
                this.lantern1.f_104201_ = -1.6f;
                this.lantern1.f_104200_ = 3.0f;
                this.lantern1.f_104202_ = -5.0f;
            } else {
                this.leftArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.4f + (float)Math.PI)) * limbSwingAmount * 0.2f + this.toRads(-100.0f);
                this.lantern1.f_104204_ = Mth.m_14089_((float)(ageInTicks * 0.2f)) * this.toRads(5.0f);
                this.lantern1.f_104205_ = -Mth.m_14089_((float)(ageInTicks * 0.2f)) * this.toRads(5.0f);
                this.lantern1.f_104203_ = this.toRads(74.0f);
                this.lantern1.f_104201_ = 3.5f;
                this.lantern1.f_104200_ = 1.0f;
                this.lantern1.f_104202_ = -0.5f;
            }
        }
        if (entityIn.m_20160_()) {
            float animHeight = entityIn.getAnimationHeight(partialTicks);
            this.rightArm.f_104203_ = this.toRads(40.0f - animHeight * 15.0f);
        }
    }

    public void prepareMobModel(CthulhuFamiliarEntity entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        if (entityIn.isSitting() && !entityIn.isPartying()) {
            this.leftWing.f_104204_ = -0.43f;
            this.rightWing.f_104204_ = 0.43f;
        } else {
            float animationHeight = entityIn.getAnimationHeight(partialTick);
            this.leftWing.f_104204_ = animationHeight * this.toRads(20.0f) - 0.43f;
            this.rightWing.f_104204_ = -animationHeight * this.toRads(20.0f) + 0.43f;
        }
    }

    private float toRads(float deg) {
        return (float)Math.PI / 180 * deg;
    }

    private void showModels(CthulhuFamiliarEntity entity) {
        boolean hasTrunk = entity.hasTrunk();
        this.hat1.f_104207_ = entity.hasHat();
        this.lantern1.f_104207_ = entity.hasBlacksmithUpgrade();
        this.trunk1.f_104207_ = hasTrunk;
        this.tentacle1.f_104207_ = !hasTrunk;
        this.tentacle2.f_104207_ = !hasTrunk;
        this.tentacle3.f_104207_ = !hasTrunk;
    }
}

