/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.client.gui.controls;

import com.github.klikli_dev.occultism.api.client.gui.IStorageControllerGuiContainer;
import com.github.klikli_dev.occultism.api.common.data.MachineReference;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;

public class MachineSlotWidget {
    protected int x;
    protected int y;
    protected int guiLeft;
    protected int guiTop;
    protected Minecraft minecraft;
    protected IStorageControllerGuiContainer parent;
    protected MachineReference machine;
    protected Font fontRenderer;
    protected int slotHighlightColor;

    public MachineSlotWidget(IStorageControllerGuiContainer parent, @Nonnull MachineReference machine, int x, int y, int guiLeft, int guiTop) {
        this.x = x;
        this.y = y;
        this.guiLeft = guiLeft;
        this.guiTop = guiTop;
        this.parent = parent;
        this.minecraft = Minecraft.m_91087_();
        this.machine = machine;
        this.fontRenderer = this.parent.getFontRenderer();
        this.slotHighlightColor = new Color(255, 255, 255, 128).getRGB();
    }

    public MachineReference getMachine() {
        return this.machine;
    }

    public void setMachine(MachineReference machine) {
        this.machine = machine;
    }

    public boolean isMouseOverSlot(double mouseX, double mouseY) {
        return this.parent.isPointInRegionController(this.x - this.guiLeft, this.y - this.guiTop, 16, 16, mouseX, mouseY);
    }

    public void drawSlot(PoseStack poseStack, int mx, int my) {
        poseStack.m_85836_();
        boolean isMouseOverSlot = this.isMouseOverSlot(mx, my);
        if (isMouseOverSlot) {
            this.minecraft.m_91291_().m_115203_(this.machine.getExtractItemStack(), this.x, this.y);
        } else {
            this.minecraft.m_91291_().m_115203_(this.machine.getInsertItemStack(), this.x, this.y);
        }
        if (isMouseOverSlot) {
            RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            this.parent.drawGradientRect(poseStack, this.x, this.y, this.x + 16, this.y + 16, this.slotHighlightColor, this.slotHighlightColor);
            RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        }
        poseStack.m_85849_();
    }

    public void drawTooltip(PoseStack poseStack, int mx, int my) {
        if (this.isMouseOverSlot(mx, my)) {
            this.parent.renderToolTip(poseStack, this.machine, mx, my);
        }
    }
}

