/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.property;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftbteams.property.TeamProperty;
import dev.ftb.mods.ftbteams.property.TeamPropertyType;
import dev.ftb.mods.ftbteams.property.TeamPropertyValue;
import java.util.Optional;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class IntProperty
extends TeamProperty<Integer> {
    public final int minValue;
    public final int maxValue;

    public IntProperty(ResourceLocation id, int def, int min, int max) {
        super(id, def);
        this.minValue = min;
        this.maxValue = max;
    }

    public IntProperty(ResourceLocation id, int def) {
        this(id, def, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public IntProperty(ResourceLocation id, FriendlyByteBuf buf) {
        super(id, buf.m_130242_());
        this.minValue = buf.m_130242_();
        this.maxValue = buf.m_130242_();
    }

    @Override
    public TeamPropertyType<Integer> getType() {
        return TeamPropertyType.INT;
    }

    @Override
    public Optional<Integer> fromString(String string) {
        try {
            int num = Integer.parseInt(string);
            return Optional.of(Mth.m_14045_((int)num, (int)this.minValue, (int)this.maxValue));
        }
        catch (Exception ex) {
            return Optional.empty();
        }
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.m_130130_(((Integer)this.defaultValue).intValue());
        buf.m_130130_(this.minValue);
        buf.m_130130_(this.maxValue);
    }

    @Override
    public void config(ConfigGroup config, TeamPropertyValue<Integer> value) {
        config.addInt(this.id.m_135827_() + "." + this.id.m_135815_(), ((Integer)value.value).intValue(), value.consumer, ((Integer)this.defaultValue).intValue(), this.minValue, this.maxValue);
    }

    @Override
    public Tag toNBT(Integer value) {
        return IntTag.m_128679_((int)value);
    }

    @Override
    public Optional<Integer> fromNBT(Tag tag) {
        if (tag instanceof NumericTag) {
            return Optional.of(Mth.m_14045_((int)((NumericTag)tag).m_7047_(), (int)this.minValue, (int)this.maxValue));
        }
        return Optional.empty();
    }
}

