/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.property;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftbteams.property.TeamProperty;
import dev.ftb.mods.ftbteams.property.TeamPropertyType;
import dev.ftb.mods.ftbteams.property.TeamPropertyValue;
import java.util.Optional;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class BooleanProperty
extends TeamProperty<Boolean> {
    private static final Optional<Boolean> TRUE = Optional.of(Boolean.TRUE);
    private static final Optional<Boolean> FALSE = Optional.of(Boolean.FALSE);

    public BooleanProperty(ResourceLocation id, Boolean def) {
        super(id, def);
    }

    public BooleanProperty(ResourceLocation id, FriendlyByteBuf buf) {
        super(id, buf.readBoolean());
    }

    @Override
    public TeamPropertyType<Boolean> getType() {
        return TeamPropertyType.BOOLEAN;
    }

    @Override
    public Optional<Boolean> fromString(String string) {
        if (string.equals("true")) {
            return TRUE;
        }
        if (string.equals("false")) {
            return FALSE;
        }
        return Optional.empty();
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.writeBoolean(((Boolean)this.defaultValue).booleanValue());
    }

    @Override
    public void config(ConfigGroup config, TeamPropertyValue<Boolean> value) {
        config.addBool(this.id.m_135827_() + "." + this.id.m_135815_(), ((Boolean)value.value).booleanValue(), value.consumer, ((Boolean)this.defaultValue).booleanValue());
    }

    @Override
    public Tag toNBT(Boolean value) {
        return ByteTag.m_128273_((boolean)value);
    }

    @Override
    public Optional<Boolean> fromNBT(Tag tag) {
        if (tag instanceof NumericTag) {
            if (((NumericTag)tag).m_7063_() == 1) {
                return TRUE;
            }
            return FALSE;
        }
        return Optional.empty();
    }
}

