/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.modintegration.handlers.mekanism;

import java.util.Random;
import mekanism.api.Action;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalTankBuilder;
import mekanism.api.chemical.attribute.ChemicalAttributeValidator;
import mekanism.api.chemical.slurry.ISlurryHandler;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.common.capabilities.Capabilities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import shetiphian.endertanks.Configuration;
import shetiphian.endertanks.api.HandlerRegistry;
import shetiphian.endertanks.api.IEnderTankInfo;
import shetiphian.endertanks.api.ITankHandler;
import shetiphian.endertanks.api.StorageAccessMode;
import shetiphian.endertanks.modintegration.handlers.mekanism.WrapperSlurryHandler;

public class TypeSlurry {
    public static void init() {
        if (((Boolean)Configuration.INTEGRATION.storeMekanismSlurry.get()).booleanValue() && ISlurryHandler.class != null) {
            HandlerRegistry.register(Capabilities.SLURRY_HANDLER_CAPABILITY, SlurryTankHandler.Provider.INSTANCE);
        }
    }

    public static class SlurryTankHandler
    implements ITankHandler<ISlurryHandler> {
        private final ChemicalTankBuilder.BasicSlurryTank slurryTank;
        private final ISlurryHandler slurryTankInsertOnly;
        private final ISlurryHandler slurryTankExtractOnly;
        private long tankCapacity;

        public SlurryTankHandler(final IEnderTankInfo tank) {
            this.tankCapacity = (long)tank.getCapacity() * 1000L;
            this.slurryTank = new ChemicalTankBuilder.BasicSlurryTank(this.tankCapacity, (stack, type) -> true, (stack, type) -> true, stack -> true, ChemicalAttributeValidator.ALWAYS_ALLOW, null){

                public long getCapacity() {
                    return tankCapacity;
                }

                public void onContentsChanged() {
                    tank.notifyContentsChange();
                }
            };
            this.slurryTankInsertOnly = new WrapperSlurryHandler((ISlurryHandler)this.slurryTank, true, false);
            this.slurryTankExtractOnly = new WrapperSlurryHandler((ISlurryHandler)this.slurryTank, false, true);
        }

        @Override
        public ISlurryHandler getTank(StorageAccessMode access) {
            return switch (access) {
                case StorageAccessMode.INSERT_ONLY -> this.slurryTankInsertOnly;
                case StorageAccessMode.EXTRACT_ONLY -> this.slurryTankExtractOnly;
                default -> this.slurryTank;
            };
        }

        @Override
        public void setCapacity(int capacity) {
            int newCapacity = capacity * 1000;
            if (this.tankCapacity != (long)newCapacity) {
                this.tankCapacity = newCapacity;
                this.slurryTank.onContentsChanged();
            }
        }

        @Override
        public void load(CompoundTag nbt) {
            this.slurryTank.deserializeNBT(nbt);
        }

        @Override
        public CompoundTag save() {
            return !this.slurryTank.isEmpty() ? this.slurryTank.serializeNBT() : null;
        }

        @Override
        public MutableComponent getContentsInfo() {
            SlurryStack stack = (SlurryStack)this.slurryTank.getStack();
            if (!stack.isEmpty()) {
                return new TextComponent(" ").m_7220_((Component)new TranslatableComponent("info.endertanks.tank.type.mekanism.slurry")).m_130946_(" ").m_7220_((Component)new TranslatableComponent(((Slurry)stack.getType()).getTranslationKey())).m_130946_(" [" + (float)stack.getAmount() / 1000.0f + "K/" + this.slurryTank.getCapacity() / 1000L + "K mB]");
            }
            return null;
        }

        @Override
        public void preformPumpAction(Level world, BlockPos pos, Direction facing, BlockPos pullFromPos, BlockPos pushToPos, int pumpCapacity, Random random) {
            ISlurryHandler toHandler;
            SlurryStack slurryStack;
            long used;
            ISlurryHandler fromHandler;
            if (this.slurryTank.getStored() < this.slurryTank.getCapacity() && (fromHandler = this.getHandler(world.m_7702_(pullFromPos), facing)) != null && (used = (slurryStack = (SlurryStack)fromHandler.extractChemical((long)pumpCapacity, Action.SIMULATE)).getAmount() - ((SlurryStack)this.slurryTank.insertChemical((ChemicalStack)slurryStack, Action.SIMULATE)).getAmount()) > 0L) {
                this.slurryTank.insertChemical((ChemicalStack)((SlurryStack)fromHandler.extractChemical(used, Action.EXECUTE)), Action.EXECUTE);
            }
            if (!this.slurryTank.isEmpty() && (toHandler = this.getHandler(world.m_7702_(pushToPos), facing.m_122424_())) != null && (used = (slurryStack = (SlurryStack)this.slurryTank.extractChemical((long)pumpCapacity, Action.SIMULATE)).getAmount() - ((SlurryStack)toHandler.insertChemical((ChemicalStack)slurryStack, Action.SIMULATE)).getAmount()) > 0L) {
                toHandler.insertChemical((ChemicalStack)((SlurryStack)this.slurryTank.extractChemical(used, Action.EXECUTE)), Action.EXECUTE);
            }
        }

        public ISlurryHandler getHandler(BlockEntity tile, Direction facing) {
            return tile == null ? null : (ISlurryHandler)tile.getCapability(Capabilities.SLURRY_HANDLER_CAPABILITY, facing).orElse(null);
        }

        public static class Provider
        implements HandlerRegistry.ITankHandlerProvider<ISlurryHandler> {
            public static Provider INSTANCE = new Provider();

            @Override
            public ITankHandler<ISlurryHandler> create(IEnderTankInfo tank) {
                return new SlurryTankHandler(tank);
            }
        }
    }
}

