/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.common.tileentity;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import shetiphian.core.common.Function;
import shetiphian.core.common.NameHelper;
import shetiphian.core.common.rgb16.IRGB16_Tile;
import shetiphian.core.common.rgb16.RGB16;
import shetiphian.core.common.rgb16.RGB16Helper;
import shetiphian.core.common.tileentity.TileEntityBase;
import shetiphian.endertanks.Configuration;
import shetiphian.endertanks.Values;
import shetiphian.endertanks.api.StorageAccessMode;
import shetiphian.endertanks.common.block.BlockEnderTank;
import shetiphian.endertanks.common.misc.EnderContainer;
import shetiphian.endertanks.common.misc.LocationManager;
import shetiphian.endertanks.common.misc.TankHelper;
import shetiphian.endertanks.common.misc.TankInfoHelper;

public class TileEntityEnderTank
extends TileEntityBase
implements IRGB16_Tile {
    private String code = "000";
    private String ownerID = null;
    private String owner = "all";
    private ItemStack personalItem;
    private final ArrayList<ItemStack> pumpUpgrades = new ArrayList();
    public long lastClick = 0L;
    private final List<String> usedUpgrades = new ArrayList<String>();

    public TileEntityEnderTank(BlockPos pos, BlockState state) {
        super(Values.tileEnderTank, pos, state);
    }

    public void buildNBT(CompoundTag nbtTag) {
        nbtTag.m_128359_("code", this.getCode());
        nbtTag.m_128359_("owner", this.owner);
        if (!Strings.isNullOrEmpty((String)this.ownerID)) {
            nbtTag.m_128359_("owner.id", this.ownerID);
        }
        nbtTag.m_128359_("owner_id", this.getOwnerID());
        if (!this.pumpUpgrades.isEmpty()) {
            ListTag listItems = new ListTag();
            for (ItemStack stack : this.pumpUpgrades) {
                CompoundTag compound = new CompoundTag();
                stack.m_41739_(compound);
                listItems.add((Object)compound);
            }
            nbtTag.m_128365_("upgrade.pump", (Tag)listItems);
        }
        if (this.personalItem != null) {
            CompoundTag compound = new CompoundTag();
            this.personalItem.m_41739_(compound);
            nbtTag.m_128365_("upgrade.access", (Tag)compound);
            nbtTag.m_128359_("personal", this.personalItem.m_41720_().getRegistryName().toString());
        }
        if (!this.usedUpgrades.isEmpty()) {
            ListTag listNBT = new ListTag();
            for (String upgrade : this.usedUpgrades) {
                listNBT.add((Object)StringTag.m_129297_((String)upgrade));
            }
            nbtTag.m_128365_("used_upgrades", (Tag)listNBT);
        }
    }

    public void processNBT(CompoundTag nbtTag) {
        this.setCode(nbtTag.m_128461_("code"));
        this.owner = nbtTag.m_128461_("owner");
        if (nbtTag.m_128441_("owner.id")) {
            this.ownerID = nbtTag.m_128461_("owner.id");
        }
        if (nbtTag.m_128441_("upgrade.pump")) {
            this.pumpUpgrades.clear();
            ListTag listItems = nbtTag.m_128437_("upgrade.pump", 10);
            for (int entry2 = 0; entry2 < listItems.size(); ++entry2) {
                CompoundTag compound = listItems.m_128728_(entry2);
                ItemStack stack = ItemStack.m_41712_((CompoundTag)compound);
                if (stack.m_41619_()) continue;
                if (stack.m_41613_() != 1) {
                    stack.m_41764_(1);
                }
                this.pumpUpgrades.add(stack);
            }
        }
        if (nbtTag.m_128441_("upgrade.access")) {
            ItemStack stack = ItemStack.m_41712_((CompoundTag)nbtTag.m_128469_("upgrade.access"));
            if (!stack.m_41619_() && stack.m_41613_() != 1) {
                stack.m_41764_(1);
            }
            this.personalItem = stack;
        }
        if (nbtTag.m_128441_("used_upgrades")) {
            this.usedUpgrades.clear();
            ListTag listNBT = nbtTag.m_128437_("used_upgrades", 8);
            listNBT.listIterator().forEachRemaining(entry -> this.usedUpgrades.add(entry.m_7916_()));
        }
    }

    public void processNBT_SaveOnly(CompoundTag nbtTag) {
        super.processNBT_SaveOnly(nbtTag);
        if (!Strings.isNullOrEmpty((String)this.ownerID)) {
            this.owner = NameHelper.getDisplayNameFor((String)this.ownerID);
        }
    }

    public boolean applyItem(ItemStack stack) {
        String key = stack.m_41720_().getRegistryName().toString();
        if (this.usedUpgrades.contains(key)) {
            return false;
        }
        this.usedUpgrades.add(key);
        return true;
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        LazyOptional<T> optional;
        StorageAccessMode accessMode;
        if (this.canBeAutomated() && (accessMode = this.getAccessForFace(facing)) != null && (optional = this.getEnderContainer().getCapability(capability, accessMode)).isPresent()) {
            return optional;
        }
        return super.getCapability(capability, facing);
    }

    private boolean canBeAutomated() {
        return this.isPublic() ? (Boolean)Configuration.ACCESS_SETTINGS.enableAutomationPublic.get() : (this.isTeam() ? (Boolean)Configuration.ACCESS_SETTINGS.enableAutomationTeam.get() : (Boolean)Configuration.ACCESS_SETTINGS.enableAutomationPersonal.get());
    }

    private StorageAccessMode getAccessForFace(Direction facing) {
        if (facing == null) {
            return StorageAccessMode.FULL;
        }
        BlockState state = this.m_58904_().m_8055_(this.m_58899_());
        Direction tFacing = BlockEnderTank.getFacing(state);
        if (tFacing.m_122434_() == facing.m_122434_()) {
            if (BlockEnderTank.isPowered(state)) {
                return facing == tFacing ? StorageAccessMode.EXTRACT_ONLY : StorageAccessMode.INSERT_ONLY;
            }
            return StorageAccessMode.FULL;
        }
        return null;
    }

    public EnderContainer getEnderContainer() {
        return TankHelper.getTank(this.getOwnerID(), this.getCode(), this.m_58904_().f_46443_);
    }

    public int getPumpCapacity() {
        return this.pumpUpgrades.isEmpty() ? 250 : this.pumpUpgrades.size() * 1000;
    }

    public byte getPumpUpgradeCount() {
        return (byte)this.pumpUpgrades.size();
    }

    public void addPumpUpgrade(ItemStack stack) {
        this.pumpUpgrades.add(stack);
    }

    public boolean canEdit(Player player) {
        boolean canEdit = true;
        String msg = "";
        if (!player.m_150110_().f_35937_) {
            if (this.isTeam()) {
                canEdit = (Boolean)Configuration.ACCESS_SETTINGS.lockTeamEdit.get() == false || this.ownerID.equalsIgnoreCase(this.getPlayerTeam(player));
                msg = "team.denied";
            } else if (!this.isPublic()) {
                canEdit = (Boolean)Configuration.ACCESS_SETTINGS.lockPersonalEdit.get() == false || !Strings.isNullOrEmpty((String)this.ownerID) && this.ownerID.equals(player.m_142081_().toString());
                msg = "private.denied";
            }
        }
        if (!canEdit && !Strings.isNullOrEmpty((String)msg)) {
            TankInfoHelper.sendError(player, "endertanks.tank." + msg);
        }
        return canEdit;
    }

    public boolean canUse(Player player) {
        boolean canUse = true;
        String msg = "";
        if (!player.m_150110_().f_35937_) {
            if (this.isTeam()) {
                canUse = (Boolean)Configuration.ACCESS_SETTINGS.lockTeamUse.get() == false || this.ownerID.equalsIgnoreCase(this.getPlayerTeam(player));
                msg = "team.denied";
            } else if (this.isPublic()) {
                canUse = (Boolean)Configuration.ACCESS_SETTINGS.allowPublicTanks.get();
                msg = "public.disabled";
            } else {
                canUse = (Boolean)Configuration.ACCESS_SETTINGS.lockPersonalUse.get() == false || !Strings.isNullOrEmpty((String)this.ownerID) && this.ownerID.equals(player.m_142081_().toString());
                msg = "private.denied";
            }
        }
        if (!canUse && !Strings.isNullOrEmpty((String)msg)) {
            TankInfoHelper.sendError(player, "endertanks.tank." + msg);
        }
        return canUse;
    }

    public boolean canLink(Player player) {
        boolean canLink = true;
        String msg = "";
        if (!player.m_150110_().f_35937_) {
            if (this.isTeam()) {
                if (((Boolean)Configuration.ACCESS_SETTINGS.allowTeamBuckets.get()).booleanValue()) {
                    canLink = (Boolean)Configuration.ACCESS_SETTINGS.lockTeamLink.get() == false || this.ownerID.equalsIgnoreCase(this.getPlayerTeam(player));
                    msg = "tank.team.denied";
                } else {
                    canLink = false;
                    msg = "bucket.team.disabled";
                }
            } else if (!this.isPublic()) {
                if (((Boolean)Configuration.ACCESS_SETTINGS.allowPersonalBuckets.get()).booleanValue()) {
                    canLink = (Boolean)Configuration.ACCESS_SETTINGS.lockPersonalLink.get() == false || !Strings.isNullOrEmpty((String)this.ownerID) && this.ownerID.equals(player.m_142081_().toString());
                    msg = "tank.private.denied";
                } else {
                    canLink = false;
                    msg = "bucket.private.disabled";
                }
            }
        }
        if (!canLink && !Strings.isNullOrEmpty((String)msg)) {
            TankInfoHelper.sendError(player, "endertanks." + msg);
        }
        return canLink;
    }

    private String getPlayerTeam(Player player) {
        String team = Function.getPlayerTeamID((Player)player);
        return "#" + (Strings.isNullOrEmpty((String)team) ? "none" : team);
    }

    private String getOwner() {
        return !Strings.isNullOrEmpty((String)this.owner) ? this.owner : "all";
    }

    public String getOwnerID() {
        if (this.getOwner().equalsIgnoreCase("all")) {
            return "all";
        }
        if (!Strings.isNullOrEmpty((String)this.ownerID)) {
            return this.ownerID;
        }
        return this.getOwner();
    }

    public String getOwnerName() {
        return TankInfoHelper.getDisplayNameFromOwnerID(this.ownerID);
    }

    public void setOwner(Player player, ItemStack stack) {
        this.clearMyLocation();
        this.personalItem = stack;
        this.owner = player.m_5446_().getString();
        this.ownerID = player.m_142081_().toString();
        this.setMyLocation();
    }

    public void setOwner(String ownerName, String ownerID, ItemStack stack) {
        this.clearMyLocation();
        if (ownerID != null) {
            this.personalItem = stack;
            this.owner = ownerName;
            this.ownerID = ownerID;
        }
        this.setMyLocation();
    }

    public ItemStack getPersonalItem() {
        if (this.personalItem != null && !this.personalItem.m_41619_()) {
            if (this.personalItem.m_41613_() != 1) {
                this.personalItem.m_41764_(1);
            }
            return this.personalItem;
        }
        return ItemStack.f_41583_;
    }

    public ArrayList<ItemStack> getPumpUpgrades() {
        ArrayList<ItemStack> upgrades = new ArrayList<ItemStack>();
        if (!this.pumpUpgrades.isEmpty()) {
            for (ItemStack stack : this.pumpUpgrades) {
                if (stack == null) continue;
                if (stack.m_41613_() != 1) {
                    stack.m_41764_(1);
                }
                upgrades.add(stack);
            }
        }
        return upgrades;
    }

    public boolean isPublic() {
        return this.getOwner().equalsIgnoreCase("all");
    }

    public boolean isTeam() {
        return this.ownerID != null && this.ownerID.startsWith("#");
    }

    public String getCode() {
        while (this.code.length() < 3) {
            this.code = "0" + this.code;
        }
        return this.code.toUpperCase();
    }

    public void setCode(String code) {
        this.clearMyLocation();
        while (((String)code).length() < 3) {
            code = "0" + (String)code;
        }
        this.code = ((String)code).toUpperCase();
        this.setMyLocation();
    }

    public boolean hasError() {
        return !this.isPublic() && Strings.isNullOrEmpty((String)this.ownerID);
    }

    public RGB16 getRGB16(Player player) {
        if (player == null) {
            return null;
        }
        int ring = this.getRingHit(player);
        if (ring < 0 || ring > 2) {
            return null;
        }
        int value = Integer.parseInt("" + this.getCode().charAt(ring), 16);
        return new RGB16(DyeColor.m_41053_((int)value).m_41065_());
    }

    public boolean setRGB16(short rgbIndex, Player player) {
        return this.doColorRing(DyeColor.m_41053_((int)RGB16Helper.getSimpleColor((short)rgbIndex)), player);
    }

    public boolean doColorRing(DyeColor color, Player player) {
        if (player == null || !this.canEdit(player) || !((Boolean)Configuration.GENERAL.enableInWorldRecoloring.get()).booleanValue()) {
            return false;
        }
        int ring = this.getRingHit(player);
        if (ring < 0 || ring > 2) {
            return false;
        }
        char charColor = Integer.toHexString(color.m_41060_()).charAt(0);
        char[] charCode = this.getCode().toCharArray();
        if (charCode[ring] != charColor) {
            charCode[ring] = charColor;
            this.setCode("" + charCode[0] + charCode[1] + charCode[2]);
            Function.syncTile((BlockEntity)this);
            return true;
        }
        return false;
    }

    private int getRingHit(Player player) {
        VoxelShape[] shapes = BlockEnderTank.SHAPES.get(this.m_58900_().m_61143_((Property)BlockEnderTank.FACING));
        return Function.getSubShapeHit((Entity)player, (BlockPos)this.m_58899_(), (VoxelShape[])shapes) - 1;
    }

    private void setMyLocation() {
        if (this.m_58898_() && !this.m_58904_().f_46443_) {
            LocationManager.set(this.getOwnerID(), this.getCode(), this);
        }
    }

    private void clearMyLocation() {
        if (this.m_58898_() && !this.m_58904_().f_46443_) {
            LocationManager.clear(this.getOwnerID(), this.getCode(), this);
        }
    }

    public void onLoad() {
        super.onLoad();
        this.setMyLocation();
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.clearMyLocation();
    }
}

