/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.common.misc;

import com.google.common.base.Strings;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;
import shetiphian.core.common.NameHelper;
import shetiphian.endertanks.client.misc.EventHandlerClient;
import shetiphian.endertanks.common.misc.TankHelper;
import shetiphian.endertanks.common.network.NetworkHandler;
import shetiphian.endertanks.common.network.PacketTankInfo;
import shetiphian.endertanks.common.tileentity.TileEntityEnderTank;

public class TankInfoHelper {
    private static final Style GOLD = Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.GOLD));
    private static final Style GRAY = Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.GRAY));
    private static final Style GREEN = Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.GREEN));
    private static final Style AQUA = Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.AQUA));
    private static final Style BOLD_RED = Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.RED)).m_131136_(Boolean.valueOf(true));
    private static final TextComponent DUMMY = new TextComponent("");

    public static void sendTankInfo(Player player, String ownerName, String ownerID, String code, boolean sendAll) {
        TankInfoHelper.sendTankInfo(player, TankHelper.getTank(ownerID, code, player.m_20193_().f_46443_).getContentsInfo(!sendAll), new TextComponent("").m_7220_((Component)new TranslatableComponent("info.endertanks." + (sendAll ? "tank" : "bucket") + ".header").m_130946_(":").m_6270_(GOLD)).m_7220_((Component)TankInfoHelper.infoTankOwner(ownerName, false, true)));
    }

    public static void sendTankInfo(Player player, TileEntityEnderTank tile) {
        TankInfoHelper.sendTankInfo(player, tile.getEnderContainer().getContentsInfo(false), new TextComponent("").m_7220_((Component)new TranslatableComponent("info.endertanks.tank.header").m_130946_(":").m_6270_(GOLD)).m_7220_((Component)TankInfoHelper.infoPump(tile.getPumpCapacity())).m_7220_((Component)TankInfoHelper.infoTankOwner(tile.getOwnerName(), false, true)));
    }

    private static void sendTankInfo(Player player, List<MutableComponent> contents, MutableComponent info) {
        if (contents.size() > 1) {
            contents.add(0, info);
            TankInfoHelper.sendInfo(player, contents.toArray(new MutableComponent[0]));
        } else if (contents.size() == 1) {
            TankInfoHelper.sendInfo(player, info.m_130946_(" ").m_7220_((Component)contents.get(0)));
        }
    }

    public static void getHUDInfo(List<MutableComponent> tooltip, String ownerName, String code, int pump, List<MutableComponent> contents) {
        for (MutableComponent entry : contents) {
            tooltip.add(entry.m_6270_(GRAY));
        }
        tooltip.add(TankInfoHelper.infoPump(pump).m_6270_(GRAY));
        tooltip.add(TankInfoHelper.infoTankOwner(ownerName, true, false));
        tooltip.add(new TextComponent(" ").m_7220_((Component)new TranslatableComponent("info.endertanks.tank.code")).m_7220_((Component)new TextComponent(" " + code)));
    }

    public static void sendCapacityInfo(Player player, TileEntityEnderTank tankTile) {
        TankInfoHelper.sendInfo(player, new TranslatableComponent("info.endertanks.tank.capacity").m_130946_(" " + TankHelper.getTank(tankTile.getOwnerID(), tankTile.getCode(), tankTile.m_58904_().f_46443_).getCapacity()));
    }

    public static void sendPumpInfo(Player player, TileEntityEnderTank tile) {
        TankInfoHelper.sendInfo(player, new TranslatableComponent("info.endertanks.tank.pump.upgrade").m_130946_(" " + tile.getPumpCapacity() + "mB"));
    }

    public static void sendLinkError(Player player, int error) {
        TankInfoHelper.sendInfo(player, new TranslatableComponent("error.endertanks.bucket.nolink" + error).m_6270_(BOLD_RED));
    }

    public static void sendError(Player player, String error) {
        TankInfoHelper.sendInfo(player, new TranslatableComponent("error." + error).m_6270_(BOLD_RED));
    }

    private static MutableComponent infoPump(int capacity) {
        if (capacity >= 1000) {
            return new TextComponent(" " + (float)capacity / 1000.0f + "K mB ").m_7220_((Component)new TranslatableComponent("info.endertanks.tank.pump"));
        }
        return new TextComponent(" " + capacity + "mB ").m_7220_((Component)new TranslatableComponent("info.endertanks.tank.pump"));
    }

    private static MutableComponent infoTankOwner(String owner, boolean displayPublic, boolean comma) {
        if (Strings.isNullOrEmpty((String)owner) || owner.equalsIgnoreCase("all")) {
            if (displayPublic) {
                return new TextComponent(" [-").m_6270_(GOLD).m_7220_((Component)new TranslatableComponent("info.endertanks.tank.public")).m_7220_((Component)new TextComponent("-]"));
            }
            return DUMMY;
        }
        if (owner.startsWith("#")) {
            return new TextComponent(comma ? "," : "").m_7220_((Component)new TextComponent(" [-" + owner.substring(1) + "-]").m_6270_(GREEN));
        }
        return new TextComponent(comma ? "," : "").m_7220_((Component)new TextComponent(" [-" + owner + "-]").m_6270_(AQUA));
    }

    @Nullable
    public static MutableComponent formatTankOwner(String owner) {
        MutableComponent component = TankInfoHelper.infoTankOwner(owner, false, false);
        return component != DUMMY ? component : null;
    }

    public static void sendInfo(Player player, MutableComponent ... message) {
        if (player instanceof ServerPlayer) {
            NetworkHandler.sendToPlayer(new PacketTankInfo((Component[])message), (ServerPlayer)player);
        } else {
            EventHandlerClient.setDelayedMessage((Component[])message);
        }
    }

    public static String getDisplayNameFromOwnerID(String ownerID) {
        if (Strings.isNullOrEmpty((String)ownerID) || ownerID.equalsIgnoreCase("all")) {
            return "all";
        }
        if (ownerID.startsWith("#")) {
            return "#" + NameHelper.getDisplayNameFor((String)ownerID.substring(1));
        }
        return NameHelper.getDisplayNameFor((String)ownerID);
    }
}

