/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.common.misc;

import com.google.common.base.Strings;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.io.File;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.slf4j.Logger;
import shetiphian.core.common.NBTFile;
import shetiphian.endertanks.EnderTanks;
import shetiphian.endertanks.common.misc.EnderContainer;
import shetiphian.endertanks.common.misc.LocationManager;

public class TankHelper {
    public static final TankHelper INSTANCE = new TankHelper();
    private static final Table<String, String, EnderContainer> DATABASE = HashBasedTable.create();
    private static final Table<String, String, EnderContainer> CLIENT_CACHE = HashBasedTable.create();
    public static boolean needsSaving = false;
    private static boolean isLoaded = false;
    private static String saveDir = null;
    private static final DateTimeFormatter dateTime = DateTimeFormatter.ofPattern("yy-MM-dd-HH-mm");

    private static Table<String, String, EnderContainer> getDatabase(boolean isClient) {
        return isClient ? CLIENT_CACHE : DATABASE;
    }

    public static EnderContainer getTank(String owner, String code, boolean isClient) {
        owner = owner.toLowerCase();
        code = code.toUpperCase();
        EnderContainer tank = (EnderContainer)TankHelper.getDatabase(isClient).get((Object)owner, (Object)code);
        if (tank == null) {
            tank = new EnderContainer(owner, code);
            TankHelper.getDatabase(isClient).put((Object)owner, (Object)code, (Object)tank);
        }
        return tank;
    }

    public static short getCapacityInBuckets(EnderContainer tank) {
        return (short)tank.getCapacity();
    }

    public static void setCapacityInBuckets(EnderContainer tank, short capacity) {
        tank.setCapacity(capacity);
    }

    public void saveTankData(WorldEvent.Save event) {
        if (event.getWorld() == null || event.getWorld().m_5776_() || !needsSaving) {
            return;
        }
        if (!isLoaded) {
            EnderTanks.LOGGER.error("Attempted to save EnderTank Data when nothing is loaded");
            return;
        }
        this.saveTankData();
    }

    private void saveTankData() {
        if (Strings.isNullOrEmpty((String)saveDir)) {
            saveDir = "sp_recovery" + File.separator + "endertanks" + File.separator + dateTime.format(LocalDateTime.now());
            EnderTanks.LOGGER.error("World Save Directory Unknown, Saving to Recovery Folder: " + saveDir);
        }
        Set networks = DATABASE.rowKeySet();
        for (String owner : networks) {
            Map networkMap = DATABASE.row((Object)owner);
            CompoundTag fileNBT = new CompoundTag();
            for (Map.Entry pocket : networkMap.entrySet()) {
                EnderContainer tank = (EnderContainer)pocket.getValue();
                CompoundTag nbtPocket = tank.save();
                if (nbtPocket == null || nbtPocket.m_128456_()) continue;
                fileNBT.m_128365_((String)pocket.getKey(), (Tag)nbtPocket);
            }
            NBTFile.write((CompoundTag)fileNBT, (File)this.getSaveFile(owner), (Logger)EnderTanks.LOGGER);
        }
        needsSaving = false;
    }

    public void loadTankData() {
        Path folder_old;
        EnderTanks.LOGGER.info("Loading EnderTank Data");
        LocationManager.clear();
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        Path folder = server.m_129843_(new LevelResource("data/endertanks"));
        if (!folder.toFile().exists() && (folder_old = server.m_129843_(new LevelResource("endertanks"))).toFile().exists()) {
            boolean moved = false;
            try {
                moved = folder_old.toFile().renameTo(folder.toFile());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (moved) {
                EnderTanks.LOGGER.info("Moved 'endertanks' folder into 'data' folder");
            } else {
                folder = folder_old;
                EnderTanks.LOGGER.error("Unable to automatically move 'endertanks' folder into 'data' folder. Old location will used. ");
            }
        }
        if (folder == null) {
            EnderTanks.LOGGER.error("Failed to Load Tank Data, World Save Directory Unknown");
            return;
        }
        saveDir = folder.toString();
        List<File> fileList = this.getSaveFiles();
        for (File file : fileList) {
            String owner = this.getOwnerID(file.getName().replace(".dat", "")).toLowerCase();
            CompoundTag fileNBT = NBTFile.read((File)file, (Logger)EnderTanks.LOGGER);
            for (String code : fileNBT.m_128431_()) {
                code = code.toUpperCase();
                EnderContainer tank = new EnderContainer(owner, code);
                tank.load(fileNBT.m_128469_(code));
                DATABASE.put((Object)owner, (Object)code, (Object)tank);
            }
        }
        isLoaded = true;
        EnderTanks.LOGGER.info("Finished Loading EnderTank Data");
    }

    public void unloadTankData() {
        boolean doMessage = false;
        if (isLoaded) {
            EnderTanks.LOGGER.info("Unloading EnderTank Data");
            if (needsSaving) {
                this.saveTankData();
            }
            doMessage = true;
        }
        CLIENT_CACHE.clear();
        DATABASE.clear();
        isLoaded = false;
        saveDir = null;
        LocationManager.clear();
        if (doMessage) {
            EnderTanks.LOGGER.info("Finished Unloading EnderTank Data");
        }
    }

    private List<File> getSaveFiles() {
        ArrayList<File> fileList = new ArrayList<File>();
        File[] listOfFiles = null;
        try {
            File saveFolder = new File(saveDir);
            listOfFiles = saveFolder.listFiles();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (listOfFiles != null) {
            for (File file : listOfFiles) {
                if (!file.isFile() || !file.canRead() || !file.getName().endsWith(".dat")) continue;
                fileList.add(file);
            }
        }
        return fileList;
    }

    private File getSaveFile(String owner) {
        File file = new File(saveDir);
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!(file = new File(saveDir, this.getSaveID(owner) + ".dat")).exists()) {
            try {
                file.createNewFile();
            }
            catch (Exception error) {
                EnderTanks.LOGGER.error("Could Not Read or Create File: " + file.toString(), (Throwable)error);
            }
        }
        return file;
    }

    private String getSaveID(String owner) {
        return owner.equalsIgnoreCase("all") ? "[-Public-]" : owner;
    }

    private String getOwnerID(String owner) {
        return owner.equalsIgnoreCase("[-Public-]") ? "all" : owner;
    }
}

