/*
 * Decompiled with CFR 0.152.
 */
package dev.quarris.enigmaticgraves.setup;

import com.mojang.brigadier.CommandDispatcher;
import dev.quarris.enigmaticgraves.command.RestoreGraveCommand;
import dev.quarris.enigmaticgraves.config.GraveConfigs;
import dev.quarris.enigmaticgraves.grave.GraveManager;
import dev.quarris.enigmaticgraves.grave.PlayerGraveEntry;
import dev.quarris.enigmaticgraves.setup.Registry;
import java.util.ArrayList;
import java.util.LinkedList;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="enigmaticgraves")
public class CommonEvents {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPlayerDeathFirst(LivingDeathEvent event) {
        if (!(event.getEntity() instanceof Player) || event.getEntity().f_19853_.f_46443_ || event.getEntity().f_19853_.m_46469_().m_46207_(GameRules.f_46133_)) {
            return;
        }
        GraveManager.droppedItems = new ArrayList<ItemStack>();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void onPlayerDeathLast(LivingDeathEvent event) {
        if (!(event.getEntity() instanceof Player) || event.getEntity().f_19853_.f_46443_) {
            return;
        }
        if (event.isCanceled()) {
            GraveManager.droppedItems = null;
            return;
        }
        Player player = (Player)event.getEntityLiving();
        GraveManager.prepPlayerGrave(player);
    }

    @SubscribeEvent
    public static void spawnGraveFinder(PlayerEvent.PlayerRespawnEvent event) {
        if (event.isEndConquered()) {
            return;
        }
        if (!((Boolean)GraveConfigs.COMMON.spawnGraveFinder.get()).booleanValue()) {
            return;
        }
        ItemStack graveFinder = new ItemStack((ItemLike)Registry.GRAVE_FINDER_ITEM.get());
        LinkedList<PlayerGraveEntry> entries = GraveManager.getWorldGraveData((LevelAccessor)event.getPlayer().f_19853_).getGraveEntriesForPlayer(event.getPlayer().m_142081_());
        if (entries == null || entries.isEmpty()) {
            return;
        }
        PlayerGraveEntry latestEntry = entries.getFirst();
        CompoundTag nbt = graveFinder.m_41784_();
        nbt.m_128365_("Pos", (Tag)NbtUtils.m_129224_((BlockPos)latestEntry.gravePos));
        nbt.m_128362_("GraveUUID", latestEntry.graveUUID);
        event.getPlayer().m_36356_(graveFinder);
    }

    @SubscribeEvent
    public static void addDroppedItems(EntityJoinWorldEvent event) {
        if (GraveManager.droppedItems != null && event.getEntity() instanceof ItemEntity) {
            GraveManager.droppedItems.add(((ItemEntity)event.getEntity()).m_32055_());
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void registerCommand(RegisterCommandsEvent event) {
        RestoreGraveCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }
}

