/*
 * Decompiled with CFR 0.152.
 */
package dev.quarris.enigmaticgraves.grave.data;

import dev.quarris.enigmaticgraves.grave.data.IGraveData;
import dev.quarris.enigmaticgraves.utils.ModRef;
import dev.quarris.enigmaticgraves.utils.PlayerInventoryExtensions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public class PlayerInventoryGraveData
implements IGraveData {
    public static final ResourceLocation NAME = ModRef.res("player_inventory");
    private ListTag data;
    private List<ItemStack> remainingItems = new ArrayList<ItemStack>();

    public PlayerInventoryGraveData(Inventory inventory, Collection<ItemStack> drops) {
        ItemStack stack;
        int slot;
        Inventory graveInv = new Inventory(inventory.f_35978_);
        graveInv.m_36006_(inventory);
        block0: for (slot = 0; slot < graveInv.m_6643_(); ++slot) {
            stack = graveInv.m_8020_(slot);
            Iterator<ItemStack> ite = drops.iterator();
            while (ite.hasNext()) {
                ItemStack drop = ite.next();
                if (!ItemStack.m_41728_((ItemStack)stack, (ItemStack)drop)) continue;
                ite.remove();
                continue block0;
            }
            graveInv.m_8016_(slot);
        }
        for (slot = 0; slot < graveInv.f_35975_.size(); ++slot) {
            stack = (ItemStack)graveInv.f_35975_.get(slot);
            if (!EnchantmentHelper.m_44920_((ItemStack)stack)) continue;
            if (!PlayerInventoryExtensions.addItemToPlayerInventory(graveInv, -1, stack)) {
                this.remainingItems.add(stack);
            }
            graveInv.f_35975_.set(slot, (Object)ItemStack.f_41583_);
        }
        this.data = graveInv.m_36026_(new ListTag());
    }

    public PlayerInventoryGraveData(CompoundTag nbt) {
        this.deserializeNBT(nbt);
    }

    public void addRemaining(Collection<ItemStack> remaining) {
        this.remainingItems.addAll(remaining);
    }

    @Override
    public void restore(Player player) {
        Inventory highPriority = new Inventory(player);
        highPriority.m_36035_(this.data);
        Inventory lowPriority = new Inventory(player);
        lowPriority.m_36006_(player.m_150109_());
        player.m_150109_().m_36006_(highPriority);
        for (int slot = 0; slot < lowPriority.m_6643_(); ++slot) {
            ItemStack item = lowPriority.m_8020_(slot);
            if (item.m_41619_()) continue;
            PlayerInventoryExtensions.tryAddItemToPlayerInvElseDrop(player, slot, item);
        }
        for (ItemStack remainingStack : this.remainingItems) {
            if (player.m_150109_().m_36054_(remainingStack)) continue;
            player.m_19983_(remainingStack);
        }
    }

    @Override
    public CompoundTag write(CompoundTag nbt) {
        nbt.m_128365_("Data", (Tag)this.data);
        if (this.remainingItems != null) {
            nbt.m_128405_("RemainingSize", this.remainingItems.size());
            NonNullList items = NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])this.remainingItems.toArray(new ItemStack[this.remainingItems.size()]));
            nbt.m_128365_("Remaining", (Tag)ContainerHelper.m_18973_((CompoundTag)new CompoundTag(), (NonNullList)items));
        }
        return nbt;
    }

    @Override
    public void read(CompoundTag nbt) {
        this.data = nbt.m_128437_("Data", 10);
        if (nbt.m_128441_("Remaining")) {
            int size = nbt.m_128451_("RemainingSize");
            NonNullList items = NonNullList.m_122780_((int)size, (Object)ItemStack.f_41583_);
            ContainerHelper.m_18980_((CompoundTag)nbt.m_128469_("Remaining"), (NonNullList)items);
            this.remainingItems.addAll((Collection<ItemStack>)items);
        }
    }

    @Override
    public ResourceLocation getName() {
        return NAME;
    }
}

