/*
 * Decompiled with CFR 0.152.
 */
package dev.quarris.enigmaticgraves.grave.data;

import dev.quarris.enigmaticgraves.grave.data.IGraveData;
import dev.quarris.enigmaticgraves.utils.ModRef;
import dev.quarris.enigmaticgraves.utils.PlayerInventoryExtensions;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

public class CurioGraveData
implements IGraveData {
    public static final ResourceLocation NAME = ModRef.res("curios");
    public final Map<String, NonNullList<ItemStack>> curioStacks = new HashMap<String, NonNullList<ItemStack>>();
    public final Map<String, NonNullList<ItemStack>> curioCosmeticStacks = new HashMap<String, NonNullList<ItemStack>>();

    public CurioGraveData(ICuriosItemHandler curios, Collection<ItemStack> drops) {
        for (Map.Entry entry : curios.getCurios().entrySet()) {
            String id = (String)entry.getKey();
            ICurioStacksHandler curioItems = (ICurioStacksHandler)entry.getValue();
            NonNullList curioStacksList = NonNullList.m_122780_((int)curioItems.getSlots(), (Object)ItemStack.f_41583_);
            NonNullList curioCosmeticStacksList = NonNullList.m_122780_((int)curioItems.getSlots(), (Object)ItemStack.f_41583_);
            Iterator<ItemStack> ite = drops.iterator();
            HashSet<Integer> stackSlotsChecked = new HashSet<Integer>();
            HashSet<Integer> cosmeticStacksSlotsChecked = new HashSet<Integer>();
            block1: while (ite.hasNext()) {
                ItemStack stack;
                int slot;
                ItemStack drop = ite.next();
                for (slot = 0; slot < curioItems.getSlots(); ++slot) {
                    if (stackSlotsChecked.contains(slot) || !ItemStack.m_41746_((ItemStack)(stack = curioItems.getStacks().getStackInSlot(slot)), (ItemStack)drop)) continue;
                    stackSlotsChecked.add(slot);
                    curioStacksList.set(slot, (Object)drop);
                    ite.remove();
                    continue block1;
                }
                for (slot = 0; slot < curioItems.getSlots(); ++slot) {
                    if (cosmeticStacksSlotsChecked.contains(slot) || !ItemStack.m_41746_((ItemStack)(stack = curioItems.getCosmeticStacks().getStackInSlot(slot)), (ItemStack)drop)) continue;
                    cosmeticStacksSlotsChecked.add(slot);
                    curioCosmeticStacksList.set(slot, (Object)drop);
                    ite.remove();
                    continue block1;
                }
            }
            this.curioStacks.put(id, (NonNullList<ItemStack>)curioStacksList);
            this.curioCosmeticStacks.put(id, (NonNullList<ItemStack>)curioCosmeticStacksList);
        }
    }

    public CurioGraveData(CompoundTag nbt) {
        this.deserializeNBT(nbt);
    }

    @Override
    public void restore(Player player) {
        LazyOptional optional = CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player);
        optional.ifPresent(handler -> {
            ItemStack old;
            int slot;
            NonNullList<ItemStack> graveItems;
            ICurioStacksHandler stacks;
            Map curios = handler.getCurios();
            for (Map.Entry<String, NonNullList<ItemStack>> entry : this.curioStacks.entrySet()) {
                stacks = (ICurioStacksHandler)curios.get(entry.getKey());
                graveItems = entry.getValue();
                for (slot = 0; slot < graveItems.size(); ++slot) {
                    if (((ItemStack)graveItems.get(slot)).m_41619_()) continue;
                    if (slot >= stacks.getSlots()) {
                        PlayerInventoryExtensions.tryAddItemToPlayerInvElseDrop(player, slot, (ItemStack)graveItems.get(slot));
                        return;
                    }
                    old = stacks.getStacks().getStackInSlot(slot);
                    stacks.getStacks().setStackInSlot(slot, (ItemStack)graveItems.get(slot));
                    if (old.m_41619_()) continue;
                    PlayerInventoryExtensions.tryAddItemToPlayerInvElseDrop(player, slot, old);
                }
            }
            for (Map.Entry<String, NonNullList<ItemStack>> entry : this.curioCosmeticStacks.entrySet()) {
                stacks = (ICurioStacksHandler)curios.get(entry.getKey());
                graveItems = entry.getValue();
                for (slot = 0; slot < graveItems.size(); ++slot) {
                    if (((ItemStack)graveItems.get(slot)).m_41619_()) continue;
                    if (slot >= stacks.getSlots()) {
                        PlayerInventoryExtensions.tryAddItemToPlayerInvElseDrop(player, slot, (ItemStack)graveItems.get(slot));
                        return;
                    }
                    old = stacks.getCosmeticStacks().getStackInSlot(slot);
                    stacks.getCosmeticStacks().setStackInSlot(slot, (ItemStack)graveItems.get(slot));
                    if (old.m_41619_()) continue;
                    PlayerInventoryExtensions.tryAddItemToPlayerInvElseDrop(player, slot, old);
                }
            }
        });
    }

    @Override
    public ResourceLocation getName() {
        return NAME;
    }

    @Override
    public CompoundTag write(CompoundTag nbt) {
        ListTag stacksNBT = new ListTag();
        for (Map.Entry<String, NonNullList<ItemStack>> entry : this.curioStacks.entrySet()) {
            CompoundTag entryNBT = new CompoundTag();
            entryNBT.m_128359_("ID", entry.getKey());
            entryNBT.m_128405_("Size", entry.getValue().size());
            entryNBT.m_128365_("Stacks", (Tag)ContainerHelper.m_18973_((CompoundTag)new CompoundTag(), entry.getValue()));
            stacksNBT.add((Object)entryNBT);
        }
        nbt.m_128365_("Stacks", (Tag)stacksNBT);
        ListTag cosmeticStacksNBT = new ListTag();
        for (Map.Entry<String, NonNullList<ItemStack>> entry : this.curioCosmeticStacks.entrySet()) {
            CompoundTag entryNBT = new CompoundTag();
            entryNBT.m_128359_("ID", entry.getKey());
            entryNBT.m_128405_("Size", entry.getValue().size());
            entryNBT.m_128365_("Stacks", (Tag)ContainerHelper.m_18973_((CompoundTag)new CompoundTag(), entry.getValue()));
            cosmeticStacksNBT.add((Object)entryNBT);
        }
        nbt.m_128365_("CosmeticStacks", (Tag)cosmeticStacksNBT);
        return nbt;
    }

    @Override
    public void read(CompoundTag nbt) {
        ListTag stacksNBT = nbt.m_128437_("Stacks", 10);
        for (Tag inbt : stacksNBT) {
            CompoundTag entryNBT = (CompoundTag)inbt;
            String id = entryNBT.m_128461_("ID");
            NonNullList stacks = NonNullList.m_122780_((int)entryNBT.m_128451_("Size"), (Object)ItemStack.f_41583_);
            ContainerHelper.m_18980_((CompoundTag)entryNBT.m_128469_("Stacks"), (NonNullList)stacks);
            this.curioStacks.put(id, (NonNullList<ItemStack>)stacks);
        }
        ListTag cosmeticStacksNBT = nbt.m_128437_("CosmeticStacks", 10);
        for (Tag inbt : cosmeticStacksNBT) {
            CompoundTag entryNBT = (CompoundTag)inbt;
            String id = entryNBT.m_128461_("ID");
            NonNullList stacks = NonNullList.m_122780_((int)entryNBT.m_128451_("Size"), (Object)ItemStack.f_41583_);
            ContainerHelper.m_18980_((CompoundTag)entryNBT.m_128469_("Stacks"), (NonNullList)stacks);
            this.curioCosmeticStacks.put(id, (NonNullList<ItemStack>)stacks);
        }
    }
}

