/*
 * Decompiled with CFR 0.152.
 */
package dev.quarris.enigmaticgraves.grave;

import dev.quarris.enigmaticgraves.compat.CompatManager;
import dev.quarris.enigmaticgraves.compat.CosmeticArmorReworkedCompat;
import dev.quarris.enigmaticgraves.compat.CurioCompat;
import dev.quarris.enigmaticgraves.config.GraveConfigs;
import dev.quarris.enigmaticgraves.content.GraveEntity;
import dev.quarris.enigmaticgraves.grave.PlayerGraveEntry;
import dev.quarris.enigmaticgraves.grave.WorldGraveData;
import dev.quarris.enigmaticgraves.grave.data.CosmeticArmorReworkedGraveData;
import dev.quarris.enigmaticgraves.grave.data.CurioGraveData;
import dev.quarris.enigmaticgraves.grave.data.ExperienceGraveData;
import dev.quarris.enigmaticgraves.grave.data.IGraveData;
import dev.quarris.enigmaticgraves.grave.data.PlayerInventoryGraveData;
import dev.quarris.enigmaticgraves.utils.ModRef;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class GraveManager {
    public static final HashMap<ResourceLocation, Function<CompoundTag, IGraveData>> GRAVE_DATA_SUPPLIERS = new HashMap();
    public static PlayerGraveEntry latestGraveEntry;
    public static List<ItemStack> droppedItems;
    public static final DateFormat TIMESTAMP_FORMAT;

    public static void init() {
        GRAVE_DATA_SUPPLIERS.put(PlayerInventoryGraveData.NAME, PlayerInventoryGraveData::new);
        GRAVE_DATA_SUPPLIERS.put(ExperienceGraveData.NAME, ExperienceGraveData::new);
        if (CompatManager.isCuriosLoaded()) {
            GRAVE_DATA_SUPPLIERS.put(CurioGraveData.NAME, CurioGraveData::new);
        }
        if (CompatManager.isCosmeticArmorReworkedLoaded()) {
            GRAVE_DATA_SUPPLIERS.put(CosmeticArmorReworkedGraveData.NAME, CosmeticArmorReworkedGraveData::new);
        }
    }

    public static WorldGraveData getWorldGraveData(LevelAccessor world) {
        if (world instanceof ServerLevel) {
            MinecraftServer server = ((ServerLevel)world).m_142572_();
            ServerLevel overworld = server.m_129880_(Level.f_46428_);
            return (WorldGraveData)overworld.m_8895_().m_164861_(WorldGraveData::load, WorldGraveData::new, WorldGraveData.NAME);
        }
        return null;
    }

    public static boolean shouldSpawnGrave(Player player) {
        return !player.f_19853_.m_46469_().m_46207_(GameRules.f_46133_) && !player.m_5833_();
    }

    public static void prepPlayerGrave(Player player) {
        PlayerGraveEntry entry;
        if (!GraveManager.shouldSpawnGrave(player)) {
            ModRef.LOGGER.info("Cannot spawn grave. Player is spectator is the KEEP_INVENTORY gamerule is enabled");
            return;
        }
        ModRef.LOGGER.info("Preparing grave for " + player.m_7755_().getString());
        latestGraveEntry = entry = new PlayerGraveEntry(player.m_150109_());
    }

    public static void populatePlayerGrave(Player player, Collection<ItemStack> drops) {
        if (latestGraveEntry == null) {
            return;
        }
        ModRef.LOGGER.debug("Populating grave for " + player.m_7755_().getString());
        GraveManager.generateGraveDataList(player, latestGraveEntry, drops);
    }

    public static void spawnPlayerGrave(Player player) {
        if (latestGraveEntry == null) {
            return;
        }
        WorldGraveData worldData = GraveManager.getWorldGraveData((LevelAccessor)player.f_19853_);
        GraveEntity grave = GraveEntity.createGrave(player, GraveManager.latestGraveEntry.dataList);
        ModRef.LOGGER.debug("Attempting to spawn grave for " + player.m_7755_().getString() + " at " + grave.m_142538_());
        GraveManager.latestGraveEntry.graveUUID = grave.m_142081_();
        GraveManager.latestGraveEntry.gravePos = grave.m_142538_();
        if (!player.f_19853_.m_7967_((Entity)grave)) {
            ModRef.LOGGER.warn("Could not spawn grave for " + player.m_7755_().getString());
        } else {
            ModRef.LOGGER.info("Spawned grave for " + player.m_7755_().getString() + " at " + grave.m_142538_());
        }
        worldData.addGraveEntry(player, latestGraveEntry);
        ModRef.LOGGER.info("Added grave entry to player " + player.m_7755_().getString());
        latestGraveEntry = null;
        droppedItems = null;
    }

    public static void generateGraveDataList(Player player, PlayerGraveEntry entry, Collection<ItemStack> drops) {
        IGraveData cosmeticArmorReworkedsData;
        IGraveData curiosData;
        ArrayList<IGraveData> dataList = new ArrayList<IGraveData>();
        PlayerInventoryGraveData playerInvData = new PlayerInventoryGraveData(entry.inventory, drops);
        dataList.add(playerInvData);
        GraveConfigs.Common.ExperienceHandling xpHandling = (GraveConfigs.Common.ExperienceHandling)((Object)GraveConfigs.COMMON.experienceGraveHandling.get());
        if (xpHandling != GraveConfigs.Common.ExperienceHandling.DROP) {
            int xp = 0;
            if (xpHandling == GraveConfigs.Common.ExperienceHandling.KEEP_VANILLA) {
                xp = player.m_6552_(player);
                xp = ForgeEventFactory.getExperienceDrop((LivingEntity)player, (Player)player, (int)xp);
            } else if (xpHandling == GraveConfigs.Common.ExperienceHandling.KEEP_ALL) {
                xp = (int)((float)xp + player.f_36080_ * (float)player.m_36323_());
                while (player.f_36078_ > 0) {
                    --player.f_36078_;
                    xp += player.m_36323_();
                }
            }
            ExperienceGraveData xpData = new ExperienceGraveData(xp);
            dataList.add(xpData);
        }
        if (CompatManager.isCuriosLoaded() && (curiosData = CurioCompat.generateCurioGraveData(player, drops)) != null) {
            dataList.add(curiosData);
        }
        if (CompatManager.isCosmeticArmorReworkedLoaded() && (cosmeticArmorReworkedsData = CosmeticArmorReworkedCompat.generateCosmeticArmorReworkedGraveData(player, drops)) != null) {
            dataList.add(cosmeticArmorReworkedsData);
        }
        playerInvData.addRemaining(drops);
        playerInvData.addRemaining(droppedItems);
        entry.dataList = dataList;
    }

    public static void setGraveRestored(UUID player, GraveEntity grave) {
        LinkedList<PlayerGraveEntry> entries = GraveManager.getWorldGraveData((LevelAccessor)grave.f_19853_).getGraveEntriesForPlayer(player);
        if (entries != null) {
            entries.stream().filter(entry -> entry.graveUUID.equals(grave.m_142081_())).findFirst().ifPresent(PlayerGraveEntry::setRestored);
        }
    }

    public static boolean getSpawnPosition(Level world, Vec3 deathPos, BlockPos.MutableBlockPos outPos) {
        GraveConfigs.Common configs = GraveConfigs.COMMON;
        BlockPos.MutableBlockPos pos = new BlockPos(deathPos.f_82479_, (double)Math.round(deathPos.f_82480_), deathPos.f_82481_).m_122032_();
        while (pos.m_123342_() > world.m_141937_()) {
            BlockPos belowPos = new BlockPos((Vec3i)pos).m_7495_();
            BlockState belowState = world.m_8055_(belowPos);
            if (GraveManager.blocksMovement(belowState)) {
                outPos.m_122190_((Vec3i)pos);
                return false;
            }
            pos = pos.m_122173_(Direction.DOWN);
        }
        pos = new BlockPos(deathPos.f_82479_, (double)((Integer)configs.scanHeight.get()).intValue(), deathPos.f_82481_);
        for (int scan = 0; scan < (Integer)configs.scanRange.get(); ++scan) {
            BlockPos scanPos = new BlockPos((Vec3i)pos).m_6630_(scan);
            if (!GraveManager.blocksMovement(world.m_8055_(scanPos.m_7494_())) && !GraveManager.blocksMovement(world.m_8055_(scanPos)) && GraveManager.blocksMovement(world.m_8055_(scanPos.m_7495_()))) {
                outPos.m_122190_((Vec3i)scanPos);
                return false;
            }
            if (scan <= 0 || GraveManager.blocksMovement(world.m_8055_((scanPos = new BlockPos((Vec3i)pos).m_6625_(scan)).m_7494_())) || GraveManager.blocksMovement(world.m_8055_(scanPos)) || !GraveManager.blocksMovement(world.m_8055_(scanPos.m_7495_()))) continue;
            outPos.m_122190_((Vec3i)scanPos);
            return false;
        }
        if (!GraveManager.blocksMovement(world.m_8055_((BlockPos)pos)) && !GraveManager.blocksMovement(world.m_8055_(pos.m_7494_()))) {
            outPos.m_122190_((Vec3i)pos);
            return true;
        }
        outPos.m_122169_(deathPos.f_82479_, (double)(world.m_141937_() + 1), deathPos.f_82481_);
        return !world.m_8055_(new BlockPos(deathPos.f_82479_, 0.0, deathPos.f_82481_)).m_60767_().m_76334_();
    }

    private static boolean blocksMovement(BlockState state) {
        return state.m_60767_().m_76334_();
    }

    static {
        TIMESTAMP_FORMAT = new SimpleDateFormat("yyyyMMdd_HHmmss");
    }
}

