/*
 * Decompiled with CFR 0.152.
 */
package dev.quarris.enigmaticgraves.content;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import dev.quarris.enigmaticgraves.content.GraveEntity;
import dev.quarris.enigmaticgraves.content.GraveModel;
import dev.quarris.enigmaticgraves.utils.ModRef;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GraveEntityRenderer
extends EntityRenderer<GraveEntity> {
    private final GraveModel model;
    public static final ModelLayerLocation MODEL_RES = new ModelLayerLocation(ModRef.res("grave"), "main");
    private static final ResourceLocation TEX = ModRef.res("textures/grave.png");

    public GraveEntityRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
        this.model = new GraveModel(ctx.m_174023_(MODEL_RES));
    }

    public void render(GraveEntity entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        matrixStackIn.m_85836_();
        matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(-entityYaw + 180.0f));
        super.m_7392_((Entity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        this.model.m_7695_(matrixStackIn, bufferIn.m_6299_(this.getRenderType(entityIn)), packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStackIn.m_85849_();
    }

    private RenderType getRenderType(GraveEntity entity) {
        return this.model.m_103119_(this.getTextureLocation(entity));
    }

    public ResourceLocation getTextureLocation(GraveEntity entity) {
        return TEX;
    }
}

