/*
 * Decompiled with CFR 0.152.
 */
package dev.quarris.enigmaticgraves.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import dev.quarris.enigmaticgraves.command.GraveEntryType;
import dev.quarris.enigmaticgraves.grave.GraveManager;
import dev.quarris.enigmaticgraves.grave.PlayerGraveEntry;
import dev.quarris.enigmaticgraves.grave.data.IGraveData;
import java.util.LinkedList;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;

public class RestoreGraveCommand {
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_ENTRIES = (ctx, builder) -> {
        try {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
            LinkedList<PlayerGraveEntry> entries = GraveManager.getWorldGraveData((LevelAccessor)player.f_19853_).getGraveEntriesForPlayer(player.m_142081_());
            if (entries == null) {
                return Suggestions.empty();
            }
            for (int i = 0; i < entries.size(); ++i) {
                PlayerGraveEntry entry = entries.get(i);
                builder.suggest(entry.getEntryName(i));
            }
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        return builder.buildFuture();
    };
    private static final Component GRAVE_ALREADY_RESTORED = new TextComponent("Warning: That grave has already been restored. Add 'true' at the end of the last command to restore again.");
    private static final Component SUCCESSFULLY_RESTORED = new TextComponent("Successfully restored the grave.");
    private static final Component HELP = new TextComponent(ChatFormatting.RED + "Usage:\n/enigmatic_graves <player> list\n/enigmatic_graves <player> clear\n/enigmatic_graves <player> restore [death_<id> [forced]]");

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralCommandNode cmd = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"enigmatic_graves").requires(source -> source.m_6761_(2))).executes(ctx -> {
            ((CommandSourceStack)ctx.getSource()).m_81354_(HELP, false);
            return 0;
        })).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82127_((String)"list").executes(ctx -> {
            ServerPlayer player = EntityArgument.m_91474_((CommandContext)ctx, (String)"target");
            LinkedList<PlayerGraveEntry> entries = GraveManager.getWorldGraveData((LevelAccessor)((CommandSourceStack)ctx.getSource()).m_81372_()).getGraveEntriesForPlayer(player.m_142081_());
            if (entries == null) {
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TextComponent("The player has no deaths."), false);
                return 0;
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < entries.size(); ++i) {
                sb.append(((PlayerGraveEntry)entries.get(i)).getEntryName(i));
                if (i >= entries.size() - 1) continue;
                sb.append('\n');
            }
            ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TextComponent(sb.toString()), false);
            return 0;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"restore").executes(ctx -> RestoreGraveCommand.restoreGrave((CommandContext<CommandSourceStack>)ctx, false, false))).then(Commands.m_82129_((String)"forced", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> RestoreGraveCommand.restoreGrave((CommandContext<CommandSourceStack>)ctx, false, BoolArgumentType.getBool((CommandContext)ctx, (String)"forced"))))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"entry", (ArgumentType)new GraveEntryType()).suggests(SUGGEST_ENTRIES).executes(ctx -> RestoreGraveCommand.restoreGrave((CommandContext<CommandSourceStack>)ctx, true, false))).then(Commands.m_82129_((String)"forced", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> RestoreGraveCommand.restoreGrave((CommandContext<CommandSourceStack>)ctx, true, BoolArgumentType.getBool((CommandContext)ctx, (String)"forced"))))))).then(Commands.m_82127_((String)"clear").executes(ctx -> {
            ServerPlayer player = EntityArgument.m_91474_((CommandContext)ctx, (String)"target");
            int count = GraveManager.getWorldGraveData((LevelAccessor)player.f_19853_).getGraveEntriesForPlayer(player.m_142081_()).size();
            GraveManager.getWorldGraveData((LevelAccessor)player.f_19853_).clearGraveEntries((Player)player);
            ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TextComponent("Cleared " + count + " entries."), true);
            return 0;
        }))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"graves").requires(source -> source.m_6761_(2))).executes(ctx -> {
            ((CommandSourceStack)ctx.getSource()).m_81354_(HELP, false);
            return 0;
        })).redirect((CommandNode)cmd));
    }

    private static int restoreGrave(CommandContext<CommandSourceStack> ctx, boolean useArg, boolean forced) throws CommandSyntaxException {
        ServerPlayer player;
        PlayerGraveEntry entry = useArg ? GraveEntryType.getEntry(player.m_142081_(), ctx, "entry") : GraveManager.getWorldGraveData((LevelAccessor)((CommandSourceStack)ctx.getSource()).m_81372_()).getGraveEntriesForPlayer(player.m_142081_()).getFirst();
        if (!RestoreGraveCommand.tryRestoreGrave(entry, (Player)(player = EntityArgument.m_91474_(ctx, (String)"target")), forced)) {
            ((CommandSourceStack)ctx.getSource()).m_81354_(GRAVE_ALREADY_RESTORED, true);
            return 1;
        }
        ((CommandSourceStack)ctx.getSource()).m_81354_(SUCCESSFULLY_RESTORED, true);
        return 0;
    }

    private static boolean tryRestoreGrave(PlayerGraveEntry graveEntry, Player player, boolean forced) {
        if (!forced && graveEntry.isRestored()) {
            return false;
        }
        for (IGraveData graveData : graveEntry.dataList) {
            graveData.restore(player);
        }
        if (!graveEntry.isRestored()) {
            GraveManager.getWorldGraveData((LevelAccessor)player.f_19853_).setGraveRestored(graveEntry.graveUUID);
        }
        return true;
    }
}

