/*
 * Decompiled with CFR 0.152.
 */
package dev.quarris.enigmaticgraves.command;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.quarris.enigmaticgraves.grave.GraveManager;
import dev.quarris.enigmaticgraves.grave.PlayerGraveEntry;
import java.util.LinkedList;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.multiplayer.ClientSuggestionProvider;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.LevelAccessor;

public class GraveEntryType
implements ArgumentType<Integer> {
    private static final Pattern PATTERN = Pattern.compile("death_(\\d){1,3}.*");

    public static PlayerGraveEntry getEntry(UUID playerUUID, CommandContext<CommandSourceStack> context, String name) {
        int deathId = (Integer)context.getArgument(name, Integer.class);
        return GraveManager.getWorldGraveData((LevelAccessor)((CommandSourceStack)context.getSource()).m_81372_()).getGraveEntriesForPlayer(playerUUID).get(deathId);
    }

    public Integer parse(StringReader reader) throws CommandSyntaxException {
        String input = reader.readString();
        Matcher matcher = PATTERN.matcher(input);
        if (!matcher.matches() || matcher.groupCount() <= 0) {
            TextComponent msg = new TextComponent("Input does not match pattern 'death_<id>...'");
            throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)msg), (Message)msg);
        }
        try {
            return Integer.parseInt(matcher.group(1));
        }
        catch (NumberFormatException e) {
            TextComponent msg = new TextComponent("Invalid death id");
            throw new CommandSyntaxException((CommandExceptionType)CommandSyntaxException.BUILT_IN_EXCEPTIONS.readerInvalidInt(), (Message)msg, input, matcher.start(1));
        }
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        if (context.getSource() instanceof ClientSuggestionProvider) {
            try {
                return SuggestionProviders.f_121641_.getSuggestions(context, builder);
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }
        if (context.getSource() instanceof CommandSourceStack) {
            try {
                ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
                LinkedList<PlayerGraveEntry> entries = GraveManager.getWorldGraveData((LevelAccessor)player.f_19853_).getGraveEntriesForPlayer(player.m_142081_());
                if (entries == null) {
                    return Suggestions.empty();
                }
                for (int i = 0; i < entries.size(); ++i) {
                    PlayerGraveEntry entry = entries.get(i);
                    builder.suggest(entry.getEntryName(i));
                }
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
            return builder.buildFuture();
        }
        return Suggestions.empty();
    }
}

