/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.ui.widget;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.latvian.kubejs.ui.KubeJSUIOptions;
import dev.latvian.kubejs.ui.widget.Button;
import dev.latvian.kubejs.ui.widget.Image;
import dev.latvian.kubejs.ui.widget.ImageButton;
import dev.latvian.kubejs.ui.widget.Label;
import dev.latvian.kubejs.ui.widget.Panorama;
import dev.latvian.kubejs.ui.widget.Shader;
import dev.latvian.kubejs.ui.widget.Widget;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class Panel
extends Widget {
    public final List<Widget> children = new ArrayList<Widget>();

    @Override
    public void collectWidgets(List<Widget> list) {
        super.collectWidgets(list);
        for (Widget w : this.children) {
            w.collectWidgets(list);
        }
    }

    public <W extends Widget> void widget(Supplier<W> s, Consumer<W> c) {
        Widget w = (Widget)((Object)s.get());
        w.parent = this;
        this.children.add(w);
        c.accept((W)((Object)w));
    }

    public void panel(Consumer<Panel> c) {
        this.widget(Panel::new, c);
    }

    public void button(Consumer<Button> c) {
        this.widget(Button::new, c);
    }

    public void imageButton(Consumer<ImageButton> c) {
        this.widget(ImageButton::new, c);
    }

    public void label(Consumer<Label> c) {
        this.widget(Label::new, c);
    }

    public void image(Consumer<Image> c) {
        this.widget(Image::new, c);
    }

    public void background(ResourceLocation texture) {
        this.image(image -> {
            image.setTexture(texture);
            image.setX(0);
            image.setY(0);
            image.setW(this.getW());
            image.setH(this.getH());
        });
    }

    public void tilingBackground(ResourceLocation texture, int size) {
        this.image(image -> {
            image.setTexture(texture);
            image.setTileSize(size);
            image.setX(0);
            image.setY(0);
            image.setW(this.getW());
            image.setH(this.getH());
        });
    }

    public void fillBackground(ResourceLocation texture, int tw, int th) {
        this.image(image -> {
            image.setTexture(texture);
            double fw = (double)this.getW() / (double)tw;
            double fh = (double)this.getH() / (double)th;
            if (fw > fh) {
                image.setW((int)((double)tw * fw));
                image.setH((int)((double)th * fw));
            } else {
                image.setW((int)((double)tw * fh));
                image.setH((int)((double)th * fh));
            }
            image.setX((this.getW() - image.getW()) / 2);
            image.setY((this.getH() - image.getH()) / 2);
        });
    }

    public void shaderBackground() {
        this.getUi().hasShader = true;
        if (KubeJSUIOptions.getInstance().useShaders) {
            this.widget(Shader::new, shader -> {
                shader.setX(0);
                shader.setY(0);
                shader.setW(this.getW());
                shader.setH(this.getH());
            });
        }
    }

    @Deprecated
    public void shaderBackground(ResourceLocation id) {
        ConsoleJS.CLIENT.warn((Object)"Shader background no longer takes id param! Use just shaderBackground() and make kubejs/assets/minecraft/shaders/core/kubejsui_background.fsh file!");
        this.shaderBackground();
    }

    @Deprecated
    public void shaderBackground(ResourceLocation id, int scale) {
        this.shaderBackground(id);
    }

    public void minecraftLogo(int x, int y) {
        this.image(i -> {
            i.setTexture(new ResourceLocation("minecraft:textures/gui/title/minecraft.png"));
            i.setX(x);
            i.setY(y);
            i.setW(155);
            i.setH(44);
            i.setUv(new int[]{0, 0, 155, 44});
        });
        this.image(i -> {
            i.setTexture(new ResourceLocation("minecraft:textures/gui/title/minecraft.png"));
            i.setX(x + 155);
            i.setY(y);
            i.setW(155);
            i.setH(44);
            i.setUv(new int[]{0, 45, 155, 44});
        });
    }

    public void minecraftLogo(int y) {
        this.minecraftLogo(this.getW() / 2 - 137, y);
    }

    public void panorama(ResourceLocation cubeMap) {
        this.widget(() -> new Panorama(cubeMap), shader -> {
            shader.setX(0);
            shader.setY(0);
            shader.setW(this.getW());
            shader.setH(this.getH());
        });
    }

    public void minecraftPanorama() {
        this.panorama(new ResourceLocation("textures/gui/title/background/panorama"));
    }

    @Override
    public void renderBackground(PoseStack matrixStack, float partialTicks) {
        for (Widget w : this.children) {
            w.renderBackground(matrixStack, partialTicks);
        }
    }

    @Override
    public void renderForeground(PoseStack matrixStack, float partialTicks) {
        for (Widget w : this.children) {
            w.renderForeground(matrixStack, partialTicks);
        }
    }

    @Override
    public boolean mousePressed() {
        for (Widget w : this.children) {
            if (!w.mousePressed()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void mouseReleased() {
        for (Widget w : this.children) {
            w.mouseReleased();
        }
    }

    @Override
    public void appendHoverText(List<Component> list) {
        super.appendHoverText(list);
        for (Widget w : this.children) {
            w.appendHoverText(list);
        }
    }
}

