/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.ui;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.architectury.event.Event;
import dev.architectury.event.EventFactory;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.platform.Platform;
import dev.latvian.kubejs.ui.RegisterActionsEvent;
import dev.latvian.kubejs.ui.RegisterScreensEvent;
import dev.latvian.kubejs.ui.VanillaActions;
import dev.latvian.kubejs.ui.forge.UIDataImpl;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.util.UtilsJS;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.gui.screens.AccessibilityOptionsScreen;
import net.minecraft.client.gui.screens.LanguageSelectScreen;
import net.minecraft.client.gui.screens.OptionsScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.WinScreen;
import net.minecraft.client.gui.screens.worldselection.SelectWorldScreen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import org.jetbrains.annotations.Nullable;

public enum UIData implements ResourceManagerReloadListener
{
    INSTANCE;

    public static final Event<RegisterScreensEvent> REGISTER_SCREENS;
    public static final Event<RegisterActionsEvent> REGISTER_ACTIONS;
    private final Map<Class<?>, String> screenIds = new HashMap();
    private final Map<ResourceLocation, Consumer<Screen>> actions = new HashMap<ResourceLocation, Consumer<Screen>>();

    public void m_6213_(ResourceManager resourceManager) {
        this.screenIds.clear();
        this.actions.clear();
        this.screenIds.put(TitleScreen.class, "main_menu");
        this.screenIds.put(LanguageSelectScreen.class, "language");
        this.screenIds.put(OptionsScreen.class, "options");
        this.screenIds.put(AccessibilityOptionsScreen.class, "accessibility");
        this.screenIds.put(SelectWorldScreen.class, "select_world");
        this.screenIds.put(WinScreen.class, "credits");
        this.actions.put(new ResourceLocation("minecraft:singleplayer"), VanillaActions.SINGLEPLAYER);
        this.actions.put(new ResourceLocation("minecraft:multiplayer"), VanillaActions.MULTIPLAYER);
        this.actions.put(new ResourceLocation("minecraft:language"), VanillaActions.LANGUAGE);
        this.actions.put(new ResourceLocation("minecraft:options"), VanillaActions.OPTIONS);
        this.actions.put(new ResourceLocation("minecraft:quit"), VanillaActions.QUIT);
        this.actions.put(new ResourceLocation("minecraft:accessibility"), VanillaActions.ACCESSIBILITY);
        this.actions.put(new ResourceLocation("kubejsui:toggle_shaders"), VanillaActions.KUBEJSUI_TOGGLE_SHADERS);
        ((RegisterScreensEvent)REGISTER_SCREENS.invoker()).registerScreens(this.screenIds::put);
        ((RegisterActionsEvent)REGISTER_ACTIONS.invoker()).registerActions(this.actions::put);
        UIData.registerPlatformScreensAndActions(this.screenIds, this.actions);
        Gson gson = new GsonBuilder().create();
        for (String namespace : resourceManager.m_7187_()) {
            try {
                for (Resource resource : resourceManager.m_7396_(new ResourceLocation(namespace, "kubejsui.json"))) {
                    InputStream stream = resource.m_6679_();
                    try {
                        JsonObject json = (JsonObject)gson.fromJson((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), JsonObject.class);
                        if (json.has("actions")) {
                            for (Map.Entry entry : json.get("actions").getAsJsonObject().entrySet()) {
                                String s = ((JsonElement)entry.getValue()).getAsString();
                                try {
                                    int i = s.lastIndexOf(46);
                                    Class<?> clazz = Class.forName(s.substring(0, i));
                                    Field field = clazz.getDeclaredField(s.substring(i + 1));
                                    field.setAccessible(true);
                                    Consumer consumer = Objects.requireNonNull((Consumer)field.get(null));
                                    this.actions.put(new ResourceLocation(namespace, (String)entry.getKey()), consumer);
                                }
                                catch (Throwable ex) {
                                    KubeJS.LOGGER.error("UI: Failed to load action " + (String)entry.getKey() + ":" + entry.getValue() + ": " + ex);
                                }
                            }
                        }
                        if (!json.has("screens")) continue;
                        for (Map.Entry entry : json.get("screens").getAsJsonObject().entrySet()) {
                            if (Platform.isFabric()) {
                                UIData.addMappedScreen(this.screenIds, entry);
                            }
                            try {
                                this.screenIds.put(Class.forName((String)entry.getKey()), ((JsonElement)entry.getValue()).getAsString());
                            }
                            catch (Throwable throwable) {}
                        }
                    }
                    finally {
                        if (stream == null) continue;
                        stream.close();
                    }
                }
            }
            catch (Exception exception) {
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static void addMappedScreen(Map<Class<?>, String> screenIds, Map.Entry<String, JsonElement> entry) {
        void var1_1;
        UIDataImpl.addMappedScreen(screenIds, (Map.Entry<String, JsonElement>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static void registerPlatformScreensAndActions(Map<Class<?>, String> screenIds, Map<ResourceLocation, Consumer<Screen>> actions) {
        void var1_1;
        UIDataImpl.registerPlatformScreensAndActions(screenIds, (Map<ResourceLocation, Consumer<Screen>>)var1_1);
    }

    @Nullable
    public Consumer<Screen> getAction(String id) {
        return this.actions.get(UtilsJS.getMCID((Object)id));
    }

    public String getScreenId(Class<?> c) {
        return this.screenIds.getOrDefault(c, "");
    }

    @Deprecated
    public static UIData get() {
        return INSTANCE;
    }

    static {
        REGISTER_SCREENS = EventFactory.createLoop((Object[])new RegisterScreensEvent[0]);
        REGISTER_ACTIONS = EventFactory.createLoop((Object[])new RegisterActionsEvent[0]);
    }
}

