/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.ui;

import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.event.events.client.ClientReloadShadersEvent;
import dev.architectury.platform.Platform;
import dev.architectury.registry.ReloadListenerRegistry;
import dev.latvian.kubejs.ui.KubeJSUIEventHandler;
import dev.latvian.kubejs.ui.ScreenKubeJSUI;
import dev.latvian.kubejs.ui.UIData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceProvider;

public class KubeJSUIClient {
    static ThreadLocal<Boolean> withinInitPreHacks = ThreadLocal.withInitial(() -> false);
    private static ShaderInstance backgroundShaderInstance;
    private static ShaderInstance positionColorTexShaderInstance;
    public static Uniform RESOLUTION_UNIFORM;
    public static Uniform TIME_UNIFORM;
    public static Uniform TICK_UNIFORM;
    public static Uniform MOUSE_UNIFORM;
    public static Uniform GUI_SCALE_UNIFORM;

    public static ShaderInstance getBackgroundShader() {
        return backgroundShaderInstance;
    }

    public static ShaderInstance getPositionColorTexShader() {
        return positionColorTexShaderInstance;
    }

    public static void init() {
        ClientGuiEvent.SET_SCREEN.register(KubeJSUIEventHandler::openGui);
        if (!Platform.isForge()) {
            ClientGuiEvent.INIT_PRE.register((screen, access) -> {
                if (withinInitPreHacks.get().booleanValue()) {
                    return EventResult.pass();
                }
                if (Minecraft.m_91087_().f_91080_ != screen) {
                    return EventResult.pass();
                }
                if (screen instanceof ScreenKubeJSUI) {
                    return EventResult.pass();
                }
                String screenId = UIData.INSTANCE.getScreenId(screen.getClass());
                if (!screenId.isEmpty()) {
                    withinInitPreHacks.set(true);
                    try {
                        Minecraft.m_91087_().m_91152_(screen);
                    }
                    finally {
                        withinInitPreHacks.set(false);
                    }
                    return EventResult.interruptTrue();
                }
                return EventResult.pass();
            });
        }
        ReloadListenerRegistry.register((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)UIData.INSTANCE);
        ClientReloadShadersEvent.EVENT.register(KubeJSUIClient::reloadShaders);
    }

    private static void reloadShaders(ResourceManager manager, ClientReloadShadersEvent.ShadersSink sink) {
        try {
            sink.registerShader(new ShaderInstance((ResourceProvider)manager, "kubejsui_background", DefaultVertexFormat.f_85814_), i -> {
                backgroundShaderInstance = i;
                RESOLUTION_UNIFORM = i.m_173348_("resolution");
                TIME_UNIFORM = i.m_173348_("time");
                TICK_UNIFORM = i.m_173348_("tick");
                MOUSE_UNIFORM = i.m_173348_("mouse");
                GUI_SCALE_UNIFORM = i.m_173348_("guiScale");
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            sink.registerShader(new ShaderInstance((ResourceProvider)manager, "kubejsui_position_color_tex", DefaultVertexFormat.f_85818_), i -> {
                positionColorTexShaderInstance = i;
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

