/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.ui;

import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.util.ClientUtils;
import org.jetbrains.annotations.Nullable;

public interface IOpenableScreen
extends Runnable {
    public void openGui();

    default public void openGuiLater() {
        ClientUtils.runLater(this);
    }

    default public void closeGui() {
        this.closeGui(true);
    }

    default public void closeGui(boolean openPrevScreen) {
    }

    default public void openContextMenu(@Nullable Panel panel) {
        if (this instanceof Widget) {
            ((Widget)this).getGui().openContextMenu(panel);
        }
    }

    default public void closeContextMenu() {
        if (this instanceof Widget) {
            ((Widget)this).getGui().closeContextMenu();
        } else {
            this.openContextMenu(null);
        }
    }

    @Override
    default public void run() {
        if (ClientUtils.getCurrentGuiAs(IOpenableScreen.class) != this) {
            this.openGui();
        }
    }

    default public Runnable openAfter(Runnable runnable) {
        return () -> {
            runnable.run();
            this.run();
        };
    }
}

