/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.config.ui;

import dev.architectury.fluid.FluidStack;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.ftb.mods.ftblibrary.config.ConfigCallback;
import dev.ftb.mods.ftblibrary.config.FluidConfig;
import dev.ftb.mods.ftblibrary.config.ui.forge.SelectFluidScreenImpl;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.ui.misc.ButtonListBaseScreen;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class SelectFluidScreen
extends ButtonListBaseScreen {
    private final FluidConfig config;
    private final ConfigCallback callback;

    public SelectFluidScreen(FluidConfig c, ConfigCallback cb) {
        this.setTitle((Component)new TranslatableComponent("ftblibrary.select_fluid.gui"));
        this.setHasSearchBox(true);
        this.config = c;
        this.callback = cb;
    }

    @Override
    public void addButtons(Panel panel) {
        if (this.config.allowEmpty) {
            FluidStack fluidStack = FluidStack.create((Fluid)Fluids.f_76191_, (long)FluidStack.bucketAmount());
            panel.add(new SimpleTextButton(panel, fluidStack.getName(), ItemIcon.getItemIcon(Items.f_42446_)){

                @Override
                public void onClicked(MouseButton button) {
                    this.playClickSound();
                    SelectFluidScreen.this.config.setCurrentValue(Fluids.f_76191_);
                    SelectFluidScreen.this.callback.save(true);
                }

                @Override
                public Object getIngredientUnderMouse() {
                    return FluidStack.create((Fluid)Fluids.f_76191_, (long)FluidStack.bucketAmount());
                }
            });
        }
        for (final Fluid fluid : Registry.f_122822_) {
            if (fluid == Fluids.f_76191_ || fluid.m_76145_().m_76170_()) continue;
            FluidStack fluidStack = FluidStack.create((Fluid)fluid, (long)FluidStack.bucketAmount());
            panel.add(new SimpleTextButton(panel, fluidStack.getName(), Icon.getIcon(SelectFluidScreen.getStillTexture(fluidStack)).withTint(Color4I.rgb(SelectFluidScreen.getColor(fluidStack)))){

                @Override
                public void onClicked(MouseButton button) {
                    this.playClickSound();
                    SelectFluidScreen.this.config.setCurrentValue(fluid);
                    SelectFluidScreen.this.callback.save(true);
                }

                @Override
                public Object getIngredientUnderMouse() {
                    return FluidStack.create((Fluid)fluid, (long)FluidStack.bucketAmount());
                }
            });
        }
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static ResourceLocation getStillTexture(FluidStack stack) {
        return SelectFluidScreenImpl.getStillTexture(stack);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static int getColor(FluidStack stack) {
        return SelectFluidScreenImpl.getColor(stack);
    }

    @Override
    public boolean onClosedByKey(Key key) {
        if (super.onClosedByKey(key)) {
            this.callback.save(false);
            return false;
        }
        return false;
    }
}

