/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.mojang.math.Vector3f;
import com.mojang.serialization.Codec;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import com.telepathicgrunt.repurposedstructures.world.structures.MineshaftStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.configs.RSMineshaftEndConfig;
import com.telepathicgrunt.repurposedstructures.world.structures.pieces.PieceLimitedJigsawManager;
import java.util.Comparator;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;

public class MineshaftEndStructure<C extends RSMineshaftEndConfig>
extends MineshaftStructure<C> {
    public MineshaftEndStructure(Codec<C> codec) {
        super(codec, MineshaftEndStructure::isMineshaftEndFeatureChunk, MineshaftEndStructure::generateMineshaftEndPieces);
    }

    protected static <CC extends RSMineshaftEndConfig> boolean isMineshaftEndFeatureChunk(PieceGeneratorSupplier.Context<CC> context) {
        int zBlockPos;
        boolean superCheck = MineshaftStructure.isMineshaftFeatureChunk(context);
        if (!superCheck) {
            return false;
        }
        RSMineshaftEndConfig config = (RSMineshaftEndConfig)context.f_197356_();
        int radius = config.distanceFromOrigin;
        int xBlockPos = context.f_197355_().m_45604_();
        if (xBlockPos * xBlockPos + (zBlockPos = context.f_197355_().m_45605_()) * zBlockPos <= radius * radius) {
            return false;
        }
        int minThickness = config.minIslandThickness;
        if (minThickness == 0) {
            return true;
        }
        BlockPos.MutableBlockPos islandTopBottomThickness = new BlockPos.MutableBlockPos(Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE);
        int xPos = context.f_197355_().m_45604_();
        int zPos = context.f_197355_().m_45605_();
        int landHeight = Integer.MAX_VALUE;
        for (int i = 2; i >= 1; --i) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                Vector3f offsetPos = direction.m_122432_();
                offsetPos.m_122261_(30.0f * (float)i);
                landHeight = MineshaftEndStructure.getHeightAt(context.f_197352_(), context.f_197357_(), xPos + (int)offsetPos.m_122239_(), zPos + (int)offsetPos.m_122269_(), landHeight);
                if (landHeight - context.f_197352_().m_142062_() >= minThickness) continue;
                return false;
            }
        }
        MineshaftEndStructure.analyzeLand(context.f_197352_(), xPos, zPos, islandTopBottomThickness, context.f_197357_());
        return islandTopBottomThickness.m_123343_() >= minThickness;
    }

    private static int getHeightAt(ChunkGenerator chunkGenerator, LevelHeightAccessor heightLimitView, int xPos, int zPos, int landHeight) {
        landHeight = Math.min(landHeight, chunkGenerator.m_156179_(xPos, zPos, Heightmap.Types.WORLD_SURFACE_WG, heightLimitView));
        return landHeight;
    }

    private static void analyzeLand(ChunkGenerator chunkGenerator, int xPos, int zPos, BlockPos.MutableBlockPos islandTopBottomThickness, LevelHeightAccessor heightLimitView) {
        NoiseColumn columnOfBlocks = chunkGenerator.m_141914_(xPos, zPos, heightLimitView);
        int minY = chunkGenerator.m_142062_();
        int rangeHeight = GeneralUtils.getMaxTerrainLimit(chunkGenerator);
        int maxY = minY + rangeHeight;
        BlockPos.MutableBlockPos currentPos = new BlockPos.MutableBlockPos(xPos, maxY, zPos);
        boolean isInIsland = false;
        while (currentPos.m_123342_() >= minY) {
            BlockState state = columnOfBlocks.m_183556_(currentPos.m_123342_());
            if (!state.m_60795_() && !isInIsland) {
                isInIsland = true;
                int topIslandY = Math.min(currentPos.m_123342_(), islandTopBottomThickness.m_123341_());
                islandTopBottomThickness.m_122178_(topIslandY, islandTopBottomThickness.m_123342_(), islandTopBottomThickness.m_123343_());
            } else if (state.m_60795_() && isInIsland || currentPos.m_123342_() == minY) {
                int bottomIslandY = Math.max(currentPos.m_123342_(), islandTopBottomThickness.m_123342_());
                islandTopBottomThickness.m_122178_(islandTopBottomThickness.m_123341_(), bottomIslandY, islandTopBottomThickness.m_123343_());
                break;
            }
            currentPos.m_122173_(Direction.DOWN);
        }
        if (!isInIsland) {
            islandTopBottomThickness.m_122178_(0, 0, 0);
        }
        int thickness = islandTopBottomThickness.m_123341_() - islandTopBottomThickness.m_123342_();
        islandTopBottomThickness.m_122178_(islandTopBottomThickness.m_123341_(), islandTopBottomThickness.m_123342_(), thickness);
    }

    public static <CC extends RSMineshaftEndConfig> Optional<PieceGenerator<CC>> generateMineshaftEndPieces(PieceGeneratorSupplier.Context<CC> context) {
        RSMineshaftEndConfig config = (RSMineshaftEndConfig)context.f_197356_();
        BlockPos.MutableBlockPos blockpos = new BlockPos.MutableBlockPos(context.f_197355_().m_45604_(), 0, context.f_197355_().m_45605_());
        BlockPos.MutableBlockPos islandTopBottomThickness = new BlockPos.MutableBlockPos(Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE);
        MineshaftEndStructure.analyzeLand(context.f_197352_(), blockpos.m_123341_(), blockpos.m_123343_(), islandTopBottomThickness, context.f_197357_());
        int minThickness = config.minIslandThickness;
        int maxY = 53;
        int minY = 15;
        if (minThickness == 0) {
            blockpos.m_122175_(Direction.UP, 35);
        } else {
            WorldgenRandom random = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
            random.m_190068_(context.f_197354_(), context.f_197355_().f_45578_, context.f_197355_().f_45579_);
            int structureStartHeight = random.nextInt(Math.max(islandTopBottomThickness.m_123343_() - minThickness + 1, 1)) + islandTopBottomThickness.m_123342_() + minThickness / 2;
            blockpos.m_122175_(Direction.UP, structureStartHeight);
            maxY = islandTopBottomThickness.m_123341_() - 5;
            minY = islandTopBottomThickness.m_123342_();
            if (maxY - minY <= 5) {
                minY = maxY - 5;
            }
        }
        int finalMaxY = maxY;
        return PieceLimitedJigsawManager.assembleJigsawStructure(context, new JigsawConfiguration(config.startPool, config.size), GeneralUtils.getCsfNameForConfig(config, context.f_197360_()), (BlockPos)blockpos, false, false, maxY, minY, config.poolsThatIgnoreBoundaries, (structurePiecesBuilder, pieces) -> {
            Optional<PoolElementStructurePiece> highestPiece = pieces.stream().max(Comparator.comparingInt(p -> p.m_73547_().m_162400_()));
            int topY = highestPiece.map(poolElementStructurePiece -> poolElementStructurePiece.m_73547_().m_162400_()).orElseGet(() -> ((BlockPos.MutableBlockPos)blockpos).m_123342_());
            if (topY > finalMaxY) {
                int newOffset = finalMaxY - topY;
                for (StructurePiece piece : pieces) {
                    piece.m_6324_(0, newOffset, 0);
                }
            }
        });
    }
}

