/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.features;

import com.google.common.primitives.Doubles;
import com.mojang.serialization.Codec;
import com.telepathicgrunt.repurposedstructures.utils.OpenSimplex2F;
import com.telepathicgrunt.repurposedstructures.world.features.configs.StructureRangeConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class StructurePowderSnow
extends Feature<StructureRangeConfig> {
    protected long seed;
    private OpenSimplex2F noiseGenerator = null;

    public StructurePowderSnow(Codec<StructureRangeConfig> config) {
        super(config);
    }

    public void setSeed(long seed) {
        if (this.seed != seed || this.noiseGenerator == null) {
            this.noiseGenerator = new OpenSimplex2F(seed);
            this.seed = seed;
        }
    }

    public boolean m_142674_(FeaturePlaceContext<StructureRangeConfig> context) {
        this.setSeed(context.m_159774_().m_7328_());
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        int range = ((StructureRangeConfig)context.m_159778_()).range;
        double thresholds = (double)range / 9.0;
        for (int x = -range; x <= range; ++x) {
            for (int z = -range; z <= range; ++z) {
                BlockState currentState;
                boolean isSnowLayer;
                mutable.m_122190_((Vec3i)context.m_159777_()).m_122184_(x, -1, z);
                double noiseManip = this.noiseGenerator.noise3_Classic((double)mutable.m_123341_() / 8.0, 0.0, (double)mutable.m_123343_() / 8.0);
                double distance = Math.sqrt(x * x + z * z) + noiseManip;
                if (!(distance < (double)range - 0.1)) continue;
                for (int i = 0; i < 2; ++i) {
                    mutable.m_122173_(Direction.DOWN);
                    BlockState belowState = context.m_159774_().m_8055_((BlockPos)mutable);
                    if (!belowState.m_60815_() || belowState.m_60713_(Blocks.f_50125_)) continue;
                    mutable.m_122173_(Direction.UP);
                    break;
                }
                if (!(isSnowLayer = (currentState = context.m_159774_().m_8055_((BlockPos)mutable)).m_60713_(Blocks.f_50125_)) && !currentState.m_60795_() && !currentState.m_60713_(Blocks.f_50127_)) continue;
                int stage = (int)Doubles.constrainToRange((double)(9.0 - distance / thresholds), (double)0.0, (double)9.0);
                if (isSnowLayer) {
                    int originalSnowLayer = (Integer)currentState.m_61143_((Property)SnowLayerBlock.f_56581_);
                    stage = Math.max(stage, originalSnowLayer);
                } else if (currentState.m_60713_(Blocks.f_50127_)) {
                    stage = 9;
                } else if (currentState.m_60713_(Blocks.f_152499_)) {
                    stage = 9;
                }
                BlockState chosenBlock = stage == 9 ? Blocks.f_152499_.m_49966_() : (stage == 8 ? Blocks.f_50127_.m_49966_() : (BlockState)Blocks.f_50125_.m_49966_().m_61124_((Property)SnowLayerBlock.f_56581_, (Comparable)Integer.valueOf((int)Doubles.constrainToRange((double)stage, (double)1.0, (double)8.0))));
                if (!isSnowLayer && !chosenBlock.m_60710_((LevelReader)context.m_159774_(), (BlockPos)mutable)) {
                    mutable.m_122173_(Direction.DOWN);
                    BlockState belowState = context.m_159774_().m_8055_((BlockPos)mutable);
                    if (belowState.m_60713_(Blocks.f_152481_) || belowState.m_60713_(Blocks.f_50126_) || belowState.m_60713_(Blocks.f_152499_)) {
                        context.m_159774_().m_7731_((BlockPos)mutable, Blocks.f_50127_.m_49966_(), 3);
                    }
                    mutable.m_122173_(Direction.UP);
                }
                if (!isSnowLayer && !Blocks.f_50125_.m_7898_(Blocks.f_50125_.m_49966_(), (LevelReader)context.m_159774_(), (BlockPos)mutable)) continue;
                context.m_159774_().m_7731_((BlockPos)mutable, chosenBlock, 3);
            }
        }
        return true;
    }
}

