/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.mixin.features;

import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.mixin.world.WorldGenRegionAccessor;
import com.telepathicgrunt.repurposedstructures.modinit.RSTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.levelgen.feature.BasaltColumnsFeature;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BasaltColumnsFeature.class})
public class NoBasaltColumnsInStructuresMixin {
    @Inject(method={"canPlaceAt(Lnet/minecraft/world/level/LevelAccessor;ILnet/minecraft/core/BlockPos$MutableBlockPos;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private static void repurposedstructures_noBasaltColumnsInStructures(LevelAccessor levelAccessor, int seaLevel, BlockPos.MutableBlockPos mutableBlockPos, CallbackInfoReturnable<Boolean> cir) {
        if (!(levelAccessor instanceof WorldGenRegion)) {
            return;
        }
        SectionPos sectionPos = SectionPos.m_123199_((BlockPos)mutableBlockPos);
        if (!levelAccessor.m_6325_(sectionPos.m_123170_(), sectionPos.m_123222_()).m_6415_().m_62427_(ChunkStatus.f_62316_)) {
            RepurposedStructures.LOGGER.warn("Repurposed Structures: Detected a mod with a broken basalt columns configuredfeature that is trying to place blocks outside the 3x3 safe chunk area for features. Find the broken mod and report to them to fix the placement of their basalt columns feature.");
            return;
        }
        Registry configuredStructureFeatureRegistry = levelAccessor.m_5962_().m_175515_(Registry.f_122882_);
        StructureFeatureManager structureFeatureManager = ((WorldGenRegionAccessor)levelAccessor).getStructureFeatureManager();
        for (Holder configuredStructureFeature : configuredStructureFeatureRegistry.m_203561_(RSTags.NO_BASALT)) {
            if (!structureFeatureManager.m_207785_((BlockPos)mutableBlockPos, (ConfiguredStructureFeature)configuredStructureFeature.m_203334_()).m_73603_()) continue;
            cir.setReturnValue((Object)false);
            return;
        }
    }
}

