/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.traits.harvest;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.event.entity.player.PlayerEvent;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.TooltipKey;

public class MaintainedModifier
extends Modifier {
    private static final Component MINING_SPEED = TConstruct.makeTranslation("modifier", "maintained.mining_speed");
    private static final float BOOST_AT_FULL = 6.0f;
    private static final float MIN_BOOST_PERCENT = 0.5f;

    private static float getTotalBoost(IToolStackView tool, int level) {
        int max;
        float min;
        int durability = tool.getCurrentDurability();
        if ((float)durability > (min = (float)(max = tool.getStats().getInt(ToolStats.DURABILITY)) * 0.5f)) {
            return 6.0f * (float)level * ((float)durability - min) / ((float)max - min);
        }
        return 0.0f;
    }

    @Override
    public void addInformation(IToolStackView tool, int level, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        double boost;
        if (tool.hasTag(TinkerTags.Items.HARVEST) && (boost = tooltipKey == TooltipKey.SHIFT ? (double)MaintainedModifier.getTotalBoost(tool, level) : (double)(6.0f * (float)level)) > (double)0.01f) {
            this.addFlatBoost(MINING_SPEED, boost * (double)tool.getMultiplier(ToolStats.MINING_SPEED), tooltip);
        }
    }

    @Override
    public void onBreakSpeed(IToolStackView tool, int level, PlayerEvent.BreakSpeed event, Direction sideHit, boolean isEffective, float miningSpeedModifier) {
        if (isEffective) {
            event.setNewSpeed(event.getNewSpeed() + MaintainedModifier.getTotalBoost(tool, level) * miningSpeedModifier * tool.getMultiplier(ToolStats.MINING_SPEED));
        }
    }
}

