/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.loot;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.modifiers.traits.skull.ChrysophiliteModifier;

public class ChrysophiliteBonusFunction
extends LootItemConditionalFunction {
    public static final ResourceLocation ID = TConstruct.getResource("chrysophilite_bonus");
    public static final Serializer SERIALIZER = new Serializer();
    private final ApplyBonusCount.Formula formula;
    private final boolean includeBase;

    protected ChrysophiliteBonusFunction(LootItemCondition[] conditions, ApplyBonusCount.Formula formula, boolean includeBase) {
        super(conditions);
        this.formula = formula;
        this.includeBase = includeBase;
    }

    public static LootItemConditionalFunction.Builder<?> builder(ApplyBonusCount.Formula formula, boolean includeBase) {
        return ChrysophiliteBonusFunction.m_80683_(conditions -> new ChrysophiliteBonusFunction((LootItemCondition[])conditions, formula, includeBase));
    }

    public static LootItemConditionalFunction.Builder<?> binomialWithBonusCount(float probability, int extra, boolean includeBase) {
        return ChrysophiliteBonusFunction.builder((ApplyBonusCount.Formula)new ApplyBonusCount.BinomialWithBonusCount(extra, probability), includeBase);
    }

    public static LootItemConditionalFunction.Builder<?> oreDrops(boolean includeBase) {
        return ChrysophiliteBonusFunction.builder((ApplyBonusCount.Formula)new ApplyBonusCount.OreDrops(), includeBase);
    }

    public static LootItemConditionalFunction.Builder<?> uniformBonusCount(int bonusMultiplier, boolean includeBase) {
        return ChrysophiliteBonusFunction.builder((ApplyBonusCount.Formula)new ApplyBonusCount.UniformBonusCount(bonusMultiplier), includeBase);
    }

    protected ItemStack m_7372_(ItemStack stack, LootContext context) {
        int level = ChrysophiliteModifier.getTotalGold((Entity)context.m_78953_(LootContextParams.f_81455_));
        if (!this.includeBase) {
            --level;
        }
        if (level > 0) {
            stack.m_41764_(this.formula.m_6432_(context.m_78933_(), stack.m_41613_(), level));
        }
        return stack;
    }

    public Set<LootContextParam<?>> m_6231_() {
        return ImmutableSet.of((Object)LootContextParams.f_81455_);
    }

    public LootItemFunctionType m_7162_() {
        return TinkerModifiers.chrysophiliteBonusFunction;
    }

    private static class Serializer
    extends LootItemConditionalFunction.Serializer<ChrysophiliteBonusFunction> {
        private Serializer() {
        }

        public void serialize(JsonObject json, ChrysophiliteBonusFunction loot, JsonSerializationContext context) {
            super.m_6170_(json, (LootItemConditionalFunction)loot, context);
            json.addProperty("formula", loot.formula.m_5713_().toString());
            JsonObject parameters = new JsonObject();
            loot.formula.m_6417_(parameters, context);
            if (parameters.size() > 0) {
                json.add("parameters", (JsonElement)parameters);
            }
            json.addProperty("include_base", Boolean.valueOf(loot.includeBase));
        }

        public ChrysophiliteBonusFunction deserialize(JsonObject json, JsonDeserializationContext context, LootItemCondition[] conditions) {
            ResourceLocation id = JsonHelper.getResourceLocation((JsonObject)json, (String)"formula");
            ApplyBonusCount.FormulaDeserializer deserializer = (ApplyBonusCount.FormulaDeserializer)ApplyBonusCount.f_79898_.get(id);
            if (deserializer == null) {
                throw new JsonParseException("Invalid formula id: " + id);
            }
            JsonObject parameters = json.has("parameters") ? GsonHelper.m_13930_((JsonObject)json, (String)"parameters") : new JsonObject();
            ApplyBonusCount.Formula formula = deserializer.m_79970_(parameters, context);
            boolean includeBase = GsonHelper.m_13855_((JsonObject)json, (String)"include_base", (boolean)true);
            return new ChrysophiliteBonusFunction(conditions, formula, includeBase);
        }
    }
}

