/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.defense;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.data.ModifierMaxLevel;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.utils.TooltipKey;
import slimeknights.tconstruct.tools.modifiers.defense.AbstractProtectionModifier;

public class ShulkingModifier
extends AbstractProtectionModifier<ModifierMaxLevel> {
    private static final TinkerDataCapability.TinkerDataKey<ModifierMaxLevel> KEY = TConstruct.createKey("shulking");

    public ShulkingModifier() {
        super(KEY);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, LivingHurtEvent.class, ShulkingModifier::onAttack);
    }

    @Override
    protected ModifierMaxLevel createData() {
        return new ModifierMaxLevel();
    }

    @Override
    public float getProtectionModifier(IToolStackView tool, int level, EquipmentContext context, EquipmentSlot slotType, DamageSource source, float modifierValue) {
        if (context.getEntity().m_6047_() && !source.m_19379_() && !source.m_19378_()) {
            modifierValue += this.getScaledLevel(tool, level) * 2.0f;
        }
        return modifierValue;
    }

    @Override
    public void addInformation(IToolStackView tool, int level, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        AbstractProtectionModifier.addResistanceTooltip(this, tool, level, 2.0f, tooltip);
    }

    private static void onAttack(LivingHurtEvent event) {
        Entity attacker = event.getSource().m_7639_();
        if (attacker != null && attacker.m_6047_()) {
            attacker.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(data -> {
                ModifierMaxLevel max = data.get(KEY);
                if (max != null) {
                    event.setAmount(event.getAmount() * (1.0f - max.getMax() * 0.1f));
                }
            });
        }
    }
}

