/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.ability.tool;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import slimeknights.mantle.util.OffhandCooldownTracker;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.impl.NoLevelsModifier;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.context.ToolRebuildContext;
import slimeknights.tconstruct.library.tools.helper.ToolAttackUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class OffhandAttackModifier
extends NoLevelsModifier {
    public static final ResourceLocation DUEL_WIELDING = TConstruct.getResource("duel_wielding");

    @Override
    public int getPriority() {
        return 90;
    }

    @Override
    public boolean shouldDisplay(boolean advanced) {
        return false;
    }

    @Override
    public void addVolatileData(ToolRebuildContext context, int level, ModDataNBT volatileData) {
        volatileData.putBoolean(DUEL_WIELDING, true);
    }

    protected boolean canAttack(IToolStackView tool, Player player, InteractionHand hand) {
        return hand == InteractionHand.OFF_HAND && OffhandCooldownTracker.isAttackReady((Player)player);
    }

    @Override
    public InteractionResult beforeEntityUse(IToolStackView tool, int level, Player player, Entity target, InteractionHand hand, EquipmentSlot slotType) {
        if (this.canAttack(tool, player, hand)) {
            if (!player.f_19853_.m_5776_()) {
                ToolAttackUtil.attackEntity(tool, (LivingEntity)player, InteractionHand.OFF_HAND, target, ToolAttackUtil.getCooldownFunction(player, InteractionHand.OFF_HAND), false, slotType);
            }
            OffhandCooldownTracker.applyCooldown((Player)player, (float)tool.getStats().get(ToolStats.ATTACK_SPEED).floatValue(), (int)20);
            OffhandCooldownTracker.swingHand((LivingEntity)player, (InteractionHand)InteractionHand.OFF_HAND, (boolean)false);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    @Override
    public InteractionResult onToolUse(IToolStackView tool, int level, Level world, Player player, InteractionHand hand, EquipmentSlot slotType) {
        if (this.canAttack(tool, player, hand)) {
            OffhandCooldownTracker.applyCooldown((Player)player, (float)tool.getStats().get(ToolStats.ATTACK_SPEED).floatValue(), (int)20);
            OffhandCooldownTracker.swingHand((LivingEntity)player, (InteractionHand)InteractionHand.OFF_HAND, (boolean)false);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    @Override
    public void onEquip(IToolStackView tool, int level, EquipmentChangeContext context) {
        if (!tool.isBroken() && context.getChangedSlot() == EquipmentSlot.OFFHAND) {
            context.getEntity().getCapability(OffhandCooldownTracker.CAPABILITY).ifPresent(cap -> cap.setEnabled(true));
        }
    }

    @Override
    public void onUnequip(IToolStackView tool, int level, EquipmentChangeContext context) {
        if (!tool.isBroken() && context.getChangedSlot() == EquipmentSlot.OFFHAND) {
            context.getEntity().getCapability(OffhandCooldownTracker.CAPABILITY).ifPresent(cap -> cap.setEnabled(false));
        }
    }
}

