/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block.entity.controller;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import slimeknights.mantle.block.entity.MantleBlockEntity;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.controller.ControllerBlock;
import slimeknights.tconstruct.smeltery.block.entity.controller.HeatingStructureBlockEntity;
import slimeknights.tconstruct.smeltery.block.entity.module.ByproductMeltingModuleInventory;
import slimeknights.tconstruct.smeltery.block.entity.module.MeltingModuleInventory;
import slimeknights.tconstruct.smeltery.block.entity.multiblock.FoundryMultiblock;
import slimeknights.tconstruct.smeltery.block.entity.multiblock.HeatingStructureMultiblock;

public class FoundryBlockEntity
extends HeatingStructureBlockEntity {
    private static final int CAPACITY_PER_BLOCK = 720;
    private static final Component NAME = TConstruct.makeTranslation("gui", "foundry");
    private static final int BLOCKS_PER_FUEL = 18;

    public FoundryBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType<? extends HeatingStructureBlockEntity>)((BlockEntityType)TinkerSmeltery.foundry.get()), pos, state, NAME);
    }

    @Override
    protected HeatingStructureMultiblock<?> createMultiblock() {
        return new FoundryMultiblock(this);
    }

    @Override
    protected MeltingModuleInventory createMeltingInventory() {
        return new ByproductMeltingModuleInventory((MantleBlockEntity)this, this.tank, Config.COMMON.foundryOreRate);
    }

    @Override
    protected boolean isDebugItem(ItemStack stack) {
        return stack.m_204117_(TinkerTags.Items.FOUNDRY_DEBUG);
    }

    @Override
    protected void heat() {
        if (this.structure == null || this.f_58857_ == null) {
            return;
        }
        if (this.structure.hasTanks()) {
            boolean entityMelted = false;
            if (this.tick == 12) {
                entityMelted = this.entityModule.interactWithEntities();
            }
            switch (this.tick % 4) {
                case 0: {
                    if (this.fuelModule.hasFuel()) break;
                    if (entityMelted) {
                        this.fuelModule.findFuel(true);
                        break;
                    }
                    if (!this.meltingInventory.canHeat(this.fuelModule.findFuel(false))) break;
                    this.fuelModule.findFuel(true);
                    break;
                }
                case 1: {
                    if (this.fuelModule.hasFuel()) {
                        this.meltingInventory.heatItems(this.fuelModule.getTemperature());
                        break;
                    }
                    this.meltingInventory.coolItems();
                    break;
                }
                case 3: {
                    boolean hasFuel = this.fuelModule.hasFuel();
                    BlockState state = this.m_58900_();
                    if ((Boolean)state.m_61143_((Property)ControllerBlock.ACTIVE) != hasFuel) {
                        this.f_58857_.m_46597_(this.f_58858_, (BlockState)state.m_61124_((Property)ControllerBlock.ACTIVE, (Comparable)Boolean.valueOf(hasFuel)));
                    }
                    this.fuelModule.decreaseFuel(this.fuelRate);
                    break;
                }
            }
        }
    }

    @Override
    protected void setStructure(@Nullable HeatingStructureMultiblock.StructureData structure) {
        super.setStructure(structure);
        if (structure != null) {
            int dx = structure.getInnerX();
            int dy = structure.getInnerY();
            int dz = structure.getInnerZ();
            this.tank.setCapacity(720 * (dx + 2) * (dy + 1) * (dz + 2));
            this.meltingInventory.resize(dx * dy * dz, this.dropItem);
            this.fuelRate = 1 + (2 * ((dx + 2) * dy) + 2 * (dy * dz) + (dx + 2) * (dz + 2)) / 18;
        }
    }
}

