/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared.command.subcommand;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.mutable.MutableInt;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierRecipeLookup;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierRequirements;
import slimeknights.tconstruct.library.recipe.tinkerstation.ValidatedResult;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.shared.command.HeldModifiableItemIterator;
import slimeknights.tconstruct.shared.command.argument.ModifierArgument;

public class ModifiersCommand {
    private static final String ADD_SUCCESS = TConstruct.makeTranslationKey("command", "modifiers.success.add.single");
    private static final String ADD_SUCCESS_MULTIPLE = TConstruct.makeTranslationKey("command", "modifiers.success.add.multiple");
    private static final String REMOVE_SUCCESS = TConstruct.makeTranslationKey("command", "modifiers.success.remove.single");
    private static final String REMOVE_SUCCESS_MULTIPLE = TConstruct.makeTranslationKey("command", "modifiers.success.remove.multiple");
    private static final DynamicCommandExceptionType MODIFIER_ERROR = new DynamicCommandExceptionType(error -> (Component)error);
    private static final Dynamic2CommandExceptionType CANNOT_REMOVE = new Dynamic2CommandExceptionType((name, entity) -> TConstruct.makeTranslation("command", "modifiers.failure.too_few_levels", name, entity));

    public static void register(LiteralArgumentBuilder<CommandSourceStack> subCommand) {
        ((LiteralArgumentBuilder)subCommand.requires(sender -> sender.m_6761_(2))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).then(Commands.m_82127_((String)"add").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"modifier", (ArgumentType)ModifierArgument.modifier()).executes(context -> ModifiersCommand.add((CommandContext<CommandSourceStack>)context, 1))).then(Commands.m_82129_((String)"level", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> ModifiersCommand.add((CommandContext<CommandSourceStack>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"level"))))))).then(Commands.m_82127_((String)"remove").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"modifier", (ArgumentType)ModifierArgument.modifier()).executes(context -> ModifiersCommand.remove((CommandContext<CommandSourceStack>)context, -1))).then(Commands.m_82129_((String)"level", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> ModifiersCommand.remove((CommandContext<CommandSourceStack>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"level")))))));
    }

    private static int add(CommandContext<CommandSourceStack> context, int level) throws CommandSyntaxException {
        Modifier modifier = ModifierArgument.getModifier(context, "modifier");
        List<LivingEntity> successes = HeldModifiableItemIterator.apply(context, (living, stack) -> {
            ToolStack tool = ToolStack.from(stack);
            int currentLevel = tool.getModifierLevel(modifier);
            List<ModifierEntry> modifiers = tool.getModifierList();
            for (ModifierRequirements requirements : ModifierRecipeLookup.getRequirements(modifier.getId())) {
                ValidatedResult result = requirements.check(stack, level + currentLevel, modifiers);
                if (!result.hasError()) continue;
                throw MODIFIER_ERROR.create((Object)result.getMessage());
            }
            tool = tool.copy();
            tool.addModifier(modifier.getId(), level);
            ValidatedResult toolValidation = tool.validate();
            if (toolValidation.hasError()) {
                throw MODIFIER_ERROR.create((Object)toolValidation.getMessage());
            }
            living.m_21008_(InteractionHand.MAIN_HAND, tool.createStack(stack.m_41613_()));
            return true;
        });
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        int size = successes.size();
        if (size == 1) {
            source.m_81354_((Component)new TranslatableComponent(ADD_SUCCESS, new Object[]{modifier.getDisplayName(level), successes.get(0).m_5446_()}), true);
        } else {
            source.m_81354_((Component)new TranslatableComponent(ADD_SUCCESS_MULTIPLE, new Object[]{modifier.getDisplayName(level), size}), true);
        }
        return size;
    }

    private static int remove(CommandContext<CommandSourceStack> context, int level) throws CommandSyntaxException {
        Modifier modifier = ModifierArgument.getModifier(context, "modifier");
        MutableInt maxRemove = new MutableInt(1);
        List<LivingEntity> successes = HeldModifiableItemIterator.apply(context, (living, stack) -> {
            int removeLevel;
            ToolStack tool = ToolStack.from(stack);
            int currentLevel = tool.getUpgrades().getLevel(modifier.getId());
            if (currentLevel == 0) {
                throw CANNOT_REMOVE.create((Object)modifier.getDisplayName(level), (Object)living.m_7755_());
            }
            int n = removeLevel = level == -1 ? currentLevel : level;
            if (removeLevel > maxRemove.intValue()) {
                maxRemove.setValue(removeLevel);
            }
            tool = tool.copy();
            int newLevel = currentLevel - removeLevel;
            if (newLevel <= 0) {
                modifier.beforeRemoved(tool, tool.getRestrictedNBT());
            }
            tool.removeModifier(modifier.getId(), removeLevel);
            ValidatedResult validated = tool.validate();
            if (validated.hasError()) {
                throw MODIFIER_ERROR.create((Object)validated.getMessage());
            }
            if (newLevel <= 0) {
                modifier.onRemoved(tool);
            }
            if (newLevel <= 0 && (validated = modifier.validate(tool, 0)).hasError()) {
                throw MODIFIER_ERROR.create((Object)validated.getMessage());
            }
            ItemStack resultStack = tool.createStack(stack.m_41613_());
            validated = ModifierRecipeLookup.checkRequirements(resultStack, tool);
            if (validated.hasError()) {
                throw MODIFIER_ERROR.create((Object)validated.getMessage());
            }
            living.m_21008_(InteractionHand.MAIN_HAND, tool.createStack(stack.m_41613_()));
            return true;
        });
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        int size = successes.size();
        if (size == 1) {
            source.m_81354_((Component)new TranslatableComponent(REMOVE_SUCCESS, new Object[]{modifier.getDisplayName(maxRemove.intValue()), successes.get(0).m_5446_()}), true);
        } else {
            source.m_81354_((Component)new TranslatableComponent(REMOVE_SUCCESS_MULTIPLE, new Object[]{modifier.getDisplayName(maxRemove.intValue()), size}), true);
        }
        return size;
    }
}

