/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared.block;

import java.util.Locale;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.MaterialColor;
import slimeknights.tconstruct.common.TinkerTags;

public enum SlimeType implements StringRepresentable
{
    EARTH(118094, 9230210, Tiers.STONE, MaterialColor.f_76399_, false),
    SKY(117709, 62682, Tiers.GOLD, MaterialColor.f_76367_, false),
    ICHOR(16750349, 13670400, Tiers.IRON, MaterialColor.f_76413_, true, 10),
    ENDER(11488502, 11087359, Tiers.DIAMOND, MaterialColor.f_76422_, false),
    BLOOD(11862273, 0xB80000, Tiers.WOOD, MaterialColor.f_76364_, true);

    public static final SlimeType[] TINKER;
    public static final SlimeType[] TRUE_SLIME;
    public static final SlimeType[] LIQUID;
    public static final SlimeType[] OVERWORLD;
    public static final SlimeType[] NETHER;
    private final int color;
    private final int defaultFoliageColor;
    private final Tiers harvestTier;
    private final MaterialColor mapColor;
    private final boolean nether;
    private final int lightLevel;
    private final TagKey<Block> dirtBlockTag;
    private final TagKey<Block> grassBlockTag;
    private final TagKey<Item> slimeballTag;

    private SlimeType(int color, int defaultFoliageColor, Tiers harvestTier, MaterialColor mapColor, boolean nether, int lightLevel) {
        this.color = color;
        this.defaultFoliageColor = defaultFoliageColor;
        this.harvestTier = harvestTier;
        this.mapColor = mapColor;
        this.nether = nether;
        this.lightLevel = lightLevel;
        String name = this.m_7912_();
        this.grassBlockTag = TinkerTags.Blocks.tag((nether ? "slimy_nylium/" : "slimy_grass/") + name);
        this.dirtBlockTag = TinkerTags.Blocks.tag("slimy_soil/" + ("blood".equals(name) ? "vanilla" : name));
        this.slimeballTag = TinkerTags.Items.forgeTag("slimeball/" + name);
    }

    private SlimeType(int color, int defaultFoliageColor, Tiers harvestTier, MaterialColor mapColor, boolean nether) {
        this(color, defaultFoliageColor, harvestTier, mapColor, nether, 0);
    }

    public String m_7912_() {
        return this.name().toLowerCase(Locale.US);
    }

    public int getColor() {
        return this.color;
    }

    public int getDefaultFoliageColor() {
        return this.defaultFoliageColor;
    }

    public Tiers getHarvestTier() {
        return this.harvestTier;
    }

    public MaterialColor getMapColor() {
        return this.mapColor;
    }

    public boolean isNether() {
        return this.nether;
    }

    public int getLightLevel() {
        return this.lightLevel;
    }

    public TagKey<Block> getDirtBlockTag() {
        return this.dirtBlockTag;
    }

    public TagKey<Block> getGrassBlockTag() {
        return this.grassBlockTag;
    }

    public TagKey<Item> getSlimeballTag() {
        return this.slimeballTag;
    }

    static {
        TINKER = new SlimeType[]{SKY, ENDER, BLOOD, ICHOR};
        TRUE_SLIME = new SlimeType[]{EARTH, SKY, ENDER, ICHOR};
        LIQUID = new SlimeType[]{EARTH, SKY, BLOOD, ENDER};
        OVERWORLD = new SlimeType[]{EARTH, SKY, ENDER};
        NETHER = new SlimeType[]{ICHOR, BLOOD};
    }
}

