/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jei.entity;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import slimeknights.tconstruct.plugin.jei.TConstructJEIConstants;

public class EntityIngredientHelper
implements IIngredientHelper<EntityType> {
    public IIngredientType<EntityType> getIngredientType() {
        return TConstructJEIConstants.ENTITY_TYPE;
    }

    @Nullable
    public EntityType getMatch(Iterable<EntityType> iterable, EntityType type, UidContext context) {
        for (EntityType match : iterable) {
            if (match != type) continue;
            return match;
        }
        return null;
    }

    public String getDisplayName(EntityType type) {
        return type.m_20676_().getString();
    }

    public String getUniqueId(EntityType type, UidContext context) {
        return Objects.requireNonNull(type.getRegistryName()).toString();
    }

    @Deprecated
    public String getModId(EntityType type) {
        return this.getResourceLocation(type).m_135827_();
    }

    @Deprecated
    public String getResourceId(EntityType type) {
        return this.getResourceLocation(type).m_135815_();
    }

    public ResourceLocation getResourceLocation(EntityType type) {
        return Objects.requireNonNull(type.getRegistryName());
    }

    public EntityType copyIngredient(EntityType type) {
        return type;
    }

    public String getErrorInfo(@Nullable EntityType type) {
        if (type == null) {
            return "null";
        }
        ResourceLocation name = type.getRegistryName();
        if (name == null) {
            return "unnamed sadface :(";
        }
        return name.toString();
    }

    public static List<EntityType> applyFocus(RecipeIngredientRole role, List<EntityType> displayInputs, IFocusGroup focuses) {
        return focuses.getFocuses(VanillaTypes.ITEM).filter(focus -> focus.getRole() == role).map(focus -> ((ItemStack)focus.getTypedValue().getIngredient()).m_41720_()).filter(item -> item instanceof SpawnEggItem).map(item -> ((SpawnEggItem)item).m_43228_(null)).filter(displayInputs::contains).map(Collections::singletonList).findFirst().orElse(displayInputs);
    }
}

