/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.utils;

import java.util.IdentityHashMap;
import javax.annotation.Nullable;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import slimeknights.tconstruct.common.Sounds;

public class SlimeBounceHandler {
    private static final IdentityHashMap<Entity, BounceInfo> BOUNCING_ENTITIES = new IdentityHashMap();

    private SlimeBounceHandler() {
    }

    public static void init() {
        MinecraftForge.EVENT_BUS.addListener(SlimeBounceHandler::onLivingTick);
        MinecraftForge.EVENT_BUS.addListener(SlimeBounceHandler::serverStopping);
    }

    public static void addBounceHandler(LivingEntity entity) {
        SlimeBounceHandler.addBounceHandler(entity, null);
    }

    public static void addBounceHandler(LivingEntity entity, @Nullable Vec3 bounce) {
        if (entity instanceof FakePlayer) {
            return;
        }
        BounceInfo info = BOUNCING_ENTITIES.get(entity);
        if (info == null) {
            BOUNCING_ENTITIES.put((Entity)entity, new BounceInfo(entity, bounce));
        } else if (bounce != null) {
            info.bounce = bounce;
            info.bounceTick = entity.f_19797_ + 1;
            Vec3 motion = entity.m_20184_();
            info.lastMagSq = motion.f_82479_ * motion.f_82479_ + motion.f_82481_ * motion.f_82481_;
            info.lastAngle = Mth.m_14136_((double)motion.f_82481_, (double)motion.f_82479_);
        }
    }

    private static void onLivingTick(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entity = event.getEntityLiving();
        BounceInfo info = BOUNCING_ENTITIES.get(entity);
        if (info != null) {
            boolean isInAir;
            if (entity.m_21255_() || entity.m_5833_()) {
                BOUNCING_ENTITIES.remove(entity);
                return;
            }
            if (entity.f_19797_ == info.bounceTick) {
                if (info.bounce != null) {
                    entity.m_20256_(info.bounce);
                    info.bounce = null;
                }
                info.bounceTick = 0;
            }
            boolean bl = isInAir = !entity.m_20096_() && !entity.m_20069_() && !entity.m_6147_();
            if (isInAir && info.lastMagSq > 0.0) {
                Vec3 motion = entity.m_20184_();
                double motionSq = motion.f_82479_ * motion.f_82479_ + motion.f_82481_ * motion.f_82481_;
                if (motionSq == 0.0) {
                    if (info.stopMagTick == 0) {
                        info.stopMagTick = entity.f_19797_ + 5;
                    } else if (entity.f_19797_ > info.stopMagTick) {
                        info.lastMagSq = 0.0;
                    }
                } else if (motionSq < info.lastMagSq) {
                    info.stopMagTick = 0;
                    double boost = Math.sqrt(info.lastMagSq / motionSq) * (double)0.975f;
                    if (boost > 1.0) {
                        entity.m_20334_(motion.f_82479_ * boost, motion.f_82480_, motion.f_82481_ * boost);
                        entity.f_19812_ = true;
                        info.lastMagSq = info.lastMagSq * (double)0.975f * (double)0.975f;
                        double newAngle = Mth.m_14136_((double)motion.f_82481_, (double)motion.f_82479_);
                        if (Math.abs(newAngle - info.lastAngle) > 1.0) {
                            entity.m_5496_(Sounds.SLIMY_BOUNCE.getSound(), 1.0f, 1.0f);
                        }
                        info.lastAngle = newAngle;
                    } else {
                        info.lastMagSq = motionSq;
                        info.lastAngle = Mth.m_14136_((double)motion.f_82481_, (double)motion.f_82479_);
                    }
                }
            }
            if (info.wasInAir && !isInAir) {
                if (info.endHandler == 0) {
                    info.endHandler = entity.f_19797_ + 5;
                } else if (entity.f_19797_ > info.endHandler) {
                    BOUNCING_ENTITIES.remove(entity);
                }
            } else {
                info.endHandler = 0;
                info.wasInAir = true;
            }
        }
    }

    private static void serverStopping(ServerStoppingEvent event) {
        BOUNCING_ENTITIES.clear();
    }

    private static class BounceInfo {
        @Nullable
        private Vec3 bounce;
        private int bounceTick;
        private int stopMagTick;
        private double lastMagSq;
        private boolean wasInAir = false;
        private int endHandler = 0;
        private double lastAngle;

        public BounceInfo(LivingEntity entity, @Nullable Vec3 bounce) {
            this.bounce = bounce;
            this.bounceTick = bounce != null ? entity.f_19797_ + 1 : 0;
            Vec3 motion = entity.m_20184_();
            this.lastMagSq = motion.f_82479_ * motion.f_82479_ + motion.f_82481_ * motion.f_82481_;
        }
    }
}

