/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.nbt;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStatId;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class StatsNBT {
    public static Serializer SERIALIZER = new Serializer();
    static final Set<String> ERRORED_IDS = new HashSet<String>();
    public static final StatsNBT EMPTY = new StatsNBT((Map<IToolStat<?>, Object>)ImmutableMap.of());
    private final Map<IToolStat<?>, Object> stats;

    public static Builder builder() {
        return new Builder();
    }

    public Set<IToolStat<?>> getContainedStats() {
        return this.stats.keySet();
    }

    public boolean hasStat(IToolStat<?> stat) {
        return this.stats.containsKey(stat);
    }

    public <T> T get(IToolStat<T> stat) {
        return (T)this.stats.getOrDefault(stat, stat.getDefaultValue());
    }

    public int getInt(IToolStat<? extends Number> stat) {
        return this.get(stat).intValue();
    }

    @Nullable
    static IToolStat<?> readStatIdFromNBT(String name) {
        IToolStat<?> stat;
        ToolStatId statName = ToolStatId.tryCreate(name);
        if (statName != null && (stat = ToolStats.getToolStat(statName)) != null) {
            return stat;
        }
        if (!ERRORED_IDS.contains(name)) {
            ERRORED_IDS.add(name);
            TConstruct.LOG.error("Ignoring unknown stat " + name + " in tool stat NBT");
        }
        return null;
    }

    public static StatsNBT readFromNBT(@Nullable Tag inbt) {
        if (inbt == null || inbt.m_7060_() != 10) {
            return EMPTY;
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        CompoundTag nbt = (CompoundTag)inbt;
        for (String key : nbt.m_128431_()) {
            Object value;
            IToolStat<?> stat;
            Tag tag = nbt.m_128423_(key);
            if (tag == null || (stat = StatsNBT.readStatIdFromNBT(key)) == null || (value = stat.read(tag)) == null) continue;
            builder.put(stat, value);
        }
        return new StatsNBT((Map<IToolStat<?>, Object>)builder.build());
    }

    @Nullable
    private static <T> Tag serialize(IToolStat<T> stat, Object value) {
        return stat.write(value);
    }

    public CompoundTag serializeToNBT() {
        CompoundTag nbt = new CompoundTag();
        for (Map.Entry<IToolStat<?>, Object> entry : this.stats.entrySet()) {
            IToolStat<?> stat = entry.getKey();
            Tag serialized = StatsNBT.serialize(stat, entry.getValue());
            if (serialized == null) continue;
            nbt.m_128365_(stat.getName().toString(), serialized);
        }
        return nbt;
    }

    private static <T> void toNetwork(FriendlyByteBuf buffer, IToolStat<T> stat, Object value) {
        stat.toNetwork(buffer, value);
    }

    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.stats.size());
        for (Map.Entry<IToolStat<?>, Object> entry : this.stats.entrySet()) {
            IToolStat<?> stat = entry.getKey();
            buffer.m_130070_(stat.getName().toString());
            StatsNBT.toNetwork(buffer, stat, entry.getValue());
        }
    }

    public static StatsNBT fromNetwork(FriendlyByteBuf buffer) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        int max = buffer.m_130242_();
        for (int i = 0; i < max; ++i) {
            IToolStat<?> stat = ToolStats.fromNetwork(buffer);
            builder.put(stat, stat.fromNetwork(buffer));
        }
        return new StatsNBT((Map<IToolStat<?>, Object>)builder.build());
    }

    StatsNBT(Map<IToolStat<?>, Object> stats) {
        this.stats = stats;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StatsNBT)) {
            return false;
        }
        StatsNBT other = (StatsNBT)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<IToolStat<?>, Object> this$stats = this.stats;
        Map<IToolStat<?>, Object> other$stats = other.stats;
        return !(this$stats == null ? other$stats != null : !((Object)this$stats).equals(other$stats));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StatsNBT;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<IToolStat<?>, Object> $stats = this.stats;
        result = result * 59 + ($stats == null ? 43 : ((Object)$stats).hashCode());
        return result;
    }

    public String toString() {
        return "StatsNBT(stats=" + this.stats + ")";
    }

    public static class Builder {
        private final ImmutableMap.Builder<IToolStat<?>, Object> builder = ImmutableMap.builder();

        public <T> Builder set(IToolStat<T> stat, T value) {
            this.builder.put(stat, stat.clamp(value));
            return this;
        }

        public StatsNBT build() {
            ImmutableMap map = this.builder.build();
            if (map.isEmpty()) {
                return EMPTY;
            }
            return new StatsNBT((Map<IToolStat<?>, Object>)map);
        }

        private Builder() {
        }
    }

    protected static class Serializer
    implements JsonDeserializer<StatsNBT>,
    JsonSerializer<StatsNBT> {
        protected Serializer() {
        }

        public StatsNBT deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject object = GsonHelper.m_13918_((JsonElement)json, (String)"stats");
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Map.Entry entry : object.entrySet()) {
                IToolStat<?> stat = ToolStats.fromJson((String)entry.getKey());
                builder.put(stat, stat.deserialize((JsonElement)entry.getValue()));
            }
            return new StatsNBT((Map<IToolStat<?>, Object>)builder.build());
        }

        private static <T> JsonElement serialize(IToolStat<T> stat, Object value) {
            return stat.serialize(value);
        }

        public JsonElement serialize(StatsNBT stats, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject json = new JsonObject();
            for (Map.Entry<IToolStat<?>, Object> entry : stats.stats.entrySet()) {
                IToolStat<?> stat = entry.getKey();
                json.add(stat.getName().toString(), Serializer.serialize(stat, entry.getValue()));
            }
            return json;
        }
    }
}

