/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.definition.harvest;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.json.predicate.IJsonPredicate;
import slimeknights.tconstruct.library.json.predicate.block.BlockPredicate;
import slimeknights.tconstruct.library.json.predicate.block.SetBlockPredicate;
import slimeknights.tconstruct.library.json.predicate.block.TagBlockPredicate;
import slimeknights.tconstruct.library.tools.definition.harvest.IHarvestLogic;
import slimeknights.tconstruct.library.tools.definition.harvest.TagHarvestLogic;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public class ModifiedHarvestLogic
extends TagHarvestLogic {
    public static final Loader LOADER = new Loader();
    private final SpeedModifier[] speedModifiers;

    protected ModifiedHarvestLogic(TagKey<Block> tag, SpeedModifier[] speedModifiers) {
        super(tag);
        this.speedModifiers = speedModifiers;
    }

    public static Builder builder(TagKey<Block> tag) {
        return new Builder(tag);
    }

    @Override
    public GenericLoaderRegistry.IGenericLoader<? extends IHarvestLogic> getLoader() {
        return LOADER;
    }

    @Override
    public float getDestroySpeed(IToolStackView tool, BlockState state) {
        float speed = super.getDestroySpeed(tool, state);
        for (SpeedModifier modifier : this.speedModifiers) {
            if (!modifier.predicate.matches(state)) continue;
            return Math.max(1.0f, speed * modifier.modifier);
        }
        return speed;
    }

    private static class SpeedModifier {
        protected final float modifier;
        protected final IJsonPredicate<BlockState> predicate;

        public JsonObject toJson() {
            JsonObject json = new JsonObject();
            json.addProperty("modifier", (Number)Float.valueOf(this.modifier));
            json.add("predicate", BlockPredicate.LOADER.serialize(this.predicate));
            return json;
        }

        public void toNetwork(FriendlyByteBuf buffer) {
            buffer.writeFloat(this.modifier);
            BlockPredicate.LOADER.toNetwork(this.predicate, buffer);
        }

        private static SpeedModifier fromJson(JsonObject json) {
            float modifier = GsonHelper.m_13915_((JsonObject)json, (String)"modifier");
            IJsonPredicate predicate = (IJsonPredicate)BlockPredicate.LOADER.deserialize((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"predicate"));
            return new SpeedModifier(modifier, predicate);
        }

        private static SpeedModifier fromNetwork(FriendlyByteBuf buffer) {
            float modifier = buffer.readFloat();
            IJsonPredicate predicate = (IJsonPredicate)BlockPredicate.LOADER.fromNetwork(buffer);
            return new SpeedModifier(modifier, predicate);
        }

        public SpeedModifier(float modifier, IJsonPredicate<BlockState> predicate) {
            this.modifier = modifier;
            this.predicate = predicate;
        }
    }

    public static class Builder {
        private final TagKey<Block> tag;
        private final List<SpeedModifier> speedModifiers = new ArrayList<SpeedModifier>();

        public Builder addModifier(float modifier, IJsonPredicate<BlockState> predicate) {
            this.speedModifiers.add(new SpeedModifier(modifier, predicate));
            return this;
        }

        public Builder tagModifier(TagKey<Block> tag, float modifier) {
            return this.addModifier(modifier, new TagBlockPredicate(tag));
        }

        public Builder notTagModifier(TagKey<Block> tag, float modifier) {
            return this.addModifier(modifier, new TagBlockPredicate(tag).inverted());
        }

        public Builder blockModifier(float modifier, Block ... blocks) {
            return this.addModifier(modifier, new SetBlockPredicate((Set<Block>)ImmutableSet.copyOf((Object[])blocks)));
        }

        public Builder notBlockModifier(float modifier, Block ... blocks) {
            return this.addModifier(modifier, new SetBlockPredicate((Set<Block>)ImmutableSet.copyOf((Object[])blocks)).inverted());
        }

        public ModifiedHarvestLogic build() {
            return new ModifiedHarvestLogic(this.tag, this.speedModifiers.toArray(new SpeedModifier[0]));
        }

        protected Builder(TagKey<Block> tag) {
            this.tag = tag;
        }
    }

    private static class Loader
    implements GenericLoaderRegistry.IGenericLoader<ModifiedHarvestLogic> {
        private Loader() {
        }

        public ModifiedHarvestLogic deserialize(JsonObject json) {
            TagKey tag = TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)JsonHelper.getResourceLocation((JsonObject)json, (String)"effective"));
            SpeedModifier[] modifiers = JsonHelper.parseList((JsonObject)json, (String)"modifiers", SpeedModifier::fromJson).toArray(new SpeedModifier[0]);
            return new ModifiedHarvestLogic((TagKey<Block>)tag, modifiers);
        }

        public ModifiedHarvestLogic fromNetwork(FriendlyByteBuf buffer) {
            TagKey tag = TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)buffer.m_130281_());
            SpeedModifier[] modifiers = new SpeedModifier[buffer.m_130242_()];
            for (int i = 0; i < modifiers.length; ++i) {
                modifiers[i] = SpeedModifier.fromNetwork(buffer);
            }
            return new ModifiedHarvestLogic((TagKey<Block>)tag, modifiers);
        }

        public void serialize(ModifiedHarvestLogic object, JsonObject json) {
            json.addProperty("effective", object.tag.f_203868_().toString());
            JsonArray modifiers = new JsonArray();
            for (SpeedModifier modifier : object.speedModifiers) {
                modifiers.add((JsonElement)modifier.toJson());
            }
            json.add("modifiers", (JsonElement)modifiers);
        }

        public void toNetwork(ModifiedHarvestLogic object, FriendlyByteBuf buffer) {
            buffer.m_130085_(object.tag.f_203868_());
            buffer.m_130130_(object.speedModifiers.length);
            for (SpeedModifier modifier : object.speedModifiers) {
                modifier.toNetwork(buffer);
            }
        }
    }
}

