/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.capability;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.capability.ToolCapabilityProvider;
import slimeknights.tconstruct.library.tools.nbt.IModDataView;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;

public class ToolFluidCapability
implements IFluidHandlerItem {
    public static final ResourceLocation TOTAL_TANKS = TConstruct.getResource("total_tanks");
    private final ItemStack container;
    private final Supplier<? extends IToolStackView> tool;

    public int getTanks() {
        return this.tool.get().getVolatileData().getInt(TOTAL_TANKS);
    }

    private <T> T runForTank(int tank, T defaultValue, ITankCallback<T> function) {
        IToolStackView tool = this.tool.get();
        for (ModifierEntry entry : tool.getModifierList()) {
            IFluidModifier fluidModifier = entry.getModifier().getModule(IFluidModifier.class);
            if (fluidModifier == null) continue;
            int currentTanks = fluidModifier.getTanks(tool.getVolatileData());
            if (tank < currentTanks) {
                return function.run(fluidModifier, tool, entry.getLevel(), tank);
            }
            tank -= currentTanks;
        }
        return defaultValue;
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        return this.runForTank(tank, FluidStack.EMPTY, IFluidModifier::getFluidInTank);
    }

    public int getTankCapacity(int tank) {
        return this.runForTank(tank, 0, IFluidModifier::getTankCapacity);
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return this.runForTank(tank, false, (module, tool, level, tank1) -> module.isFluidValid(tool, level, tank1, stack));
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        int totalFilled = 0;
        IToolStackView tool = this.tool.get();
        for (ModifierEntry entry : tool.getModifierList()) {
            int filled;
            IFluidModifier fluidModifier = entry.getModifier().getModule(IFluidModifier.class);
            if (fluidModifier == null || (filled = fluidModifier.fill(tool, entry.getLevel(), resource, action)) <= 0) continue;
            if (filled >= resource.getAmount()) {
                return totalFilled + filled;
            }
            if (totalFilled == 0) {
                resource = resource.copy();
            }
            totalFilled += filled;
            resource.shrink(filled);
        }
        return totalFilled;
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        FluidStack drainedSoFar = FluidStack.EMPTY;
        IToolStackView tool = this.tool.get();
        for (ModifierEntry entry : tool.getModifierList()) {
            FluidStack drained;
            IFluidModifier fluidModifier = entry.getModifier().getModule(IFluidModifier.class);
            if (fluidModifier == null || (drained = fluidModifier.drain(tool, entry.getLevel(), resource, action)).isEmpty()) continue;
            if (drainedSoFar.isEmpty()) {
                if (drained.getAmount() >= resource.getAmount()) {
                    return drained;
                }
                drainedSoFar = drained;
                resource = resource.copy();
            } else {
                drainedSoFar.grow(drained.getAmount());
            }
            resource.shrink(drained.getAmount());
            if (!resource.isEmpty()) continue;
            return drainedSoFar;
        }
        return drainedSoFar;
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        FluidStack drainedSoFar = FluidStack.EMPTY;
        FluidStack toDrain = FluidStack.EMPTY;
        IToolStackView tool = this.tool.get();
        for (ModifierEntry entry : tool.getModifierList()) {
            FluidStack drained;
            IFluidModifier fluidModifier = entry.getModifier().getModule(IFluidModifier.class);
            if (fluidModifier == null) continue;
            if (toDrain.isEmpty()) {
                drained = fluidModifier.drain(tool, entry.getLevel(), maxDrain, action);
                if (drained.isEmpty()) continue;
                if ((maxDrain -= drained.getAmount()) > 0) {
                    drainedSoFar = drained;
                    toDrain = new FluidStack(drained, maxDrain);
                    continue;
                }
                return drained;
            }
            drained = fluidModifier.drain(tool, entry.getLevel(), toDrain, action);
            if (drained.isEmpty()) continue;
            drainedSoFar.grow(drained.getAmount());
            toDrain.shrink(drained.getAmount());
            if (!toDrain.isEmpty()) continue;
            return drainedSoFar;
        }
        return drainedSoFar;
    }

    public static void addTanks(ModDataNBT volatileData, IFluidModifier modifier) {
        volatileData.putInt(TOTAL_TANKS, modifier.getTanks(volatileData) + volatileData.getInt(TOTAL_TANKS));
    }

    public ToolFluidCapability(ItemStack container, Supplier<? extends IToolStackView> tool) {
        this.container = container;
        this.tool = tool;
    }

    public ItemStack getContainer() {
        return this.container;
    }

    public static interface IFluidModifier {
        default public int getTanks(IModDataView volatileData) {
            return 0;
        }

        default public FluidStack getFluidInTank(IToolStackView tool, int level, int tank) {
            return FluidStack.EMPTY;
        }

        default public int getTankCapacity(IToolStackView tool, int level, int tank) {
            return 0;
        }

        default public boolean isFluidValid(IToolStackView tool, int level, int tank, FluidStack fluid) {
            return true;
        }

        public int fill(IToolStackView var1, int var2, FluidStack var3, IFluidHandler.FluidAction var4);

        public FluidStack drain(IToolStackView var1, int var2, FluidStack var3, IFluidHandler.FluidAction var4);

        public FluidStack drain(IToolStackView var1, int var2, int var3, IFluidHandler.FluidAction var4);
    }

    @FunctionalInterface
    private static interface ITankCallback<T> {
        public T run(IFluidModifier var1, IToolStackView var2, int var3, int var4);
    }

    public static class Provider
    implements ToolCapabilityProvider.IToolCapabilityProvider {
        private final LazyOptional<IFluidHandlerItem> fluidCap = LazyOptional.of(() -> new ToolFluidCapability(stack, toolStack));

        public Provider(ItemStack stack, Supplier<? extends IToolStackView> toolStack) {
        }

        @Override
        public <T> LazyOptional<T> getCapability(IToolStackView tool, Capability<T> cap) {
            if (cap == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY && tool.getVolatileData().getInt(TOTAL_TANKS) > 0) {
                return this.fluidCap.cast();
            }
            return LazyOptional.empty();
        }
    }
}

