/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.tinkerstation.repairing;

import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.tables.TinkerTables;

public class SpecializedRepairRecipeBuilder
extends AbstractRecipeBuilder<SpecializedRepairRecipeBuilder> {
    private final Ingredient tool;
    private final MaterialId repairMaterial;

    public static SpecializedRepairRecipeBuilder repair(ItemLike item, MaterialId repairMaterial) {
        return SpecializedRepairRecipeBuilder.repair(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}), repairMaterial);
    }

    public void save(Consumer<FinishedRecipe> consumer) {
        this.save(consumer, this.repairMaterial);
    }

    public SpecializedRepairRecipeBuilder buildRepairKit(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        ResourceLocation advancementId = this.buildOptionalAdvancement(id, "tinker_station");
        consumer.accept((FinishedRecipe)new Finished(id, advancementId, (RecipeSerializer)TinkerTables.specializedRepairKitSerializer.get()));
        return this;
    }

    public void save(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        ResourceLocation advancementId = this.buildOptionalAdvancement(id, "tinker_station");
        consumer.accept((FinishedRecipe)new Finished(id, advancementId, (RecipeSerializer)TinkerTables.specializedRepairSerializer.get()));
    }

    private SpecializedRepairRecipeBuilder(Ingredient tool, MaterialId repairMaterial) {
        this.tool = tool;
        this.repairMaterial = repairMaterial;
    }

    public static SpecializedRepairRecipeBuilder repair(Ingredient tool, MaterialId repairMaterial) {
        return new SpecializedRepairRecipeBuilder(tool, repairMaterial);
    }

    private class Finished
    extends AbstractRecipeBuilder.AbstractFinishedRecipe {
        private final RecipeSerializer<?> type;

        public Finished(@Nullable ResourceLocation ID, ResourceLocation advancementID, RecipeSerializer<?> type) {
            super((AbstractRecipeBuilder)SpecializedRepairRecipeBuilder.this, ID, advancementID);
            this.type = type;
        }

        public void m_7917_(JsonObject json) {
            json.add("tool", SpecializedRepairRecipeBuilder.this.tool.m_43942_());
            json.addProperty("repair_material", SpecializedRepairRecipeBuilder.this.repairMaterial.toString());
        }

        public RecipeSerializer<?> m_6637_() {
            return this.type;
        }
    }
}

