/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.tinkerstation.repairing;

import com.mojang.datafixers.util.Pair;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.recipe.tinkerstation.repairing.SpecializedRepairRecipeSerializer;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tables.TinkerTables;
import slimeknights.tconstruct.tables.recipe.CraftingTableRepairKitRecipe;

public class SpecializedRepairKitRecipe
extends CraftingTableRepairKitRecipe
implements SpecializedRepairRecipeSerializer.ISpecializedRepairRecipe {
    private final Ingredient tool;
    private final MaterialId repairMaterial;

    public SpecializedRepairKitRecipe(ResourceLocation id, Ingredient tool, MaterialId repairMaterial) {
        super(id);
        this.tool = tool;
        this.repairMaterial = repairMaterial;
    }

    @Override
    protected boolean toolMatches(ItemStack stack) {
        return this.tool.test(stack);
    }

    @Override
    public boolean matches(CraftingContainer inv, Level worldIn) {
        Pair<ToolStack, MaterialId> inputs = this.getRelevantInputs(inv);
        return inputs != null && this.repairMaterial.equals(inputs.getSecond());
    }

    @Override
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerTables.specializedRepairKitSerializer.get();
    }

    @Override
    public Ingredient getTool() {
        return this.tool;
    }

    @Override
    public MaterialId getRepairMaterial() {
        return this.repairMaterial;
    }
}

