/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.tinkerstation.repairing;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import slimeknights.mantle.recipe.helper.LoggingRecipeSerializer;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.modifiers.ModifierId;

public class ModifierRepairRecipeSerializer<T extends Recipe<?> & IModifierRepairRecipe>
extends LoggingRecipeSerializer<T> {
    private final IFactory<T> factory;

    public T m_6729_(ResourceLocation id, JsonObject json) {
        ModifierId modifier = ModifierId.getFromJson(json, "modifier");
        Ingredient ingredient = Ingredient.m_43917_((JsonElement)JsonHelper.getElement((JsonObject)json, (String)"ingredient"));
        int repairAmount = GsonHelper.m_13927_((JsonObject)json, (String)"repair_amount");
        return this.factory.create(id, modifier, ingredient, repairAmount);
    }

    @Nullable
    protected T fromNetworkSafe(ResourceLocation id, FriendlyByteBuf buffer) {
        ModifierId modifier = ModifierId.fromNetwork(buffer);
        Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        int repairAmount = buffer.m_130242_();
        return this.factory.create(id, modifier, ingredient, repairAmount);
    }

    protected void toNetworkSafe(FriendlyByteBuf buffer, T recipe) {
        ((IModifierRepairRecipe)recipe).getModifier().toNetwork(buffer);
        ((IModifierRepairRecipe)recipe).getIngredient().m_43923_(buffer);
        buffer.m_130130_(((IModifierRepairRecipe)recipe).getRepairAmount());
    }

    public ModifierRepairRecipeSerializer(IFactory<T> factory) {
        this.factory = factory;
    }

    @FunctionalInterface
    public static interface IFactory<T extends Recipe<?> & IModifierRepairRecipe> {
        public T create(ResourceLocation var1, ModifierId var2, Ingredient var3, int var4);
    }

    public static interface IModifierRepairRecipe {
        public ModifierId getModifier();

        public Ingredient getIngredient();

        public int getRepairAmount();
    }
}

