/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.partbuilder;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import slimeknights.mantle.recipe.IMultiRecipe;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.mantle.recipe.helper.LoggingRecipeSerializer;
import slimeknights.mantle.recipe.helper.RecipeHelper;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialVariant;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.recipe.material.MaterialRecipe;
import slimeknights.tconstruct.library.recipe.partbuilder.IPartBuilderContainer;
import slimeknights.tconstruct.library.recipe.partbuilder.IPartBuilderRecipe;
import slimeknights.tconstruct.library.recipe.partbuilder.ItemPartRecipe;
import slimeknights.tconstruct.library.recipe.partbuilder.Pattern;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;
import slimeknights.tconstruct.tables.TinkerTables;

public class PartRecipe
implements IPartBuilderRecipe,
IMultiRecipe<ItemPartRecipe> {
    protected final ResourceLocation id;
    protected final String group;
    protected final Pattern pattern;
    protected final Ingredient patternItem;
    protected final int cost;
    protected final IMaterialItem output;
    protected final int outputCount;
    @Nullable
    private List<ItemPartRecipe> multiRecipes;

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerTables.partRecipeSerializer.get();
    }

    @Override
    public boolean partialMatch(IPartBuilderContainer inv) {
        if (!this.patternItem.test(inv.getPatternStack())) {
            return false;
        }
        if (!inv.getStack().m_41619_()) {
            MaterialRecipe materialRecipe = inv.getMaterial();
            if (materialRecipe == null) {
                return false;
            }
            MaterialVariant material = materialRecipe.getMaterial();
            return material.get().isCraftable() && this.output.canUseMaterial(material.getId());
        }
        return true;
    }

    public boolean matches(IPartBuilderContainer inv, Level world) {
        MaterialRecipe materialRecipe = inv.getMaterial();
        if (materialRecipe != null) {
            MaterialVariant material = materialRecipe.getMaterial();
            return material.get().isCraftable() && this.output.canUseMaterial(material.getId()) && inv.getStack().m_41613_() >= materialRecipe.getItemsUsed(this.cost);
        }
        return false;
    }

    @Deprecated
    public ItemStack m_8043_() {
        return new ItemStack((ItemLike)this.output);
    }

    public ItemStack getRecipeOutput(MaterialVariantId material) {
        ItemStack stack = this.output.withMaterial(material);
        stack.m_41764_(this.outputCount);
        return stack;
    }

    public ItemStack assemble(IPartBuilderContainer inv) {
        MaterialVariant material = MaterialVariant.UNKNOWN;
        MaterialRecipe materialRecipe = inv.getMaterial();
        if (materialRecipe != null) {
            material = materialRecipe.getMaterial();
        }
        return this.getRecipeOutput(material.getVariant());
    }

    public List<ItemPartRecipe> getRecipes() {
        if (this.multiRecipes == null) {
            this.multiRecipes = MaterialRegistry.getMaterials().stream().filter(mat -> mat.isCraftable() && this.output.canUseMaterial((IMaterial)mat)).map(mat -> {
                MaterialId materialId = mat.getIdentifier();
                return new ItemPartRecipe(materialId, mat.getIdentifier(), this.pattern, this.patternItem, this.getCost(), ItemOutput.fromStack((ItemStack)this.output.withMaterial(materialId)));
            }).collect(Collectors.toList());
        }
        return this.multiRecipes;
    }

    public PartRecipe(ResourceLocation id, String group, Pattern pattern, Ingredient patternItem, int cost, IMaterialItem output, int outputCount) {
        this.id = id;
        this.group = group;
        this.pattern = pattern;
        this.patternItem = patternItem;
        this.cost = cost;
        this.output = output;
        this.outputCount = outputCount;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public String m_6076_() {
        return this.group;
    }

    @Override
    public Pattern getPattern() {
        return this.pattern;
    }

    @Override
    public int getCost() {
        return this.cost;
    }

    public static class Serializer
    extends LoggingRecipeSerializer<PartRecipe> {
        public PartRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            Pattern pattern = new Pattern(GsonHelper.m_13906_((JsonObject)json, (String)"pattern"));
            Ingredient patternItem = json.has("pattern_item") ? Ingredient.m_43917_((JsonElement)json.get("pattern_item")) : Ingredient.m_204132_(TinkerTags.Items.DEFAULT_PATTERNS);
            int cost = GsonHelper.m_13927_((JsonObject)json, (String)"cost");
            JsonObject output = GsonHelper.m_13930_((JsonObject)json, (String)"result");
            IMaterialItem item = (IMaterialItem)RecipeHelper.deserializeItem((String)GsonHelper.m_13906_((JsonObject)output, (String)"item"), (String)"result", IMaterialItem.class);
            int count = GsonHelper.m_13824_((JsonObject)output, (String)"count", (int)1);
            return new PartRecipe(recipeId, group, pattern, patternItem, cost, item, count);
        }

        @Nullable
        protected PartRecipe fromNetworkSafe(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            String group = buffer.m_130136_(Short.MAX_VALUE);
            Pattern pattern = new Pattern(buffer.m_130136_(Short.MAX_VALUE));
            Ingredient patternItem = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            int cost = buffer.readInt();
            IMaterialItem item = (IMaterialItem)RecipeHelper.readItem((FriendlyByteBuf)buffer, IMaterialItem.class);
            byte count = buffer.readByte();
            return new PartRecipe(recipeId, group, pattern, patternItem, cost, item, count);
        }

        protected void toNetworkSafe(FriendlyByteBuf buffer, PartRecipe recipe) {
            buffer.m_130070_(recipe.group);
            buffer.m_130070_(recipe.pattern.toString());
            recipe.patternItem.m_43923_(buffer);
            buffer.writeInt(recipe.cost);
            RecipeHelper.writeItem((FriendlyByteBuf)buffer, (ItemLike)recipe.output);
            buffer.writeByte(recipe.outputCount);
        }
    }
}

