/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.partbuilder;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.mantle.recipe.helper.LoggingRecipeSerializer;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.materials.definition.MaterialVariant;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.recipe.material.MaterialRecipe;
import slimeknights.tconstruct.library.recipe.partbuilder.IDisplayPartBuilderRecipe;
import slimeknights.tconstruct.library.recipe.partbuilder.IPartBuilderContainer;
import slimeknights.tconstruct.library.recipe.partbuilder.Pattern;
import slimeknights.tconstruct.tables.TinkerTables;

public class ItemPartRecipe
implements IDisplayPartBuilderRecipe {
    private final ResourceLocation id;
    private final MaterialVariant material;
    private final Pattern pattern;
    private final Ingredient patternItem;
    private final int cost;
    private final ItemOutput result;

    public ItemPartRecipe(ResourceLocation id, MaterialVariantId material, Pattern pattern, Ingredient patternItem, int cost, ItemOutput result) {
        this.id = id;
        this.material = MaterialVariant.of(material);
        this.pattern = pattern;
        this.patternItem = patternItem;
        this.cost = cost;
        this.result = result;
    }

    @Override
    public boolean partialMatch(IPartBuilderContainer inv) {
        if (!this.patternItem.test(inv.getPatternStack())) {
            return false;
        }
        if (!inv.getStack().m_41619_()) {
            MaterialRecipe materialRecipe = inv.getMaterial();
            return materialRecipe != null && this.material.matchesVariant(materialRecipe.getMaterial());
        }
        return true;
    }

    public boolean matches(IPartBuilderContainer inv, Level worldIn) {
        MaterialRecipe materialRecipe = inv.getMaterial();
        return materialRecipe != null && this.material.matchesVariant(materialRecipe.getMaterial()) && inv.getStack().m_41613_() >= materialRecipe.getItemsUsed(this.cost);
    }

    public ItemStack m_8043_() {
        return this.result.get();
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerTables.itemPartBuilderSerializer.get();
    }

    @Override
    public List<ItemStack> getPatternItems() {
        return Arrays.asList(this.patternItem.m_43908_());
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Override
    public MaterialVariant getMaterial() {
        return this.material;
    }

    @Override
    public Pattern getPattern() {
        return this.pattern;
    }

    @Override
    public int getCost() {
        return this.cost;
    }

    public static class Serializer
    extends LoggingRecipeSerializer<ItemPartRecipe> {
        public ItemPartRecipe fromJson(ResourceLocation id, JsonObject json) {
            MaterialVariantId materialId = MaterialVariantId.fromJson(json, "material");
            Pattern pattern = new Pattern(GsonHelper.m_13906_((JsonObject)json, (String)"pattern"));
            Ingredient patternItem = json.has("pattern_item") ? Ingredient.m_43917_((JsonElement)json.get("pattern_item")) : Ingredient.m_204132_(TinkerTags.Items.DEFAULT_PATTERNS);
            int cost = GsonHelper.m_13927_((JsonObject)json, (String)"cost");
            ItemOutput result = ItemOutput.fromJson((JsonElement)JsonHelper.getElement((JsonObject)json, (String)"result"));
            return new ItemPartRecipe(id, materialId, pattern, patternItem, cost, result);
        }

        @Nullable
        protected ItemPartRecipe fromNetworkSafe(ResourceLocation id, FriendlyByteBuf buffer) {
            MaterialVariantId materialId = MaterialVariantId.parse(buffer.m_130136_(Short.MAX_VALUE));
            Pattern pattern = new Pattern(buffer.m_130136_(Short.MAX_VALUE));
            Ingredient patternItem = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            int cost = buffer.m_130242_();
            ItemOutput result = ItemOutput.read((FriendlyByteBuf)buffer);
            return new ItemPartRecipe(id, materialId, pattern, patternItem, cost, result);
        }

        protected void toNetworkSafe(FriendlyByteBuf buffer, ItemPartRecipe recipe) {
            buffer.m_130070_(recipe.material.getVariant().toString());
            buffer.m_130070_(recipe.pattern.toString());
            recipe.patternItem.m_43923_(buffer);
            buffer.m_130130_(recipe.cost);
            recipe.result.write(buffer);
        }
    }
}

