/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.adding;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.items.ItemHandlerHelper;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.impl.IncrementalModifier;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierMatch;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierRecipeLookup;
import slimeknights.tconstruct.library.recipe.modifiers.adding.AbstractModifierRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.IMutableTinkerStationContainer;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationContainer;
import slimeknights.tconstruct.library.recipe.tinkerstation.ValidatedResult;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class IncrementalModifierRecipe
extends AbstractModifierRecipe {
    private final Ingredient input;
    private final int amountPerInput;
    private final int neededPerLevel;
    private final ItemStack leftover;
    private List<List<ItemStack>> slotCache;

    public IncrementalModifierRecipe(ResourceLocation id, Ingredient input, int amountPerInput, int neededPerLevel, Ingredient toolRequirement, int maxToolSize, ModifierMatch requirements, String requirementsError, ModifierEntry result, int maxLevel, @Nullable SlotType.SlotCount slots, ItemStack leftover) {
        super(id, toolRequirement, maxToolSize, requirements, requirementsError, result, maxLevel, slots);
        this.input = input;
        this.amountPerInput = amountPerInput;
        this.neededPerLevel = neededPerLevel;
        this.leftover = leftover;
        ModifierRecipeLookup.setNeededPerLevel(result.getId(), neededPerLevel);
    }

    @Override
    public boolean matches(ITinkerStationContainer inv, Level level) {
        if (!this.result.isBound() || !this.toolRequirement.test(inv.getTinkerableStack())) {
            return false;
        }
        return IncrementalModifierRecipe.containsOnlyIngredient(inv, this.input);
    }

    @Override
    public ValidatedResult getValidatedResult(ITinkerStationContainer inv) {
        ValidatedResult commonError;
        ItemStack tinkerable = inv.getTinkerableStack();
        ToolStack tool = ToolStack.from(tinkerable);
        ModifierId modifier = this.result.getId();
        int current = tool.getUpgrades().getLevel(modifier) == 0 ? this.neededPerLevel : IncrementalModifier.getAmount(tool, modifier);
        if (current >= this.neededPerLevel && (commonError = this.validatePrerequisites(tool)).hasError()) {
            return commonError;
        }
        int available = IncrementalModifierRecipe.getAvailableAmount(inv, this.input, this.amountPerInput);
        tool = tool.copy();
        ModDataNBT persistentData = tool.getPersistentData();
        if (current >= this.neededPerLevel) {
            SlotType.SlotCount slots = this.getSlots();
            if (slots != null) {
                persistentData.addSlots(slots.getType(), -slots.getCount());
            }
            IncrementalModifier.setAmount(persistentData, modifier, Math.min(available + current - this.neededPerLevel, this.neededPerLevel));
            tool.addModifier(this.result.getId(), this.result.getLevel());
        } else {
            IncrementalModifier.setAmount(persistentData, modifier, Math.min(current + available, this.neededPerLevel));
            tool.rebuildStats();
        }
        return ValidatedResult.success(tool.createStack(Math.min(tinkerable.m_41613_(), this.shrinkToolSlotBy())));
    }

    @Override
    public void updateInputs(ItemStack result, IMutableTinkerStationContainer inv, boolean isServer) {
        ToolStack inputTool = ToolStack.from(inv.getTinkerableStack());
        ToolStack resultTool = ToolStack.from(result);
        ModifierId modifier = this.result.getId();
        int needed = IncrementalModifier.getAmount(resultTool, modifier);
        int originalLevel = inputTool.getModifierLevel(modifier);
        needed = originalLevel > 0 ? (needed -= IncrementalModifier.getAmount(inputTool, modifier)) : (needed -= this.neededPerLevel);
        int levelChange = resultTool.getModifierLevel(modifier) - originalLevel;
        if (levelChange > 0) {
            needed += levelChange * this.neededPerLevel / this.result.getLevel();
        }
        if (needed > 0) {
            IncrementalModifierRecipe.updateInputs(inv, this.input, needed, this.amountPerInput, this.leftover);
        }
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerModifiers.incrementalModifierSerializer.get();
    }

    @Override
    public boolean isIncremental() {
        return true;
    }

    private List<List<ItemStack>> getInputs() {
        if (this.slotCache == null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            List<ItemStack> items = Arrays.asList(this.input.m_43908_());
            int maxStackSize = items.stream().mapToInt(ItemStack::m_41741_).min().orElse(64);
            int needed = this.neededPerLevel / this.amountPerInput;
            if (this.neededPerLevel % this.amountPerInput > 0) {
                ++needed;
            }
            Lazy fullSize = Lazy.of(() -> items.stream().map(stack -> ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)maxStackSize)).collect(Collectors.toList()));
            while (needed > maxStackSize) {
                builder.add((Object)((List)fullSize.get()));
                needed -= maxStackSize;
            }
            if (needed > 0) {
                int remaining = needed;
                builder.add(items.stream().map(stack -> ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)remaining)).collect(Collectors.toList()));
            }
            this.slotCache = builder.build();
        }
        return this.slotCache;
    }

    @Override
    public int getInputCount() {
        return this.getInputs().size();
    }

    @Override
    public List<ItemStack> getDisplayItems(int slot) {
        List<List<ItemStack>> inputs = this.getInputs();
        if (slot >= 0 && slot < inputs.size()) {
            return inputs.get(slot);
        }
        return Collections.emptyList();
    }

    public static boolean containsOnlyIngredient(ITinkerStationContainer inv, Ingredient ingredient) {
        boolean found = false;
        for (int i = 0; i < inv.getInputCount(); ++i) {
            ItemStack stack = inv.getInput(i);
            if (stack.m_41619_()) continue;
            if (ingredient.test(stack)) {
                found = true;
                continue;
            }
            return false;
        }
        return found;
    }

    public static int getAvailableAmount(ITinkerStationContainer inv, Ingredient ingredient, int amountPerItem) {
        int available = 0;
        for (int i = 0; i < inv.getInputCount(); ++i) {
            ItemStack stack = inv.getInput(i);
            if (stack.m_41619_() || !ingredient.test(stack)) continue;
            available += stack.m_41613_() * amountPerItem;
        }
        return available;
    }

    public static void updateInputs(IMutableTinkerStationContainer inv, Ingredient ingredient, int amountNeeded, int amountPerInput, ItemStack leftover) {
        int itemsNeeded = amountNeeded / amountPerInput;
        int leftoverAmount = amountNeeded % amountPerInput;
        if (leftoverAmount > 0) {
            ++itemsNeeded;
            if (!leftover.m_41619_()) {
                inv.giveItem(ItemHandlerHelper.copyStackWithSize((ItemStack)leftover, (int)(leftoverAmount * leftover.m_41613_())));
            }
        }
        for (int i = 0; i < inv.getInputCount(); ++i) {
            ItemStack stack = inv.getInput(i);
            if (stack.m_41619_() || !ingredient.test(stack)) continue;
            int count = stack.m_41613_();
            if (count > itemsNeeded) {
                inv.shrinkInput(i, itemsNeeded);
                break;
            }
            inv.shrinkInput(i, count);
            itemsNeeded -= count;
        }
    }

    public static ItemStack deseralizeResultItem(JsonObject parent, String name) {
        JsonElement element = JsonHelper.getElement((JsonObject)parent, (String)name);
        if (element.isJsonPrimitive()) {
            return new ItemStack((ItemLike)GsonHelper.m_13874_((JsonElement)element, (String)name));
        }
        return CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13918_((JsonElement)element, (String)name), (boolean)true);
    }

    public static class Serializer
    extends AbstractModifierRecipe.Serializer<IncrementalModifierRecipe> {
        @Override
        public IncrementalModifierRecipe fromJson(ResourceLocation id, JsonObject json, Ingredient toolRequirement, int maxToolSize, ModifierMatch requirements, String requirementsError, ModifierEntry result, int maxLevel, @Nullable SlotType.SlotCount slots) {
            Ingredient input = Ingredient.m_43917_((JsonElement)JsonHelper.getElement((JsonObject)json, (String)"input"));
            int amountPerInput = GsonHelper.m_13824_((JsonObject)json, (String)"amount_per_item", (int)1);
            if (amountPerInput < 1) {
                throw new JsonSyntaxException("amount_per_item must be positive");
            }
            int neededPerLevel = GsonHelper.m_13927_((JsonObject)json, (String)"needed_per_level");
            if (neededPerLevel <= amountPerInput) {
                throw new JsonSyntaxException("needed_per_level must be greater than amount_per_item");
            }
            ItemStack leftover = ItemStack.f_41583_;
            if (amountPerInput > 1 && json.has("leftover")) {
                leftover = IncrementalModifierRecipe.deseralizeResultItem(json, "leftover");
            }
            return new IncrementalModifierRecipe(id, input, amountPerInput, neededPerLevel, toolRequirement, maxToolSize, requirements, requirementsError, result, maxLevel, slots, leftover);
        }

        @Override
        public IncrementalModifierRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buffer, Ingredient toolRequirement, int maxToolSize, ModifierMatch requirements, String requirementsError, ModifierEntry result, int maxLevel, @Nullable SlotType.SlotCount slots) {
            Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            int amountPerInput = buffer.m_130242_();
            int neededPerLevel = buffer.m_130242_();
            ItemStack leftover = buffer.m_130267_();
            return new IncrementalModifierRecipe(id, input, amountPerInput, neededPerLevel, toolRequirement, maxToolSize, requirements, requirementsError, result, maxLevel, slots, leftover);
        }

        @Override
        protected void toNetworkSafe(FriendlyByteBuf buffer, IncrementalModifierRecipe recipe) {
            super.toNetworkSafe(buffer, recipe);
            recipe.input.m_43923_(buffer);
            buffer.m_130130_(recipe.amountPerInput);
            buffer.m_130130_(recipe.neededPerLevel);
            buffer.m_130055_(recipe.leftover);
        }
    }
}

